/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Predicate;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Condition {
    static final int c_OP_AND = 0;
    static final int c_OP_OR = 1;
    static final int c_OP_NOT = 2;
    static final int c_OP_NONE = 3;
    private final int m_operation;
    private final Condition[] m_Condition;
    private final Predicate[] m_Predicate;

    Condition(Element elem) throws XaclException {
        int i;
        String op = elem.getAttribute("operation");
        this.m_operation = op.equals("and") ? 0 : (op.equals("or") ? 1 : (op.equals("not") ? 2 : 3));
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "condition");
        int size = vec.size();
        if (size > 0) {
            this.m_Condition = new Condition[size];
            for (i = 0; i < size; ++i) {
                this.m_Condition[i] = new Condition((Element)vec.elementAt(i));
            }
        } else {
            this.m_Condition = null;
        }
        if ((size = (vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "predicate")).size()) > 0) {
            this.m_Predicate = new Predicate[size];
            for (i = 0; i < size; ++i) {
                this.m_Predicate[i] = new Predicate((Element)vec.elementAt(i));
            }
        } else {
            this.m_Predicate = null;
        }
        if ((size = this.m_Condition != null && this.m_Predicate != null ? this.m_Condition.length + this.m_Predicate.length : (this.m_Condition != null && this.m_Predicate == null ? this.m_Condition.length : (this.m_Condition == null && this.m_Predicate != null ? this.m_Predicate.length : 0))) == 0) {
            throw new XaclException(301, "during importing a condition (NULL CONDITION)");
        }
        if (this.m_operation == 2 && size != 1) {
            throw new XaclException(301, "during importing a NOT condition");
        }
    }

    boolean evaluate(AccessRequest accessReq, Node query, DOMHandler targetDocHandler, Element status, Object context) throws XaclException {
        if (this.m_operation == 0) {
            int i;
            if (this.m_Condition != null) {
                for (i = 0; i < this.m_Condition.length; ++i) {
                    if (this.m_Condition[i].evaluate(accessReq, query, targetDocHandler, status, context)) continue;
                    return false;
                }
            }
            if (this.m_Predicate != null) {
                for (i = 0; i < this.m_Predicate.length; ++i) {
                    if (this.m_Predicate[i].evaluate(accessReq, query, targetDocHandler, status, context)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.m_operation == 1) {
            int i;
            if (this.m_Predicate != null) {
                for (i = 0; i < this.m_Predicate.length; ++i) {
                    if (!this.m_Predicate[i].evaluate(accessReq, query, targetDocHandler, status, context)) continue;
                    return true;
                }
            }
            if (this.m_Condition != null) {
                for (i = 0; i < this.m_Condition.length; ++i) {
                    if (!this.m_Condition[i].evaluate(accessReq, query, targetDocHandler, status, context)) continue;
                    return true;
                }
            }
            return false;
        }
        if (this.m_operation == 2) {
            if (this.m_Predicate != null) {
                return !this.m_Predicate[0].evaluate(accessReq, query, targetDocHandler, status, context);
            }
            if (this.m_Condition != null) {
                return !this.m_Condition[0].evaluate(accessReq, query, targetDocHandler, status, context);
            }
            return false;
        }
        if (this.m_operation == 3) {
            throw new XaclException(301, "(" + this.m_operation + ")");
        }
        return false;
    }
}

