/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.Acl;
import com.ibm.xml.policy.xacl.Parameter;
import com.ibm.xml.policy.xacl.ProvisionalAction;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class Action {
    private final Element m_ThisElement;
    private final Acl m_Acl;
    private final String m_Name;
    private final String m_Permission;
    private final Parameter[] m_Parameter;
    private final ProvisionalAction[] m_PAction;

    Action(Element elem, Acl acl) throws XaclException {
        int i;
        this.m_Acl = acl;
        this.m_ThisElement = elem;
        this.m_Name = elem.getAttribute("name");
        this.m_Permission = elem.getAttribute("permission");
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "parameter");
        int size = vec.size();
        if (size > 0) {
            this.m_Parameter = new Parameter[size];
            for (i = 0; i < size; ++i) {
                this.m_Parameter[i] = new Parameter((Element)vec.elementAt(i));
            }
        } else {
            this.m_Parameter = null;
        }
        if ((size = (vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "provisional_action")).size()) > 0) {
            this.m_PAction = new ProvisionalAction[size];
            for (i = 0; i < size; ++i) {
                this.m_PAction[i] = new ProvisionalAction((Element)vec.elementAt(i), this);
            }
        } else {
            this.m_PAction = null;
        }
    }

    public String getName() {
        return this.m_Name;
    }

    Acl getAcl() {
        return this.m_Acl;
    }

    public Parameter[] getParameters() {
        return this.m_Parameter;
    }

    String getPermission() {
        return this.m_Permission;
    }

    ProvisionalAction[] getProvisionalActions() {
        return this.m_PAction;
    }

    Element createElement(Document doc) {
        int i;
        Element elem = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "action");
        elem.setAttribute("name", this.m_Name);
        if (this.m_Permission != null && !this.m_Permission.equals("")) {
            elem.setAttribute("permission", this.m_Permission);
        }
        if (this.m_Parameter != null) {
            for (i = 0; i < this.m_Parameter.length; ++i) {
                elem.appendChild(doc.importNode(this.m_Parameter[i].getElement(), true));
            }
        }
        if (this.m_PAction != null) {
            for (i = 0; i < this.m_PAction.length; ++i) {
                Element enf = this.m_PAction[i].createElement(doc);
                if (enf == null) continue;
                elem.appendChild(enf);
            }
        }
        NamedNodeMap map = this.m_ThisElement.getAttributes();
        for (i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            elem.setAttribute(attr.getName(), attr.getNodeValue());
        }
        return elem;
    }
}

