/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.AccessRequest;
import com.ibm.xml.policy.xacl.AclList;
import com.ibm.xml.policy.xacl.Action;
import com.ibm.xml.policy.xacl.Condition;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.KeyTuple;
import com.ibm.xml.policy.xacl.Policy;
import com.ibm.xml.policy.xacl.Rule;
import com.ibm.xml.policy.xacl.Subject;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Acl {
    private static final boolean debug = false;
    private final Rule m_Rule;
    private final String m_Id;
    private final short m_Precedence;
    private final Subject[] m_Subject;
    private final Action[] m_Action;
    private final Condition m_Condition;
    private Hashtable m_ActionName2Action;

    Acl(Element elem, Rule rule) throws XaclException {
        int i;
        this.m_Rule = rule;
        this.m_ActionName2Action = new Hashtable();
        this.m_Id = elem.getAttribute("id");
        this.m_Precedence = elem.getAttribute("precedence") == null || elem.getAttribute("precedence").equals("") ? this.m_Rule.getPrecedenceValue() : new Short(elem.getAttribute("precedence")).shortValue();
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "subject");
        int size = vec.size();
        if (size > 0) {
            this.m_Subject = new Subject[size];
            for (i = 0; i < size; ++i) {
                this.m_Subject[i] = new Subject((Element)vec.elementAt(i), this);
            }
        } else {
            this.m_Subject = null;
        }
        if ((size = (vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "action")).size()) > 0) {
            this.m_Action = new Action[size];
            for (i = 0; i < size; ++i) {
                this.m_Action[i] = new Action((Element)vec.elementAt(i), this);
                this.m_ActionName2Action.put(this.m_Action[i].getName(), this.m_Action[i]);
            }
        } else {
            this.m_Action = null;
        }
        for (i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (!this.m_Action[i].getName().equals(this.m_Action[j].getName())) continue;
                throw new XaclException(212, null);
            }
        }
        for (i = 0; i < size; ++i) {
            this.m_Rule.putAcl(this.m_Action[i].getName(), this);
        }
        vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "condition");
        this.m_Condition = vec.size() > 0 ? new Condition((Element)vec.elementAt(0)) : null;
    }

    Rule getRule() {
        return this.m_Rule;
    }

    Condition getCondition() {
        return this.m_Condition;
    }

    short getPrecedenceValue() {
        return this.m_Precedence;
    }

    Subject[] getSubjects() {
        return this.m_Subject;
    }

    Action[] getActions() {
        return this.m_Action;
    }

    Action getAction(String name) {
        return (Action)this.m_ActionName2Action.get(name);
    }

    String getID() {
        return this.m_Id;
    }

    void matching(AccessRequest accessReq, Node query, AclList aclList, DOMHandler targetDocHandler, Element status, Hierarchy roleHierarchy, Hierarchy groupHierarchy, Object context, String searched_permission) throws XaclException {
        boolean cond_result = false;
        boolean subj_result = false;
        boolean acl_result = false;
        if (this.m_Subject != null) {
            for (int i = 0; i < this.m_Subject.length; ++i) {
                if (!this.m_Subject[i].matching(accessReq, roleHierarchy, groupHierarchy)) continue;
                subj_result = true;
                break;
            }
        } else {
            subj_result = true;
        }
        if (subj_result) {
            if (this.m_Condition != null && this.m_Condition.evaluate(accessReq, query, targetDocHandler, status, context)) {
                cond_result = true;
            }
            if (this.m_Subject != null && this.m_Condition != null) {
                if (cond_result && subj_result) {
                    acl_result = true;
                }
            } else if (this.m_Subject != null && this.m_Condition == null) {
                if (subj_result) {
                    acl_result = true;
                }
            } else if (this.m_Subject == null && this.m_Condition != null) {
                if (cond_result) {
                    acl_result = true;
                }
            } else {
                acl_result = true;
            }
        } else {
            acl_result = false;
        }
        if (acl_result) {
            if (searched_permission == null) {
                aclList.addElement(this);
            } else if (searched_permission.equals(this.getAction(accessReq.getAction().getName()).getPermission())) {
                aclList.addElement(this);
            }
        }
    }

    void indexing(Hashtable ht, Document target, Hierarchy rh, Hierarchy gh) {
        KeyTuple kt;
        int k;
        int j;
        int i;
        Policy policy = this.getRule().getXacl().getPolicy();
        String[] tmpObj = this.getRule().getXacl().getObjects();
        Subject[] tmpSub = this.getSubjects();
        Action[] tmpAction = this.getActions();
        for (i = 0; i < tmpObj.length; ++i) {
            for (j = 0; j < tmpSub.length; ++j) {
                for (k = 0; k < tmpAction.length; ++k) {
                    kt = new KeyTuple(tmpObj[i], tmpSub[j].getRoles()[0], tmpSub[j].getGroups()[0], tmpAction[k].getName());
                    this.addThisAcl(kt, ht);
                }
            }
        }
        for (i = 0; i < tmpObj.length; ++i) {
            for (j = 0; j < tmpSub.length; ++j) {
                for (k = 0; k < tmpAction.length; ++k) {
                    int z;
                    int y;
                    int x;
                    Element[] e;
                    Node n;
                    if (policy.getProperty().getPolicyDefinition(tmpAction[k].getName()) == null) continue;
                    String[] object = null;
                    String[] role = null;
                    String[] group = null;
                    String poh = policy.getProperty().getPolicyDefinition(tmpAction[k].getName()).getPropagationPolicyAlongOH("upward", tmpAction[k].getPermission());
                    String prh = policy.getProperty().getPolicyDefinition(tmpAction[k].getName()).getPropagationPolicyAlongGH("upward", tmpAction[k].getPermission());
                    String pgh = policy.getProperty().getPolicyDefinition(tmpAction[k].getName()).getPropagationPolicyAlongGH("upward", tmpAction[k].getPermission());
                    if (poh.equals("precedence")) {
                        n = null;
                        try {
                            n = XPathAPI.selectSingleNode((Node)target, (String)tmpObj[i]);
                        }
                        catch (TransformerException e2) {
                            throw new RuntimeException("Failed to create the hashtable for the hashtable-based evaluation.");
                        }
                        e = Util.getAncestorNodes((Element)n);
                        if (e != null) {
                            object = new String[e.length];
                            for (x = 0; x < e.length; ++x) {
                                object[x] = "//" + e[x].getLocalName();
                            }
                        }
                    }
                    if (object == null || object.length == 0) {
                        object = new String[]{tmpObj[i]};
                    }
                    if (prh.equals("precedence")) {
                        role = rh.getAncestors(tmpSub[j].getRoles()[0]);
                    }
                    if (role == null || role.length == 0) {
                        role = new String[]{tmpSub[j].getRoles()[0]};
                    }
                    if (pgh.equals("precedence")) {
                        group = gh.getAncestors(tmpSub[j].getGroups()[0]);
                    }
                    if (group == null || group.length == 0) {
                        group = new String[]{tmpSub[j].getGroups()[0]};
                    }
                    for (x = 0; x < object.length; ++x) {
                        for (y = 0; y < role.length; ++y) {
                            for (z = 0; z < group.length; ++z) {
                                kt = new KeyTuple(object[x], role[y], group[z], tmpAction[k].getName());
                                this.addThisAcl(kt, ht);
                            }
                        }
                    }
                    poh = policy.getProperty().getPolicyDefinition(tmpAction[k].getName()).getPropagationPolicyAlongOH("downward", tmpAction[k].getPermission());
                    prh = policy.getProperty().getPolicyDefinition(tmpAction[k].getName()).getPropagationPolicyAlongGH("downward", tmpAction[k].getPermission());
                    pgh = policy.getProperty().getPolicyDefinition(tmpAction[k].getName()).getPropagationPolicyAlongGH("downward", tmpAction[k].getPermission());
                    if (poh.equals("precedence")) {
                        n = null;
                        try {
                            n = XPathAPI.selectSingleNode((Node)target, (String)tmpObj[i]);
                        }
                        catch (TransformerException e3) {
                            throw new RuntimeException("Failed to create the hashtable for the hashtable-based evaluation.");
                        }
                        e = Util.getDescendantNodes((Element)n);
                        if (e != null) {
                            object = new String[e.length];
                            for (x = 0; x < e.length; ++x) {
                                object[x] = "//" + e[x].getLocalName();
                            }
                        }
                    }
                    if (object == null || object.length == 0) {
                        object = new String[]{tmpObj[i]};
                    }
                    if (prh.equals("precedence")) {
                        role = rh.getDescendants(tmpSub[j].getRoles()[0]);
                    }
                    if (role == null || role.length == 0) {
                        role = new String[]{tmpSub[j].getRoles()[0]};
                    }
                    if (pgh.equals("precedence")) {
                        group = gh.getDescendants(tmpSub[j].getGroups()[0]);
                    }
                    if (group == null || group.length == 0) {
                        group = new String[]{tmpSub[j].getGroups()[0]};
                    }
                    for (x = 0; x < object.length; ++x) {
                        for (y = 0; y < role.length; ++y) {
                            for (z = 0; z < group.length; ++z) {
                                kt = new KeyTuple(object[x], role[y], group[z], tmpAction[k].getName());
                                this.addThisAcl(kt, ht);
                            }
                        }
                    }
                }
            }
        }
    }

    private void addThisAcl(KeyTuple kt, Hashtable ht) {
        Vector<Acl> vec = (Vector<Acl>)ht.get(kt);
        if (vec == null) {
            vec = new Vector<Acl>();
            vec.addElement(this);
            ht.put(kt, vec);
        } else if (!vec.contains(this)) {
            vec.addElement(this);
        }
    }

    static Comparator getPrecedenceComparator() {
        return new PrecedenceComparator();
    }

    static Comparator getPermissionComparator(Action action) {
        return new PermissionComparator(action);
    }

    private static class PermissionComparator
    implements Comparator {
        Action action;

        PermissionComparator(Action action) {
            this.action = action;
        }

        public int compare(Object o1, Object o2) {
            Acl a1 = (Acl)o1;
            Acl a2 = (Acl)o2;
            return -1;
        }
    }

    private static class PrecedenceComparator
    implements Comparator {
        private PrecedenceComparator() {
        }

        public int compare(Object o1, Object o2) {
            Acl a1 = (Acl)o1;
            Acl a2 = (Acl)o2;
            return a2.getPrecedenceValue() - a1.getPrecedenceValue();
        }
    }
}

