/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.xacl;

import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.Action;
import com.ibm.xml.policy.xacl.DOMHandler;
import com.ibm.xml.policy.xacl.Subject;
import com.ibm.xml.policy.xacl.XaclException;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AccessRequest {
    private final Element m_ThisElement;
    private final Element m_ObjectElement;
    private final String m_Type;
    private final String m_Object;
    private final Subject m_Subject;
    private final Action m_Action;
    private Node m_TargetNode;

    AccessRequest(Element elem) throws XaclException {
        this.m_ThisElement = elem;
        this.m_Type = elem.getAttribute("type");
        Vector vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "object");
        if (vec.size() > 0) {
            this.m_ObjectElement = (Element)vec.elementAt(0);
            this.m_Object = this.m_ObjectElement.getAttribute("href");
        } else {
            this.m_ObjectElement = null;
            this.m_Object = null;
        }
        vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "subject");
        this.m_Subject = vec.size() > 0 ? new Subject((Element)vec.elementAt(0), null) : null;
        vec = Util.getChildElementsByTagNameNS(elem, "http://www.trl.ibm.com/projects/xml/xacl", "action");
        this.m_Action = vec.size() > 0 ? new Action((Element)vec.elementAt(0), null) : null;
    }

    void setTargetDocumentHandler(DOMHandler targetDocHandler) throws XaclException {
        NodeList nl = null;
        try {
            nl = XPathAPI.selectNodeList((Node)targetDocHandler.getDocument().getDocumentElement(), (String)this.m_Object, (Node)this.m_ObjectElement);
        }
        catch (Exception e) {
            throw new XaclException(201, "while importing the access request (" + this.m_Object + ")");
        }
        if (nl == null) {
            throw new XaclException(204, "(" + this.m_Object + ")");
        }
        if (nl.getLength() == 0) {
            throw new XaclException(204, "(" + this.m_Object + ")");
        }
        if (nl.getLength() != 1) {
            throw new XaclException(205, "(" + this.m_Object + ")");
        }
        this.m_TargetNode = nl.item(0);
        if (this.m_TargetNode.getNodeType() != 1 && this.m_TargetNode.getNodeType() != 2) {
            throw new XaclException(207, "(" + this.m_Object + ")");
        }
        if (this.m_TargetNode.getNodeType() == 2 && (((Attr)this.m_TargetNode).getName().equals("xmlns") || ((Attr)this.m_TargetNode).getName().startsWith("xmlns:"))) {
            throw new XaclException(208, "(" + this.m_Object + ")");
        }
    }

    public String getType() {
        return this.m_Type;
    }

    public String getObject() {
        return this.m_Object;
    }

    public String getTargetNodeXPath() {
        return this.m_Object;
    }

    public Subject getSubject() {
        return this.m_Subject;
    }

    public Node getTargetNode() {
        return this.m_TargetNode;
    }

    public Action getAction() {
        return this.m_Action;
    }

    public Element getElement() {
        return this.m_ThisElement;
    }

    Element createElement(Document doc) {
        Attr attr;
        Element objElem = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "object");
        objElem.setAttribute("href", this.m_Object);
        NamedNodeMap map = this.m_ObjectElement.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            attr = (Attr)map.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            objElem.setAttribute(attr.getName(), attr.getNodeValue());
        }
        Element accessReqElem = doc.createElementNS("http://www.trl.ibm.com/projects/xml/xacl", "access_req");
        accessReqElem.setAttribute("type", this.m_Type);
        accessReqElem.appendChild(objElem);
        if (this.m_Subject != null) {
            accessReqElem.appendChild(this.m_Subject.createElement(doc));
        }
        if (this.m_Action != null) {
            accessReqElem.appendChild(this.m_Action.createElement(doc));
        }
        map = this.m_ThisElement.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            attr = (Attr)map.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            accessReqElem.setAttribute(attr.getName(), attr.getNodeValue());
        }
        return accessReqElem;
    }
}

