/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.util;

import com.ibm.xml.policy.util.MIME2Java;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Util {
    public static String makeList(String[] var) {
        if (var == null) {
            return "";
        }
        if (var.length == 0) {
            return "";
        }
        String str = "";
        for (int i = 0; i < var.length; ++i) {
            str = str + var[i];
            if (i == var.length - 1) continue;
            str = str + ", ";
        }
        return str;
    }

    public static String removePrefix(String qname) {
        int index = qname.indexOf(":");
        if (index == -1) {
            return qname;
        }
        return qname.substring(index + 1, qname.length());
    }

    public static String makeXPath(Node node) {
        String str = "";
        switch (node.getNodeType()) {
            case 1: {
                Element elem = (Element)node;
                String tag = Util.removePrefix(elem.getTagName());
                String nsURI = elem.getNamespaceURI();
                Node parentNode = elem.getParentNode();
                if (parentNode.getNodeType() == 9) {
                    str = nsURI == null || nsURI.equals("") ? "/" + tag : "/*[local-name()=\"" + tag + "\"][namespace-uri()=\"" + nsURI + "\"]";
                    return str;
                }
                Element parent = (Element)parentNode;
                NodeList nodeList = nsURI == null || nsURI.equals("") ? parent.getElementsByTagName(tag) : parent.getElementsByTagNameNS(nsURI, tag);
                int size = nodeList.getLength();
                int index = 1;
                for (int i = 0; i < size && nodeList.item(i) != elem; ++i) {
                    ++index;
                }
                str = nsURI == null || nsURI.equals("") ? Util.makeXPath(parent) + "/" + tag : Util.makeXPath(parent) + "/*[local-name()=\"" + tag + "\"][namespace-uri()=\"" + nsURI + "\"]";
                if (size > 1) {
                    str = str + "[" + index + "]";
                }
                return str;
            }
            case 2: {
                Attr attr = (Attr)node;
                Element elem = attr.getOwnerElement();
                str = !attr.getName().startsWith("xmlns:") && !attr.getName().equals("xmlns") ? Util.makeXPath(elem) + "/@" + attr.getName() : Util.makeXPath(elem) + "/namespace::" + attr.getName();
                return str;
            }
        }
        System.out.println("Warning: You tried to make XPath for a node which is neither an element nor an attribute.");
        return null;
    }

    public static String replace(String target, char from, String to) {
        String result = "";
        int i = target.indexOf(from);
        if (i < 0) {
            return target;
        }
        for (i = 0; i < target.length(); ++i) {
            char c = target.charAt(i);
            result = c == from ? result + to : result + c;
        }
        return result;
    }

    public static String getTextNodeValue(Element elem) {
        NodeList nodeList = elem.getChildNodes();
        String str = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            str = str + nodeList.item(i).getNodeValue();
        }
        str = Util.replace(str, '\n', "");
        str = str.trim();
        return str;
    }

    public static String getText(Node[] node) {
        String str = "";
        for (int i = 0; i < node.length; ++i) {
            str = str + node[i].getNodeValue();
        }
        str = Util.replace(str, '\n', "");
        str = str.trim();
        return str;
    }

    public static byte[] Element2ByteArray(Element elem, String publicId, String systemId, String charEncoding, boolean xmldec, boolean datatype, boolean preserveSpace) throws IOException {
        if (charEncoding == null || charEncoding.equals("")) {
            charEncoding = "UTF-8";
        }
        String javaCharEncoding = MIME2Java.convert(charEncoding);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, javaCharEncoding);
        OutputFormat format = new OutputFormat();
        format.setDoctype(publicId, systemId);
        format.setEncoding(charEncoding);
        format.setOmitXMLDeclaration(!xmldec);
        format.setOmitDocumentType(!datatype);
        format.setPreserveSpace(preserveSpace);
        XMLSerializer xs = new XMLSerializer((Writer)ow, format);
        xs.serialize(elem);
        ow.flush();
        os.flush();
        ow.close();
        os.close();
        return os.toByteArray();
    }

    public static byte[] Document2ByteArray(Document doc, String publicId, String systemId, String charEncoding, boolean xmldec, boolean datatype, boolean preserveSpace) throws IOException {
        if (charEncoding == null || charEncoding.equals("")) {
            charEncoding = "UTF-8";
        }
        String javaCharEncoding = MIME2Java.convert(charEncoding);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)os, javaCharEncoding);
        OutputFormat format = new OutputFormat();
        format.setDoctype(publicId, systemId);
        format.setEncoding(charEncoding);
        format.setOmitXMLDeclaration(!xmldec);
        format.setOmitDocumentType(!datatype);
        format.setPreserveSpace(preserveSpace);
        XMLSerializer xs = new XMLSerializer((Writer)ow, format);
        xs.serialize(doc);
        ow.flush();
        os.flush();
        ow.close();
        os.close();
        return os.toByteArray();
    }

    public static String Element2String(Element elem, String publicId, String systemId, String charEncoding, boolean xmldec, boolean datatype, boolean preserveSpace) throws IOException {
        byte[] b = Util.Element2ByteArray(elem, publicId, systemId, charEncoding, xmldec, datatype, preserveSpace);
        if (charEncoding == null || charEncoding.equals("")) {
            charEncoding = "UTF-8";
        }
        String javaCharEncoding = MIME2Java.convert(charEncoding);
        return new String(b, javaCharEncoding);
    }

    public static Vector getChildElementsByTagNameNS(Element elem, String uri, String name) {
        NodeList nl = elem.getElementsByTagNameNS(uri, name);
        int size = nl.getLength();
        Vector<Node> vec = new Vector<Node>(size);
        for (int i = 0; i < size; ++i) {
            if (nl.item(i).getParentNode() != elem) continue;
            vec.addElement(nl.item(i));
        }
        return vec;
    }

    public static Vector getChildElementsByTagName(Element elem, String name) {
        NodeList nl = elem.getElementsByTagName(name);
        int size = nl.getLength();
        Vector<Node> vec = new Vector<Node>(size);
        for (int i = 0; i < size; ++i) {
            if (nl.item(i).getParentNode() != elem) continue;
            vec.addElement(nl.item(i));
        }
        return vec;
    }

    public static Attr removeAttributeNode(Element owner, Attr attr) {
        int size1 = owner.getAttributes().getLength();
        Attr attr2 = owner.removeAttributeNode(attr);
        int size2 = owner.getAttributes().getLength();
        if (size1 - size2 != 1) {
            return null;
        }
        return attr2;
    }

    public static Element[] getAncestorNodes(Node node) {
        if (node == null) {
            return null;
        }
        Node parent = node;
        Vector<Node> vec = new Vector<Node>();
        vec.addElement(node);
        while ((parent = parent.getParentNode()).getNodeType() != 9) {
            vec.addElement(parent);
        }
        Element[] elem = new Element[vec.size()];
        System.arraycopy(vec.toArray(), 0, elem, 0, elem.length);
        return elem;
    }

    public static Element[] getDescendantNodes(Element node) {
        if (node == null) {
            return null;
        }
        NodeList nl = node.getChildNodes();
        Vector<Element> vec = new Vector<Element>();
        vec.addElement(node);
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            Element[] n = Util.getDescendantNodes((Element)nl.item(i));
            for (int j = 0; j < n.length; ++j) {
                vec.addElement(n[j]);
            }
        }
        Element[] elem = new Element[vec.size()];
        System.arraycopy(vec.toArray(), 0, elem, 0, elem.length);
        return elem;
    }
}

