/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.util;

import com.ibm.xml.policy.util.ErrorHandlerImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMSource {
    private final ErrorHandler eh;
    private Document document = null;
    private String encoding = null;
    String publicIdStr = null;
    String systemIdStr = null;

    private DocumentBuilder newDocumentBuilder(boolean validation) {
        DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
        fac.setNamespaceAware(true);
        fac.setValidating(validation);
        if (validation) {
            fac.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
        } else {
            fac.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.FALSE);
        }
        try {
            DocumentBuilder builder = fac.newDocumentBuilder();
            builder.setErrorHandler(this.eh);
            builder.setEntityResolver(new MyEntityResolver(this));
            return builder;
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
    }

    public DOMSource(ErrorHandler eh) {
        this.eh = eh;
    }

    public Document parse(String xmlDoc, boolean validityCheck) throws FileNotFoundException, SAXException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlDoc.getBytes());
        return this.parse(inputStream, validityCheck);
    }

    public Document parse(File file, boolean validityCheck) throws FileNotFoundException, SAXException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        return this.parse(inputStream, validityCheck);
    }

    public Document parse(InputStream inputStream, boolean validityCheck) throws SAXException, IOException {
        DocumentBuilder builder = this.newDocumentBuilder(validityCheck);
        InputSource is = new InputSource(inputStream);
        this.document = builder.parse(is);
        return this.document;
    }

    public Document parseByFileName(String fileName, boolean validityCheck) throws SAXException, IOException {
        DocumentBuilder builder = this.newDocumentBuilder(validityCheck);
        this.document = builder.parse(fileName);
        return this.document;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getSystemId() {
        return this.systemIdStr;
    }

    public String getPublicId() {
        return this.publicIdStr;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static void main(String[] argv) throws Exception {
        String xmlDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE personnel_info SYSTEM \"ex1_target.dtd\"><personnel_info><name>Johnson</name><salary currency=\"USD\">200,000</salary></personnel_info>";
        DOMSource src = new DOMSource(new ErrorHandlerImpl());
        src.parse(xmlDoc, true);
        Document doc = src.getDocument();
        String sys = src.getSystemId();
        String pub = src.getPublicId();
        String enc = src.getEncoding();
    }

    class MyEntityResolver
    implements EntityResolver {
        DOMSource source;

        public MyEntityResolver(DOMSource source) {
            this.source = source;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            this.source.publicIdStr = publicId;
            this.source.systemIdStr = systemId;
            return null;
        }
    }
}

