/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.Console;
import com.ibm.xml.policy.tool.DOMTree;
import com.ibm.xml.policy.tool.DecisionTreeNode;
import com.ibm.xml.policy.tool.DocumentViewer;
import com.ibm.xml.policy.tool.JXMLTextPane;
import com.ibm.xml.policy.tool.MenuController;
import com.ibm.xml.policy.tool.ParameterViewer;
import com.ibm.xml.policy.tool.Strings;
import com.ibm.xml.policy.tool.TargetDocTreeCellRenderer;
import com.ibm.xml.policy.tool.ThreadedXACLProcessor;
import com.ibm.xml.policy.tool.WindowListener;
import com.ibm.xml.policy.util.DOMSource;
import com.ibm.xml.policy.util.Util;
import com.ibm.xml.policy.xacl.DecisionList;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class VisualTool
extends JApplet
implements ErrorHandler,
ActionListener {
    private static JFrame frame;
    public PrintStream systemOut = System.out;
    public PrintStream systemErr = System.err;
    private Hashtable AR_NSPREFIX_TABLE;
    private Hashtable OBJ_NSPREFIX_TABLE;
    private ThreadedXACLProcessor xaclProcessor = null;
    public MenuController menuController = null;
    private File accessReqFile = null;
    private File targetDocumentFile = null;
    private File policyFile = null;
    private File statusFile = null;
    public Document access_req;
    public DecisionList dl;
    public Document decision_list;
    public Document view;
    public Document target_document;
    public Document policy;
    public Document status;
    private JPanel AppletContentPanel = null;
    private JPanel AccessReqComposerPanel = null;
    private JScrollPane AccessReqPane = null;
    private JScrollPane TargetDocumentPane = null;
    private JScrollPane PolicyPane = null;
    private JScrollPane StatusPane = null;
    private JScrollPane ViewPane = null;
    private JScrollPane DecisionListPane = null;
    private JScrollPane ConsolePane = null;
    private DOMTree TargetDocumentTree = null;
    private DOMSource TargetDocumentSource = null;
    private JXMLTextPane TargetDocumentTP = null;
    private DOMTree PolicyTree = null;
    private DOMSource PolicySource = null;
    private JXMLTextPane PolicyTP = null;
    private DOMTree StatusTree = null;
    private DOMSource StatusSource = null;
    private JXMLTextPane StatusTP = null;
    private DOMTree AccessReqTree = null;
    private DOMSource AccessReqSource = null;
    private JXMLTextPane AccessReqTP = null;
    private DOMTree DecisionListTree = null;
    private JXMLTextPane DecisionListTP = null;
    private DOMTree ViewTree = null;
    private JXMLTextPane ViewTP = null;
    private JDialog queryDialog = null;
    private JOptionPane queryOptionPane = null;
    private JDialog openDialog = null;
    private JOptionPane openOptionPane = null;
    private Console console = null;
    private DocumentViewer documentViewer = null;
    private ParameterViewer parameterViewer = null;
    private JFrame policyViewer = null;
    private JFrame statusViewer = null;
    private JFrame accessReqViewer = null;
    private JFrame decisionListViewer = null;
    public ButtonGroup groupAction;
    public ButtonGroup groupRequestType;
    public ButtonGroup groupDefault;
    public ButtonGroup groupObjectVarConst;
    public ButtonGroup groupSubjectVarConst;
    public ButtonGroup groupActionVarConst;
    public ButtonGroup groupSignVarConst;
    public ButtonGroup groupSignPosNeg;
    public ButtonGroup groupEnforcementVarConst;
    public JTextField tfHref;
    public JTextField tfUID;
    public JTextField tfRole;
    public JTextField tfGroup;
    public JTextField tfParameter;
    private boolean FILE_LOADED = false;
    private static boolean VARIABLE;
    private static boolean validation;

    public void actionPerformed(ActionEvent e) {
        String com = e.getActionCommand();
        if (e.getSource() instanceof JButton) {
            if (com.equals(Strings.START_BUTTON)) {
                if (!this.FILE_LOADED) {
                    this.unassigned(null, Strings.DIALOG_NO_FILE_OPENED);
                    return;
                }
                if (this.policy == null) {
                    this.error("No associated policy");
                    return;
                }
                if (this.status == null) {
                    this.error("No associated status");
                    return;
                }
                try {
                    this.queryStart();
                }
                catch (Exception ex) {
                    this.error(ex.toString());
                    return;
                }
            } else if (com.equals(Strings.SET_BUTTON)) {
                this.getTargetDocumentTree().makeXPath();
            } else if (com.equals(Strings.CHECK_BUTTON)) {
                this.getTargetDocumentTree().checkXPath(this.tfHref.getText());
            } else if (com.equals(Strings.SET_GROUP)) {
                String uid = this.tfUID.getText();
                if (uid.equals("")) {
                    this.warning("Input a uid name !");
                    return;
                }
                this.tfGroup.setText(this.getGroupList(uid));
                return;
            }
        }
    }

    public void clearAccessRequestComposer() {
        this.access_req = null;
        this.tfHref.setText(null);
        this.tfUID.setText(null);
        this.tfRole.setText(null);
        this.tfGroup.setText(null);
        Enumeration<AbstractButton> actionButtons = this.groupAction.getElements();
        while (actionButtons.hasMoreElements()) {
            JRadioButton button = (JRadioButton)actionButtons.nextElement();
            if (button.getActionCommand().equals("read")) {
                button.setSelected(true);
                continue;
            }
            button.setSelected(false);
        }
        this.tfParameter.setText(null);
    }

    public void exit() {
        if (this.getMenuController().close()) {
            frame.dispose();
            System.exit(0);
        }
    }

    public void closeAllDocuments() {
        this.access_req = null;
        this.target_document = null;
        this.policy = null;
        this.status = null;
        this.view = null;
        this.decision_list = null;
        this.targetDocumentFile = null;
        this.accessReqFile = null;
        this.policyFile = null;
        this.statusFile = null;
        this.getAccessReqTP().clear();
        this.getTargetDocumentTree().documentReady(null);
        this.getTargetDocumentTP().clear();
        this.getPolicyTP().clear();
        this.getStatusTP().clear();
        this.getDecisionListTP().clear();
        this.getViewTP().clear();
        this.getMenuController().switchOff(this.getMenuController().closeDocItem);
        this.clearAccessRequestComposer();
        this.getConsole().clear();
        this.setTitle(Strings.PROG_NAME);
        this.getDocumentViewer().setVisible(false);
        this.getPolicyViewer().setVisible(false);
        this.getStatusViewer().setVisible(false);
        this.getAccessReqViewer().setVisible(false);
        this.getDecisionListViewer().setVisible(false);
    }

    private void constructAccessRequest() {
        String key;
        String accessReqStr = "<access_req ";
        Enumeration e = this.AR_NSPREFIX_TABLE.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            accessReqStr = accessReqStr + key + "=\"" + this.AR_NSPREFIX_TABLE.get(key) + "\" ";
        }
        String type = this.groupRequestType.getSelection().getActionCommand();
        accessReqStr = accessReqStr + " type=\"" + type + "\">";
        accessReqStr = accessReqStr + "<object ";
        Enumeration e2 = this.OBJ_NSPREFIX_TABLE.keys();
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            accessReqStr = accessReqStr + key + "=\"" + this.OBJ_NSPREFIX_TABLE.get(key) + "\" ";
        }
        accessReqStr = accessReqStr + "href='" + this.tfHref.getText() + "'/>";
        if (!(this.tfUID.getText().equals("") && this.tfRole.getText().equals("") && this.tfGroup.getText().equals(""))) {
            StringTokenizer st;
            accessReqStr = accessReqStr + "<subject>";
            String value = this.tfUID.getText();
            if (value != null && !value.equals("")) {
                accessReqStr = accessReqStr + "<uid>" + value + "</uid>";
            }
            if ((value = this.tfRole.getText()) != null && !value.equals("")) {
                st = new StringTokenizer(value, Strings.ROLES_DELIMITER, false);
                while (st.hasMoreTokens()) {
                    accessReqStr = accessReqStr + "<role>" + st.nextToken().trim() + "</role>";
                }
            }
            if ((value = this.tfGroup.getText()) != null && !value.equals("")) {
                st = new StringTokenizer(value, Strings.ROLES_DELIMITER, false);
                while (st.hasMoreTokens()) {
                    accessReqStr = accessReqStr + "<group>" + st.nextToken().trim() + "</group>";
                }
            }
            accessReqStr = accessReqStr + "</subject>";
        }
        String value = this.groupAction.getSelection().getActionCommand();
        accessReqStr = accessReqStr + "<action name=\"" + value + "\">";
        if (this.tfParameter.getText() != null && !this.tfParameter.getText().equals("")) {
            String param = this.tfParameter.getText();
            accessReqStr = accessReqStr + param;
        }
        accessReqStr = accessReqStr + "</action>";
        accessReqStr = accessReqStr + "</access_req>";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.access_req = builder.parse(new InputSource(new StringReader(accessReqStr)));
        }
        catch (Exception e3) {
            this.error("Failed to parse the dynamically generated access request.");
            this.getConsole().println(accessReqStr);
            this.getConsole().println(e3.toString());
            this.access_req = null;
        }
    }

    private void documentUpdate(boolean execute, String action) throws IOException {
        if (execute) {
            try {
                this.saveStatusDoc();
            }
            catch (IOException ex) {
                this.error(ex.toString());
                return;
            }
        }
        if (execute && !action.equals("read")) {
            try {
                this.saveTargetDoc();
            }
            catch (IOException ex) {
                this.error(ex.toString());
                return;
            }
        }
        this.getTargetDocumentTree().documentReady(this.target_document);
        this.getTargetDocumentTP().writeDOM(this.target_document, this.getTargetDocumentSource().getPublicId(), this.getTargetDocumentSource().getSystemId(), this.getTargetDocumentSource().getEncoding(), false);
        this.getViewTP().writeDOM(this.view, this.getTargetDocumentSource().getPublicId(), this.getTargetDocumentSource().getSystemId(), this.getTargetDocumentSource().getEncoding(), false);
        if (execute && this.getStatusViewer().isVisible()) {
            this.getStatusTP().writeDOM(this.status, this.getStatusSource().getPublicId(), this.getStatusSource().getSystemId(), this.getStatusSource().getEncoding(), false);
        }
        if (this.getAccessReqViewer().isVisible()) {
            this.getAccessReqTP().writeDOM(this.access_req, this.getAccessReqSource().getPublicId(), this.getAccessReqSource().getSystemId(), this.getAccessReqSource().getEncoding(), false);
        }
        if (this.getDecisionListViewer().isVisible()) {
            this.getDecisionListTP().writeDOM(this.decision_list, null, null, null, false);
        }
        this.getTargetDocumentTree().showDecisions(this.decision_list);
        if (execute && action.equals("read")) {
            FileOutputStream fos = new FileOutputStream("view.xml");
            fos.write(Util.Document2ByteArray(this.view, null, null, "UTF-8", true, true, true));
            fos.flush();
            fos.close();
            this.getDocumentViewer().setVisible(true);
        } else {
            this.getDocumentViewer().clearDOM();
            this.getDocumentViewer().setVisible(false);
        }
    }

    public void error(String text) {
        JOptionPane.showMessageDialog(this.getJAppletContentPanel(), text, Strings.ERROR, 0);
    }

    public Console getConsole() {
        if (this.console == null) {
            try {
                this.console = new Console(this.systemOut, this.systemErr);
                this.console.setName("Console");
            }
            catch (Throwable Exc) {
                return null;
            }
        }
        return this.console;
    }

    public JXMLTextPane getAccessReqTP() {
        if (this.AccessReqTP == null) {
            this.AccessReqTP = new JXMLTextPane();
            Font f = frame.getFont();
            this.AccessReqTP.setFont(new Font(f.getName(), 0, f.getSize() + 2));
        }
        return this.AccessReqTP;
    }

    public JXMLTextPane getTargetDocumentTP() {
        if (this.TargetDocumentTP == null) {
            this.TargetDocumentTP = new JXMLTextPane();
            Font f = frame.getFont();
            this.TargetDocumentTP.setFont(new Font(f.getName(), 0, f.getSize() + 2));
        }
        return this.TargetDocumentTP;
    }

    public JXMLTextPane getPolicyTP() {
        if (this.PolicyTP == null) {
            this.PolicyTP = new JXMLTextPane();
            Font f = frame.getFont();
            this.PolicyTP.setFont(new Font(f.getName(), 0, f.getSize() + 2));
        }
        return this.PolicyTP;
    }

    public JXMLTextPane getStatusTP() {
        if (this.StatusTP == null) {
            this.StatusTP = new JXMLTextPane();
            Font f = frame.getFont();
            this.StatusTP.setFont(new Font(f.getName(), 0, f.getSize() + 2));
        }
        return this.StatusTP;
    }

    public JXMLTextPane getDecisionListTP() {
        if (this.DecisionListTP == null) {
            this.DecisionListTP = new JXMLTextPane();
            Font f = frame.getFont();
            this.DecisionListTP.setFont(new Font(f.getName(), 0, f.getSize() + 2));
        }
        return this.DecisionListTP;
    }

    public JXMLTextPane getViewTP() {
        if (this.ViewTP == null) {
            this.ViewTP = new JXMLTextPane();
            Font f = frame.getFont();
            this.ViewTP.setFont(new Font(f.getName(), 0, f.getSize() + 2));
        }
        return this.ViewTP;
    }

    public DOMSource getAccessReqSource() {
        if (this.AccessReqSource == null) {
            try {
                this.AccessReqSource = new DOMSource(this);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.AccessReqSource;
    }

    public DOMSource getTargetDocumentSource() {
        if (this.TargetDocumentSource == null) {
            try {
                this.TargetDocumentSource = new DOMSource(this);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.TargetDocumentSource;
    }

    public DOMSource getPolicySource() {
        if (this.PolicySource == null) {
            try {
                this.PolicySource = new DOMSource(this);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.PolicySource;
    }

    public DOMSource getStatusSource() {
        if (this.StatusSource == null) {
            try {
                this.StatusSource = new DOMSource(this);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.StatusSource;
    }

    public DOMTree getAccessReqTree() {
        if (this.AccessReqTree == null) {
            try {
                this.AccessReqTree = new DOMTree(this, true, new DefaultTreeCellRenderer());
                this.AccessReqTree.setName("AccessRequest");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.AccessReqTree;
    }

    public DOMTree getTargetDocumentTree() {
        if (this.TargetDocumentTree == null) {
            try {
                this.TargetDocumentTree = new DOMTree(this, true, new TargetDocTreeCellRenderer());
                this.TargetDocumentTree.setName("TargetDocument");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.TargetDocumentTree;
    }

    public DOMTree getPolicyTree() {
        if (this.PolicyTree == null) {
            try {
                this.PolicyTree = new DOMTree(this, true, new DefaultTreeCellRenderer());
                this.PolicyTree.setName("Policy");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.PolicyTree;
    }

    public DOMTree getStatusTree() {
        if (this.StatusTree == null) {
            try {
                this.StatusTree = new DOMTree(this, true, new DefaultTreeCellRenderer());
                this.StatusTree.setName("Status");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.StatusTree;
    }

    public DOMTree getViewTree() {
        if (this.ViewTree == null) {
            try {
                this.ViewTree = new DOMTree(this, true, new DefaultTreeCellRenderer());
                this.ViewTree.setName("View");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.ViewTree;
    }

    public DOMTree getDecisionListTree() {
        if (this.DecisionListTree == null) {
            try {
                this.DecisionListTree = new DOMTree(this, true, new DefaultTreeCellRenderer());
                this.DecisionListTree.setName("DecisionList");
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.DecisionListTree;
    }

    public JScrollPane getAccessReqPane() {
        if (this.AccessReqPane == null) {
            try {
                this.AccessReqPane = new JScrollPane();
                this.AccessReqPane.setName("AccessReqPane");
                this.AccessReqPane.setViewportView(this.getAccessReqTP());
                this.AccessReqPane.setBorder(BorderFactory.createTitledBorder("AccessRequest"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.AccessReqPane;
    }

    public JScrollPane getTargetDocumentPane() {
        if (this.TargetDocumentPane == null) {
            try {
                this.TargetDocumentPane = new JScrollPane();
                this.TargetDocumentPane.setName("TargetDocumentPane");
                this.TargetDocumentPane.setViewportView(this.getTargetDocumentTree());
                this.TargetDocumentPane.setBorder(BorderFactory.createTitledBorder("Target XML Document"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.TargetDocumentPane;
    }

    public JScrollPane getPolicyPane() {
        if (this.PolicyPane == null) {
            try {
                this.PolicyPane = new JScrollPane();
                this.PolicyPane.setName("PolicyPane");
                this.PolicyPane.setViewportView(this.getPolicyTP());
                this.PolicyPane.setBorder(BorderFactory.createTitledBorder("Policy"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.PolicyPane;
    }

    public JScrollPane getStatusPane() {
        if (this.StatusPane == null) {
            try {
                this.StatusPane = new JScrollPane();
                this.StatusPane.setName("StatusPane");
                this.StatusPane.setViewportView(this.getStatusTP());
                this.StatusPane.setBorder(BorderFactory.createTitledBorder("Status"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.StatusPane;
    }

    public JScrollPane getViewPane() {
        if (this.ViewPane == null) {
            try {
                this.ViewPane = new JScrollPane();
                this.ViewPane.setName("ViewPane");
                this.ViewPane.setViewportView(this.getViewTree());
                this.ViewPane.setBorder(BorderFactory.createTitledBorder("View"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.ViewPane;
    }

    public JScrollPane getDecisionListPane() {
        if (this.DecisionListPane == null) {
            try {
                this.DecisionListPane = new JScrollPane();
                this.DecisionListPane.setName("DecisionListPane");
                this.DecisionListPane.setViewportView(this.getDecisionListTP());
                this.DecisionListPane.setBorder(BorderFactory.createTitledBorder("DecisionList"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.DecisionListPane;
    }

    private JScrollPane getConsolePane() {
        if (this.ConsolePane == null) {
            try {
                this.ConsolePane = new JScrollPane();
                this.ConsolePane.setName("ConsolePanel");
                this.ConsolePane.setViewportView(this.getConsole());
                this.ConsolePane.setBorder(BorderFactory.createTitledBorder("Console"));
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.ConsolePane;
    }

    public MenuController getMenuController() {
        if (this.menuController == null) {
            this.menuController = new MenuController(this);
        }
        return this.menuController;
    }

    private JPanel getObjectPanel() {
        try {
            JPanel p = new JPanel();
            p.setName("object");
            p.setBorder(BorderFactory.createTitledBorder(Strings.OBJECT_PANEL));
            p.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            if (VARIABLE) {
                this.groupObjectVarConst = new ButtonGroup();
                JRadioButton rb = new JRadioButton(Strings.VARIABLE);
                this.groupObjectVarConst.add(rb);
                c.gridwidth = 2;
                p.add((Component)rb, c);
                rb = new JRadioButton(Strings.CONSTANT);
                rb.setSelected(true);
                this.groupObjectVarConst.add(rb);
                c.gridx = 2;
                p.add((Component)rb, c);
            }
            JLabel l = new JLabel(Strings.HREF);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            p.add((Component)l, c);
            this.tfHref = new JTextField();
            this.tfHref.addMouseListener(new MouseListener(){

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }

                public void mousePressed(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        VisualTool.this.getMenuController().xPathMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }

                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        VisualTool.this.getMenuController().xPathMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
            this.tfHref.setToolTipText(Strings.XP_TOOLTIP);
            c.gridx = 1;
            c.weightx = 1.0;
            c.gridwidth = 3;
            c.fill = 2;
            p.add((Component)this.tfHref, c);
            JButton b = new JButton(Strings.CHECK_BUTTON);
            b.setActionCommand(Strings.CHECK_BUTTON);
            b.addActionListener(this);
            c.weightx = 1.0;
            c.gridx = 2;
            ++c.gridy;
            c.gridwidth = 1;
            c.fill = 0;
            c.anchor = 13;
            p.add((Component)b, c);
            b = new JButton(Strings.SET_BUTTON);
            b.setActionCommand(Strings.SET_BUTTON);
            b.addActionListener(this);
            c.gridx = 3;
            p.add((Component)b, c);
            return p;
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
            return null;
        }
    }

    private JPanel getActionPanel() {
        try {
            JRadioButton rb;
            JPanel p = new JPanel();
            p.setName("action");
            GridBagLayout gridbag = new GridBagLayout();
            p.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 2, 0, 2);
            c.anchor = 17;
            p.setBorder(BorderFactory.createTitledBorder(Strings.ACTION_PANEL));
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            if (VARIABLE) {
                this.groupActionVarConst = new ButtonGroup();
                rb = new JRadioButton(Strings.VARIABLE);
                this.groupActionVarConst.add(rb);
                c.weightx = 1.0;
                p.add((Component)rb, c);
                rb = new JRadioButton(Strings.CONSTANT);
                rb.setSelected(true);
                this.groupActionVarConst.add(rb);
                c.gridx = 1;
                p.add((Component)rb, c);
            }
            this.groupAction = new ButtonGroup();
            rb = new JRadioButton("read");
            rb.setActionCommand("read");
            rb.setSelected(true);
            this.groupAction.add(rb);
            c.gridx = 0;
            ++c.gridy;
            p.add((Component)rb, c);
            rb = new JRadioButton("write");
            rb.setActionCommand("write");
            this.groupAction.add(rb);
            c.gridx = 1;
            p.add((Component)rb, c);
            rb = new JRadioButton("create");
            rb.setActionCommand("create");
            this.groupAction.add(rb);
            c.gridx = 2;
            p.add((Component)rb, c);
            rb = new JRadioButton("delete");
            rb.setActionCommand("delete");
            this.groupAction.add(rb);
            c.gridx = 3;
            p.add((Component)rb, c);
            Insets oldInsets = c.insets;
            Insets bigInsets = new Insets(8, 2, 0, 2);
            JLabel l = new JLabel("parameter");
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            p.add((Component)l, c);
            this.tfParameter = new JTextField();
            this.tfParameter.setToolTipText(Strings.PARAMETER_TIP);
            c.gridx = 1;
            c.weightx = 1.0;
            c.gridwidth = 3;
            c.fill = 2;
            p.add((Component)this.tfParameter, c);
            return p;
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
            return null;
        }
    }

    private JPanel getSubjectPanel() {
        try {
            JPanel p = new JPanel();
            p.setName("subject");
            GridBagLayout gridbag = new GridBagLayout();
            p.setBorder(BorderFactory.createTitledBorder(Strings.SUBJECT_PANEL));
            p.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            if (VARIABLE) {
                this.groupSubjectVarConst = new ButtonGroup();
                JRadioButton rb = new JRadioButton(Strings.VARIABLE);
                this.groupSubjectVarConst.add(rb);
                c.gridwidth = 2;
                c.fill = 0;
                p.add((Component)rb, c);
                rb = new JRadioButton(Strings.CONSTANT);
                rb.setSelected(true);
                this.groupSubjectVarConst.add(rb);
                c.gridx = 2;
                c.gridwidth = 1;
                p.add((Component)rb, c);
            }
            JLabel l = new JLabel("uid");
            c.gridx = 0;
            ++c.gridy;
            p.add((Component)l, c);
            this.tfUID = new JTextField();
            this.tfUID.setToolTipText(Strings.UID_TIP);
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)this.tfUID, c);
            l = new JLabel("role");
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            p.add((Component)l, c);
            this.tfRole = new JTextField();
            this.tfRole.setToolTipText(Strings.ROLES_TIP);
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)this.tfRole, c);
            l = new JLabel("group");
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            p.add((Component)l, c);
            this.tfGroup = new JTextField();
            this.tfGroup.setToolTipText(Strings.GROUPS_TIP);
            c.gridx = 1;
            c.gridwidth = 2;
            c.weightx = 1.0;
            c.fill = 2;
            p.add((Component)this.tfGroup, c);
            JButton b = new JButton(Strings.SET_GROUP);
            b.addActionListener(this);
            c.weightx = 1.0;
            c.gridx = 2;
            ++c.gridy;
            c.gridwidth = 1;
            c.fill = 0;
            c.anchor = 17;
            p.add((Component)b, c);
            return p;
        }
        catch (Throwable Exc) {
            this.handleException(Exc);
            return null;
        }
    }

    private JPanel getAccessReqComposerPanel() {
        if (this.AccessReqComposerPanel == null) {
            try {
                this.AccessReqComposerPanel = new JPanel();
                this.AccessReqComposerPanel.setName("AccessReqComposerPanel");
                this.AccessReqComposerPanel.setLayout(new GridBagLayout());
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.gridx = 0;
                c.gridy = 0;
                JLabel arLabel = new JLabel("Access Request");
                Font f = arLabel.getFont();
                arLabel.setFont(new Font(f.getName(), 1, f.getSize() + 1));
                this.AccessReqComposerPanel.add((Component)arLabel, c);
                JButton button = new JButton(Strings.START_BUTTON);
                button.setName("start");
                button.setActionCommand(Strings.START_BUTTON);
                button.addActionListener(this);
                ++c.gridy;
                c.gridwidth = 1;
                c.gridheight = 3;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.anchor = 10;
                c.insets = new Insets(10, 10, 5, 0);
                this.AccessReqComposerPanel.add((Component)button, c);
                this.groupRequestType = new ButtonGroup();
                JRadioButton rb = new JRadioButton("basic", true);
                rb.setName("basic");
                rb.setToolTipText(Strings.RT_TOOL_TIP);
                rb.setActionCommand("basic");
                this.groupRequestType.add(rb);
                ++c.gridx;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridwidth = 1;
                c.gridheight = 1;
                c.anchor = 11;
                c.insets = new Insets(5, 10, 0, 2);
                this.AccessReqComposerPanel.add((Component)rb, c);
                rb = new JRadioButton("query");
                rb.setName("query");
                rb.setToolTipText(Strings.RT_TOOL_TIP);
                rb.setActionCommand("query");
                this.groupRequestType.add(rb);
                c.insets = new Insets(5, 10, 0, 2);
                ++c.gridy;
                c.anchor = 11;
                this.AccessReqComposerPanel.add((Component)rb, c);
                rb = new JRadioButton("execute");
                rb.setName("execute");
                rb.setToolTipText(Strings.RT_TOOL_TIP);
                rb.setActionCommand("execute");
                this.groupRequestType.add(rb);
                c.insets = new Insets(5, 10, 0, 2);
                ++c.gridy;
                c.anchor = 11;
                this.AccessReqComposerPanel.add((Component)rb, c);
                c.gridwidth = 3;
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                ++c.gridy;
                this.AccessReqComposerPanel.add((Component)this.getObjectPanel(), c);
                ++c.gridy;
                this.AccessReqComposerPanel.add((Component)this.getSubjectPanel(), c);
                ++c.gridy;
                this.AccessReqComposerPanel.add((Component)this.getActionPanel(), c);
                ++c.gridy;
                c.weighty = 1.0;
                this.AccessReqComposerPanel.add((Component)this.getConsolePane(), c);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.AccessReqComposerPanel;
    }

    public JPanel getJAppletContentPanel() {
        if (this.AppletContentPanel == null) {
            try {
                this.AppletContentPanel = new JPanel();
                this.AppletContentPanel.setName("AppletContentPane");
                GridBagLayout gridbag = new GridBagLayout();
                this.AppletContentPanel.setLayout(gridbag);
                GridBagConstraints c = new GridBagConstraints();
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                c.weightx = 0.0;
                c.gridheight = 2;
                c.fill = 1;
                this.AppletContentPanel.add((Component)this.getAccessReqComposerPanel(), c);
                c.gridx = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                this.AppletContentPanel.add((Component)this.getTargetDocumentPane(), c);
                ToolTipManager ttm = ToolTipManager.sharedInstance();
                ttm.registerComponent(this.AppletContentPanel);
                ttm.setInitialDelay(Strings.APPLET_INITDELAY);
                ttm.setDismissDelay(Strings.APPLET_DISMISSDELAY);
            }
            catch (Throwable Exc) {
                this.handleException(Exc);
            }
        }
        return this.AppletContentPanel;
    }

    public void init() {
        frame.setSize(800, 700);
        this.setName("XACL Visual Tool");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowListener(this));
        this.setTitle(Strings.PROG_NAME);
        this.getMenuController();
        this.getConsole().clear();
        this.setContentPane(this.getJAppletContentPanel());
        frame.setVisible(true);
    }

    public void handleException(Throwable exception) {
        this.println(exception.getMessage());
    }

    public boolean loadAccessRequest(String fileName) {
        this.getTargetDocumentTree().removeDecisions();
        this.clearAccessRequestComposer();
        this.getAccessReqTP().clear();
        try {
            this.access_req = this.getAccessReqSource().parseByFileName(fileName, validation);
        }
        catch (FileNotFoundException e) {
            this.error(Strings.DIALOG_FILE_NOT_FOUND + "\n\n" + fileName);
            this.println("FileNotFoundException:" + e.getMessage());
            return false;
        }
        catch (SAXException e) {
            this.error(Strings.DIALOG_XML_PARSE_ERROR + "\n\n" + fileName);
            this.println("SAXException:" + e.getMessage());
            return false;
        }
        catch (IOException e) {
            this.error(Strings.DIALOG_FILE_NOT_FOUND + "\n\n" + fileName);
            this.println("IOException:" + e.getMessage());
            this.println("");
            return false;
        }
        if (!this.setQuery(this.access_req.getDocumentElement())) {
            return false;
        }
        this.getAccessReqTP().writeDOM(this.access_req, this.getAccessReqSource().getPublicId(), this.getAccessReqSource().getSystemId(), this.getAccessReqSource().getEncoding(), false);
        if (this.access_req == null) {
            return false;
        }
        this.accessReqFile = new File(fileName);
        this.loadAccessReqDone(this.access_req);
        return true;
    }

    boolean loadTargetDocument(String fileName) {
        NodeList nl;
        Element bind;
        int i;
        Element bind_table;
        this.getDocumentViewer().setVisible(false);
        this.getConsole().clear();
        this.getTargetDocumentTree().documentReady(null);
        this.getTargetDocumentTP().clear();
        this.getPolicyTP().clear();
        this.getStatusTP().clear();
        this.getDecisionListTP().clear();
        this.getViewTP().clear();
        try {
            this.target_document = this.getTargetDocumentSource().parseByFileName(fileName, validation);
            if (this.target_document == null) {
                return false;
            }
            this.targetDocumentFile = new File(fileName);
        }
        catch (SecurityException exc) {
            if (this.targetDocumentFile != null) {
                this.error(Strings.DIALOG_FILE_SECURITY_EXCEPTION + "\n\n" + this.targetDocumentFile.getAbsolutePath());
            }
            this.println("SecurityException:" + exc.getMessage());
            return false;
        }
        catch (FileNotFoundException exc) {
            if (this.targetDocumentFile != null) {
                this.error(Strings.DIALOG_FILE_NOT_FOUND + "\n\n" + this.targetDocumentFile.getAbsolutePath());
            }
            this.println("FileNotFoundException:" + exc.getMessage());
            return false;
        }
        catch (SAXException exc) {
            if (this.targetDocumentFile != null) {
                this.println("SAXException during document parse: " + this.targetDocumentFile.getAbsolutePath());
            }
            this.println("SAXException: " + exc.getMessage());
            return false;
        }
        catch (IOException exc) {
            if (this.targetDocumentFile != null) {
                this.println("IOException during document parse: " + this.targetDocumentFile.getAbsolutePath());
            }
            this.println("IOException: " + exc.getMessage());
            return false;
        }
        String path = System.getProperty("com.ibm.xml.policy.tool.bindTablePath");
        if (path == null) {
            path = "bind.xml";
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            bind_table = builder.parse(path).getDocumentElement();
        }
        catch (Exception e) {
            this.println("Bind table Not Found.");
            this.println(e.getMessage());
            return false;
        }
        String policyName = null;
        String statusName = null;
        NodeList tl = bind_table.getElementsByTagName("target");
        int count = 0;
        for (i = 0; i < tl.getLength(); ++i) {
            if (!((Element)tl.item(i)).getAttribute("href").equals(this.targetDocumentFile.getName())) continue;
            bind = (Element)((Element)tl.item(i)).getParentNode();
            nl = bind.getElementsByTagName("policy");
            if (nl.getLength() > 0) {
                policyName = ((Element)nl.item(0)).getAttribute("href");
            }
            if ((nl = bind.getElementsByTagName("status")).getLength() > 0) {
                statusName = ((Element)nl.item(0)).getAttribute("href");
            }
            ++count;
        }
        if (count > 1) {
            this.println("Multiple Bindings for " + this.targetDocumentFile.getName() + " found.");
            return false;
        }
        if (policyName == null || statusName == null) {
            count = 0;
            for (i = 0; i < tl.getLength(); ++i) {
                if (!((Element)tl.item(i)).getAttribute("href").equals(this.getTargetDocumentSource().getSystemId())) continue;
                bind = (Element)((Element)tl.item(i)).getParentNode();
                nl = bind.getElementsByTagName("policy");
                if (nl.getLength() > 0) {
                    policyName = ((Element)nl.item(0)).getAttribute("href");
                }
                if ((nl = bind.getElementsByTagName("status")).getLength() > 0) {
                    statusName = ((Element)nl.item(0)).getAttribute("href");
                }
                ++count;
            }
        }
        if (count > 1) {
            this.println("Multiple Bindings for " + this.getTargetDocumentSource().getSystemId() + " found.");
            return false;
        }
        if (policyName == null) {
            this.error("No associated policy is found in bind.xml.");
            return false;
        }
        this.policyFile = new File(policyName);
        if (statusName == null) {
            this.error("No associated status is found in bind.xml.");
            return false;
        }
        this.statusFile = new File(statusName);
        try {
            this.policy = this.getPolicySource().parseByFileName(policyName, validation);
            if (this.policy == null) {
                return false;
            }
        }
        catch (SecurityException exc) {
            if (this.policyFile != null) {
                this.error(Strings.DIALOG_FILE_SECURITY_EXCEPTION + "\n\n" + this.policyFile.getAbsolutePath());
            }
            this.println("SecurityException:" + exc.getMessage());
            return false;
        }
        catch (FileNotFoundException exc) {
            if (this.policyFile != null) {
                this.error(Strings.DIALOG_FILE_NOT_FOUND + "\n\n" + this.policyFile.getAbsolutePath());
            }
            this.println("FileNotFoundException:" + exc.getMessage());
            return false;
        }
        catch (SAXException exc) {
            if (this.policyFile != null) {
                this.println("SAXException during document parse: " + this.policyFile.getAbsolutePath());
            }
            this.println("SAXException: " + exc.getMessage());
            return false;
        }
        catch (IOException exc) {
            if (this.policyFile != null) {
                this.println("IOException during document parse: " + this.policyFile.getAbsolutePath());
            }
            this.println("IOException: " + exc.getMessage());
            return false;
        }
        try {
            this.status = this.getStatusSource().parseByFileName(statusName, validation);
            if (this.status == null) {
                return false;
            }
        }
        catch (SecurityException exc) {
            if (this.statusFile != null) {
                this.error(Strings.DIALOG_FILE_SECURITY_EXCEPTION + "\n\n" + this.statusFile.getAbsolutePath());
            }
            this.println("SecurityException:" + exc.getMessage());
            return false;
        }
        catch (FileNotFoundException exc) {
            if (this.statusFile != null) {
                this.error(Strings.DIALOG_FILE_NOT_FOUND + "\n\n" + this.statusFile.getAbsolutePath());
            }
            this.println("FileNotFoundException:" + exc.getMessage());
            return false;
        }
        catch (SAXException exc) {
            if (this.statusFile != null) {
                this.println("SAXException during document parse: " + this.statusFile.getAbsolutePath());
            }
            this.println("SAXException: " + exc.getMessage());
            return false;
        }
        catch (IOException exc) {
            if (this.statusFile != null) {
                this.println("IOException during document parse: " + this.statusFile.getAbsolutePath());
            }
            this.println("IOException: " + exc.getMessage());
            return false;
        }
        this.targetDocumentFile = this.targetDocumentFile;
        this.loadTargetDocumentDone(this.target_document);
        return true;
    }

    private void loadTargetDocumentDone(Document doc) {
        this.getTargetDocumentTree().documentReady(doc);
        if (this.targetDocumentFile != null) {
            this.setTitle(Strings.PROG_NAME + " - " + this.targetDocumentFile.getName());
        } else {
            this.setTitle(Strings.PROG_NAME + " - " + "No target file opened");
        }
        if (this.accessReqFile != null) {
            this.setTitle(this.getTitle() + " - " + this.accessReqFile.getName());
        } else {
            this.setTitle(this.getTitle() + " - " + "No access request file loaded");
        }
        this.FILE_LOADED = true;
        this.getMenuController().switchOn(this.getMenuController().closeDocItem);
    }

    private void loadAccessReqDone(Document doc) {
        if (this.targetDocumentFile != null) {
            this.setTitle(Strings.PROG_NAME + " - " + this.targetDocumentFile.getName());
        } else {
            this.setTitle(Strings.PROG_NAME + " - " + "No target file opened");
        }
        if (this.accessReqFile != null) {
            this.setTitle(this.getTitle() + " - " + this.accessReqFile.getName());
        } else {
            this.setTitle(this.getTitle() + " - " + "No access request file loaded");
        }
        this.getMenuController().switchOn(this.getMenuController().closeDocItem);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            frame = new JFrame();
            VisualTool aVisualTool = new VisualTool();
            frame.getContentPane().add("Center", aVisualTool);
            aVisualTool.init();
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of java.applet.Applet");
            exception.printStackTrace(System.out);
        }
    }

    public void warning(SAXParseException exc) {
        StringBuffer errorString = new StringBuffer();
        errorString.append("Warning at line ");
        errorString.append(exc.getLineNumber());
        errorString.append(", column ");
        errorString.append(exc.getColumnNumber());
        errorString.append(", ID ");
        errorString.append(exc.getPublicId());
        errorString.append(": ");
        errorString.append(exc.getMessage());
        this.println(errorString.toString());
    }

    public void error(SAXParseException exc) {
        StringBuffer errorString = new StringBuffer();
        errorString.append("Error at line ");
        errorString.append(exc.getLineNumber());
        errorString.append(", column ");
        errorString.append(exc.getColumnNumber());
        errorString.append(", ID ");
        errorString.append(exc.getPublicId());
        errorString.append(": ");
        errorString.append(exc.getMessage());
        this.println(errorString.toString());
    }

    public void fatalError(SAXParseException exc) {
        StringBuffer errorString = new StringBuffer();
        errorString.append("Fatal error at line ");
        errorString.append(exc.getLineNumber());
        errorString.append(", column ");
        errorString.append(exc.getColumnNumber());
        errorString.append(", ID ");
        errorString.append(exc.getPublicId());
        errorString.append(": ");
        errorString.append(exc.getMessage());
        this.println(errorString.toString());
    }

    public void println(String message) {
        this.getConsole().println(message);
    }

    public void queryFinish(Thread thread) {
        while (this.queryOptionPane == null || !this.queryOptionPane.isVisible()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.queryOptionPane.setValue(Strings.DONE);
        this.queryDialog.dispose();
    }

    private void queryStart() throws IOException, ParserConfigurationException {
        this.getConsole().clear();
        this.constructAccessRequest();
        if (this.access_req == null) {
            return;
        }
        this.getTargetDocumentTree().removeDecisions();
        String action = this.groupAction.getSelection().getActionCommand();
        if (action.equals("read")) {
            this.view = (Document)this.target_document.cloneNode(true);
            DocumentType dtd = this.view.getDoctype();
            this.startProcessor(this.access_req, this.view, this.policy, this.status);
        } else {
            this.startProcessor(this.access_req, this.target_document, this.policy, this.status);
        }
        if (!this.xaclProcessor.stopped()) {
            this.queryDialog.show();
            String s = (String)this.queryOptionPane.getValue();
            if (s == null || !s.equals(Strings.DONE)) {
                this.xaclProcessor.stopProcessor();
                return;
            }
        }
        this.dl = this.xaclProcessor.getDecisionList();
        this.decision_list = this.dl.getDocument();
        if (this.dl.getAccessRequest().getTargetNode().getNodeType() != 1 && this.dl.getAccessRequest().getTargetNode().getNodeType() != 2) {
            this.warning("The target node must be either an element or an attribute.");
            return;
        }
        if (this.decision_list != null) {
            boolean execute = this.groupRequestType.getSelection().getActionCommand().equals("execute");
            this.documentUpdate(execute, action);
            FileOutputStream fos = new FileOutputStream("decision_list.xml");
            fos.write(Util.Document2ByteArray(this.decision_list, null, null, "UTF-8", true, true, true));
            fos.flush();
            fos.close();
        }
        this.console.scrollToEnd();
    }

    public void question(String text) {
        JOptionPane.showMessageDialog(this.getJAppletContentPanel(), text, Strings.WARNING, 2);
    }

    public void saveAccessRequest() throws IOException {
        this.constructAccessRequest();
        if (this.access_req != null) {
            int returnVal;
            do {
                if ((returnVal = this.getMenuController().getFileChooser().showSaveDialog(this.getJAppletContentPanel())) != 0) continue;
                File file = this.getMenuController().getFileChooser().getSelectedFile();
                int i = 0;
                if (file.exists() && (i = JOptionPane.showConfirmDialog(this.getJAppletContentPanel(), Strings.DIALOG_FILE_EXISTS, Strings.DFE_TITLE, 1)) == 2) {
                    return;
                }
                if (i != 0) continue;
                FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
                fos.write(Util.Document2ByteArray(this.access_req, this.getAccessReqSource().getPublicId(), this.getAccessReqSource().getSystemId(), "UTF-8", true, true, true));
                fos.flush();
                fos.close();
                return;
            } while (returnVal != 1);
            return;
        }
        this.warning("No access request to save.");
    }

    public void saveTargetDoc() throws IOException {
        if (this.target_document != null) {
            FileOutputStream fos = new FileOutputStream(this.targetDocumentFile.getAbsolutePath());
            fos.write(Util.Document2ByteArray(this.target_document, this.getTargetDocumentSource().getPublicId(), this.getTargetDocumentSource().getSystemId(), this.getTargetDocumentSource().getEncoding(), true, true, true));
            fos.flush();
            fos.close();
        }
    }

    public void saveStatusDoc() throws IOException {
        if (this.status != null) {
            FileOutputStream fos = new FileOutputStream(this.statusFile.getAbsolutePath());
            fos.write(Util.Document2ByteArray(this.status, this.getStatusSource().getPublicId(), this.getStatusSource().getSystemId(), this.getStatusSource().getEncoding(), true, true, true));
            fos.flush();
            fos.close();
        }
    }

    private void setTitle(String title) {
        frame.setTitle(title);
    }

    private String getTitle() {
        return frame.getTitle();
    }

    private boolean startProcessor(Document access_req, Document target_doc, Document policy, Document status) {
        if (access_req == null) {
            this.println(Strings.NO_AccessRequest);
            return false;
        }
        if (this.queryOptionPane == null) {
            this.queryOptionPane = new JOptionPane(Strings.DIALOG_EVALUATION_START, 1, -1, null, new Object[]{Strings.STOP_REQUEST});
        }
        if (this.queryDialog == null) {
            this.queryDialog = this.queryOptionPane.createDialog(this.getJAppletContentPanel(), Strings.WAIT);
        }
        if (this.xaclProcessor == null) {
            this.xaclProcessor = new ThreadedXACLProcessor(this);
        }
        this.xaclProcessor.start(access_req, target_doc, policy, status);
        return true;
    }

    private boolean unassigned(String value, String message) {
        if (value == null || value.equals("")) {
            JOptionPane.showMessageDialog(this.getJAppletContentPanel(), message, Strings.INPUT_MISSING, 2);
            return true;
        }
        return false;
    }

    public void warning(String text) {
        JOptionPane.showMessageDialog(this.getJAppletContentPanel(), text, Strings.WARNING, 2);
    }

    private boolean setQuery(Element query) {
        if (query == null) {
            return false;
        }
        this.AR_NSPREFIX_TABLE = new Hashtable();
        NamedNodeMap map = query.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            if (!attr.getName().equals("xmlns") && !attr.getName().startsWith("xmlns:")) continue;
            this.AR_NSPREFIX_TABLE.put(attr.getName(), attr.getNodeValue());
        }
        String ret = this.setType(query);
        if (ret != null) {
            this.println(ret);
            return false;
        }
        ret = this.setObject(query);
        if (ret != null) {
            this.println(ret);
            return false;
        }
        ret = this.setSubject(query);
        if (ret != null) {
            this.println(ret);
            return false;
        }
        try {
            ret = this.setAction(query);
        }
        catch (IOException ex) {
            this.error(ex.toString());
            return false;
        }
        if (ret != null) {
            this.println(ret);
            return false;
        }
        return true;
    }

    private String setType(Element d) {
        String type = d.getAttribute("type");
        Enumeration<AbstractButton> buttons = this.groupRequestType.getElements();
        while (buttons.hasMoreElements()) {
            JRadioButton button = (JRadioButton)buttons.nextElement();
            if (!button.getActionCommand().equals(type)) continue;
            button.setSelected(true);
            break;
        }
        return null;
    }

    private String setObject(Element d) {
        Vector vec = Util.getChildElementsByTagNameNS(d, "http://www.trl.ibm.com/projects/xml/xacl", "object");
        int l = vec.size();
        if (l < 1) {
            return null;
        }
        if (l > 1) {
            return "More than one object element in access_req.";
        }
        Element object = (Element)vec.elementAt(0);
        this.tfHref.setText(object.getAttribute("href"));
        this.OBJ_NSPREFIX_TABLE = new Hashtable();
        NamedNodeMap map = object.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            if (!attr.getName().equals("xmlns") && !attr.getName().startsWith("xmlns:")) continue;
            this.OBJ_NSPREFIX_TABLE.put(attr.getName(), attr.getNodeValue());
        }
        return null;
    }

    private String setAction(Element d) throws IOException, UnsupportedEncodingException {
        Vector vec = Util.getChildElementsByTagNameNS(d, "http://www.trl.ibm.com/projects/xml/xacl", "action");
        int l = vec.size();
        if (l < 1) {
            return null;
        }
        if (l > 1) {
            return "More than one action element in access_req.";
        }
        Element ActionNode = (Element)vec.elementAt(0);
        String Action2 = ActionNode.getAttribute("name");
        Enumeration<AbstractButton> actionButtons = this.groupAction.getElements();
        while (actionButtons.hasMoreElements()) {
            JRadioButton button = (JRadioButton)actionButtons.nextElement();
            if (!button.getActionCommand().equals(Action2)) continue;
            button.setSelected(true);
            break;
        }
        if ((vec = Util.getChildElementsByTagNameNS(ActionNode, "http://www.trl.ibm.com/projects/xml/xacl", "parameter")).size() != 0) {
            Element parameterNode = (Element)vec.elementAt(0);
            this.tfParameter.setText(Util.Element2String(parameterNode, null, null, "UTF-8", false, false, false));
        }
        return null;
    }

    private String setSubject(Element d) {
        Vector vec = Util.getChildElementsByTagNameNS(d, "http://www.trl.ibm.com/projects/xml/xacl", "subject");
        int l = vec.size();
        if (l < 1) {
            return null;
        }
        if (l > 1) {
            return "More than one subject element in access_req.";
        }
        Element subject = (Element)vec.elementAt(0);
        NodeList list = subject.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "uid");
        if (list.getLength() > 0) {
            Node uidNode = list.item(0);
            String uid = DecisionTreeNode.getTextFrom(uidNode).trim();
            this.tfUID.setText(uid);
        }
        String roles = null;
        list = subject.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "role");
        for (int i = 0; i < list.getLength(); ++i) {
            Node roleNode = list.item(i);
            roles = roles == null ? DecisionTreeNode.getTextFrom(roleNode) : roles + Strings.ROLES_DELIMITER.substring(0, 1) + DecisionTreeNode.getTextFrom(roleNode);
        }
        this.tfRole.setText(roles);
        String groups = null;
        list = subject.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "group");
        for (int i = 0; i < list.getLength(); ++i) {
            Node groupNode = list.item(i);
            groups = groups == null ? DecisionTreeNode.getTextFrom(groupNode) : groups + Strings.ROLES_DELIMITER.substring(0, 1) + DecisionTreeNode.getTextFrom(groupNode);
        }
        this.tfGroup.setText(groups);
        return null;
    }

    public DocumentViewer getDocumentViewer() {
        if (this.documentViewer == null) {
            this.documentViewer = new DocumentViewer(this);
        }
        return this.documentViewer;
    }

    public ParameterViewer getParameterViewer() {
        if (this.parameterViewer == null) {
            this.parameterViewer = new ParameterViewer();
        }
        return this.parameterViewer;
    }

    public JFrame getPolicyViewer() {
        if (this.policyViewer == null) {
            this.policyViewer = new JFrame();
            this.policyViewer.setTitle(Strings.MENU_TOOLS_POLICY_VIEWER + " - " + Strings.PROG_NAME);
            this.policyViewer.setSize(800, 600);
            this.policyViewer.getContentPane().setLayout(new GridLayout());
            this.policyViewer.getContentPane().add(this.getPolicyPane());
        }
        return this.policyViewer;
    }

    public JFrame getStatusViewer() {
        if (this.statusViewer == null) {
            this.statusViewer = new JFrame();
            this.statusViewer.setTitle(Strings.MENU_TOOLS_STATUS_VIEWER + " - " + Strings.PROG_NAME);
            this.statusViewer.setSize(800, 600);
            this.statusViewer.getContentPane().setLayout(new GridLayout());
            this.statusViewer.getContentPane().add(this.getStatusPane());
        }
        return this.statusViewer;
    }

    public JFrame getAccessReqViewer() {
        if (this.accessReqViewer == null) {
            this.accessReqViewer = new JFrame();
            this.accessReqViewer.setTitle(Strings.MENU_TOOLS_ACCESS_REQ_VIEWER + " - " + Strings.PROG_NAME);
            this.accessReqViewer.setSize(800, 600);
            this.accessReqViewer.getContentPane().setLayout(new GridLayout());
            this.accessReqViewer.getContentPane().add(this.getAccessReqPane());
        }
        return this.accessReqViewer;
    }

    public JFrame getDecisionListViewer() {
        if (this.decisionListViewer == null) {
            this.decisionListViewer = new JFrame();
            this.decisionListViewer.setTitle(Strings.MENU_TOOLS_DECISION_LIST_VIEWER + " - " + Strings.PROG_NAME);
            this.decisionListViewer.setSize(800, 600);
            this.decisionListViewer.getContentPane().setLayout(new GridLayout());
            this.decisionListViewer.getContentPane().add(this.getDecisionListPane());
        }
        return this.decisionListViewer;
    }

    public Document getPolicy() {
        return this.policy;
    }

    public Document getStatus() {
        return this.status;
    }

    public Document getDecisionList() {
        return this.decision_list;
    }

    public Document getAccessRequest() {
        return this.access_req;
    }

    String getGroupList(String uid) {
        Document group_doc;
        String fileName = System.getProperty("com.ibm.xml.policy.tool.groupDefinitionPath");
        if (fileName == null) {
            fileName = "group.xml";
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            group_doc = builder.parse(fileName);
        }
        catch (SAXException ex) {
            this.error("Failed to parser " + fileName);
            this.getConsole().println(ex.toString());
            return "";
        }
        catch (IOException ex) {
            this.error("Failed to open " + fileName);
            this.getConsole().println(ex.toString());
            return "";
        }
        catch (ParserConfigurationException ex) {
            this.error("Failed to parser " + fileName);
            this.getConsole().println(ex.toString());
            return "";
        }
        Vector<String> vec = new Vector<String>();
        NodeList nl = group_doc.getElementsByTagName("group");
        block4: for (int i = 0; i < nl.getLength(); ++i) {
            NodeList names = ((Element)nl.item(i)).getElementsByTagName("name");
            String group_name = Util.getTextNodeValue((Element)names.item(0));
            NodeList members = ((Element)nl.item(i)).getElementsByTagName("member");
            for (int j = 0; j < members.getLength(); ++j) {
                if (!Util.getTextNodeValue((Element)members.item(j)).equals(uid)) continue;
                vec.addElement(new String(group_name));
                continue block4;
            }
        }
        if (vec.size() > 0) {
            String[] group = new String[vec.size()];
            System.arraycopy(vec.toArray(), 0, group, 0, group.length);
            return Util.makeList(group);
        }
        return "";
    }

    static {
        VARIABLE = false;
        validation = false;
    }
}

