/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.VisualTool;
import com.ibm.xml.policy.xacl.DecisionList;
import com.ibm.xml.policy.xacl.Hierarchy;
import com.ibm.xml.policy.xacl.HierarchyImpl;
import com.ibm.xml.policy.xacl.XACLProcessorImpl;
import com.ibm.xml.policy.xacl.XaclException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class ThreadedXACLProcessor
implements Runnable {
    private VisualTool vt;
    private Document access_req = null;
    private Document target_doc = null;
    private Document policy = null;
    private Document status = null;
    private DecisionList decision_list = null;
    public Thread processorThread = null;

    public ThreadedXACLProcessor(VisualTool t) {
        this.vt = t;
    }

    public DecisionList getDecisionList() {
        return this.decision_list;
    }

    public void run() {
        this.sleep(500L);
        this.startProcessor();
        this.vt.queryFinish(this.processorThread);
        this.stop();
    }

    public void sleep(long nap) {
        if (this.processorThread != null) {
            try {
                Thread.sleep(nap);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start(Document access_req, Document target_doc, Document policy, Document status) {
        this.decision_list = null;
        this.access_req = access_req;
        this.target_doc = target_doc;
        this.policy = policy;
        this.status = status;
        if (access_req == null) {
            return;
        }
        this.processorThread = new Thread((Runnable)this, "XACLProcessor");
        this.processorThread.start();
    }

    public void startProcessor() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            HierarchyImpl rh = null;
            HierarchyImpl gh = null;
            String fileName = System.getProperty("com.ibm.xml.policy.xacl.rh");
            if (fileName != null && !fileName.equals("")) {
                rh = new HierarchyImpl(builder.parse(fileName));
            }
            if ((fileName = System.getProperty("com.ibm.xml.policy.xacl.gh")) != null && !fileName.equals("")) {
                gh = new HierarchyImpl(builder.parse(fileName));
            }
            if (this.target_doc != null) {
                long start = System.currentTimeMillis();
                this.decision_list = XACLProcessorImpl.process(this.access_req.getDocumentElement(), this.target_doc, this.policy.getDocumentElement(), this.status.getDocumentElement(), (Hierarchy)rh, (Hierarchy)gh);
                long end = System.currentTimeMillis();
                long time = end - start;
                this.vt.println("The processing time was " + time + " ms.");
            }
        }
        catch (XaclException e) {
            this.vt.error("An XACL Processor Exception is thrown.");
            this.vt.println(" ");
            this.vt.println("XACL Processor Exception:");
            this.vt.println(e.getMessage());
        }
        catch (ThreadDeath death) {
            this.vt.println("\n\nQuery aborted ");
        }
        catch (Throwable e) {
            this.vt.println(" ");
            this.vt.println("Uncaught exception in XACLProcessor: ");
            this.vt.println(e.getMessage());
            e.printStackTrace(System.out);
        }
    }

    public synchronized void stop() {
        this.processorThread = null;
    }

    public synchronized boolean stopped() {
        return this.processorThread == null;
    }

    public synchronized void stopProcessor() {
        if (this.processorThread != null) {
            this.processorThread.interrupt();
            this.processorThread = null;
        }
    }
}

