/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.DecisionTreeNode;
import com.ibm.xml.policy.tool.MyMutableTreeNode;
import com.ibm.xml.policy.tool.Strings;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class TargetDocTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color orgSelectionBackground = this.getBackgroundSelectionColor();

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (this.isDecisionTreeNode(value)) {
            DecisionTreeNode dtn = (DecisionTreeNode)((MyMutableTreeNode)value).getUserObject();
            if (dtn.permission.equals("grant")) {
                this.setForeground(Color.green.darker());
            } else if (dtn.permission.equals("deny")) {
                this.setForeground(Color.red);
            }
            this.setBackgroundSelectionColor(Color.lightGray);
            this.setToolTipText(Strings.DECISION_NODE_TIP);
        } else {
            this.setBackgroundSelectionColor(this.orgSelectionBackground);
            this.setToolTipText(null);
        }
        return this;
    }

    protected boolean isDecisionTreeNode(Object o) {
        MyMutableTreeNode node = (MyMutableTreeNode)o;
        return node.getUserObject() instanceof DecisionTreeNode;
    }

    protected boolean userObjectIs(Object o, String value) {
        MyMutableTreeNode node = (MyMutableTreeNode)o;
        String label = (String)node.getUserObject();
        return label.equals(value);
    }
}

