/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.HelpPanel;
import com.ibm.xml.policy.tool.LoadList;
import com.ibm.xml.policy.tool.Strings;
import com.ibm.xml.policy.tool.VisualTool;
import com.ibm.xml.policy.tool.XMLFileFilter;
import com.ibm.xml.policy.xacl.XACLProcessorImpl;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.w3c.dom.Document;

public class MenuController {
    private VisualTool vt;
    private File currentDir = null;
    public HelpPanel hp;
    private Document lastPolicy = null;
    private LoadList target_documents;
    private LoadList access_requests;
    private JMenu docList;
    private JMenu accessReqList;
    public JFileChooser fileChooser = null;
    public JPopupMenu xPathMenu = null;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu toolsMenu;
    private JMenu helpMenu;
    public JMenuItem closeDocItem;
    private ActionListener listenerFile = null;
    private ActionListener listenerDocList = null;
    private ActionListener listenerAccessReqList = null;
    private ActionListener listenerTools = null;
    private ActionListener listenerHelp = null;
    private ActionListener listenerXPTerm = null;

    public MenuController(VisualTool vt) {
        this.vt = vt;
        this.access_requests = new LoadList(Strings.AR_LOADLIST);
        this.access_requests.setLimit(Strings.LIST_LIMIT);
        this.target_documents = new LoadList(Strings.DOC_LOADLIST);
        this.target_documents.setLimit(Strings.LIST_LIMIT);
        this.installMenuBar();
        this.hp = new HelpPanel(Strings.PROG_NAME);
    }

    private ActionListener actionAccessReqList() {
        if (this.listenerAccessReqList == null) {
            this.listenerAccessReqList = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String name = e.getActionCommand();
                    if (name != null && !MenuController.this.vt.loadAccessRequest(name)) {
                        MenuController.this.vt.error("The access request could not be loaded correctly.");
                    }
                }
            };
        }
        return this.listenerAccessReqList;
    }

    private ActionListener actionDocList() {
        if (this.listenerDocList == null) {
            this.listenerDocList = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String name = e.getActionCommand();
                    if (name != null && !MenuController.this.vt.loadTargetDocument(name)) {
                        MenuController.this.vt.error("The target document could not be opened correctly.");
                    }
                }
            };
        }
        return this.listenerDocList;
    }

    private ActionListener actionFile() {
        if (this.listenerFile == null) {
            this.listenerFile = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String com = e.getActionCommand();
                    if (com.equals(Strings.MENU_OPEN_TARGET_DOC)) {
                        int returnVal = MenuController.this.getFileChooser().showOpenDialog(MenuController.this.vt.getJAppletContentPanel());
                        if (returnVal == 0) {
                            MenuController.this.currentDir = MenuController.this.getFileChooser().getSelectedFile();
                            if (MenuController.this.vt.loadTargetDocument(MenuController.this.getFileChooser().getSelectedFile().getAbsolutePath())) {
                                MenuController.this.target_documents.add(MenuController.this.getFileChooser().getSelectedFile().getAbsolutePath());
                            } else {
                                MenuController.this.vt.error("The target document could not be opened correctly.");
                            }
                        }
                    } else if (com.equals(Strings.MENU_LOAD_ACCESS_REQ)) {
                        int returnVal = MenuController.this.getFileChooser().showOpenDialog(MenuController.this.vt.getJAppletContentPanel());
                        if (returnVal == 0) {
                            MenuController.this.currentDir = MenuController.this.getFileChooser().getSelectedFile();
                            if (MenuController.this.vt.loadAccessRequest(MenuController.this.getFileChooser().getSelectedFile().getAbsolutePath())) {
                                MenuController.this.access_requests.add(MenuController.this.getFileChooser().getSelectedFile().getAbsolutePath());
                            } else {
                                MenuController.this.vt.error("The access request could not be loaded correctly.");
                            }
                        }
                    } else if (com.equals(Strings.MENU_SAVE_ACCESS_REQ)) {
                        try {
                            MenuController.this.vt.saveAccessRequest();
                        }
                        catch (IOException ex) {
                            MenuController.this.vt.error(ex.toString());
                        }
                    } else if (com.equals(Strings.MENU_FILE_EXIT)) {
                        MenuController.this.vt.exit();
                    } else if (com.equals(Strings.MENU_CLOSE_ALL_DOCS)) {
                        MenuController.this.vt.closeAllDocuments();
                    }
                }
            };
        }
        return this.listenerFile;
    }

    private ActionListener actionHelp() {
        if (this.listenerHelp == null) {
            this.listenerHelp = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String com = e.getActionCommand();
                    if (com.equals(Strings.MENU_HELP_ABOUT)) {
                        MenuController.this.hp.setVisible(true);
                        MenuController.this.hp.readPage(Strings.HELP_PAGE);
                    } else if (com.equals(Strings.MENU_HELP_VERSION)) {
                        JOptionPane.showMessageDialog(MenuController.this.vt.getJAppletContentPanel(), XACLProcessorImpl.getVersion(), Strings.MENU_HELP_VERSION, 1);
                    }
                }
            };
        }
        return this.listenerHelp;
    }

    private ActionListener actionTools() {
        if (this.listenerTools == null) {
            this.listenerTools = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String com = e.getActionCommand();
                    if (com.equals(Strings.MENU_TOOLS_CLEAR_CONSOLE)) {
                        MenuController.this.vt.getConsole().clear();
                    } else if (com.equals(Strings.MENU_TOOLS_CLEAR_REQUEST)) {
                        MenuController.this.vt.clearAccessRequestComposer();
                    } else if (com.equals(Strings.MENU_TOOLS_POLICY_VIEWER)) {
                        if (MenuController.this.vt.getPolicyViewer().isVisible()) {
                            MenuController.this.vt.getPolicyViewer().setVisible(false);
                            return;
                        }
                        if (MenuController.this.lastPolicy != MenuController.this.vt.getPolicy()) {
                            MenuController.this.vt.getPolicyTP().writeDOM(MenuController.this.vt.getPolicy(), MenuController.this.vt.getPolicySource().getPublicId(), MenuController.this.vt.getPolicySource().getSystemId(), MenuController.this.vt.getPolicySource().getEncoding(), false);
                        }
                        MenuController.this.lastPolicy = MenuController.this.vt.getPolicy();
                        MenuController.this.vt.getPolicyViewer().setVisible(true);
                    } else if (com.equals(Strings.MENU_TOOLS_STATUS_VIEWER)) {
                        if (MenuController.this.vt.getStatusViewer().isVisible()) {
                            MenuController.this.vt.getStatusViewer().setVisible(false);
                            return;
                        }
                        MenuController.this.vt.getStatusTP().writeDOM(MenuController.this.vt.getStatus(), MenuController.this.vt.getStatusSource().getPublicId(), MenuController.this.vt.getStatusSource().getSystemId(), MenuController.this.vt.getStatusSource().getEncoding(), false);
                        MenuController.this.vt.getStatusViewer().setVisible(true);
                    } else if (com.equals(Strings.MENU_TOOLS_ACCESS_REQ_VIEWER)) {
                        if (MenuController.this.vt.getAccessReqViewer().isVisible()) {
                            MenuController.this.vt.getAccessReqViewer().setVisible(false);
                            return;
                        }
                        MenuController.this.vt.getAccessReqTP().writeDOM(MenuController.this.vt.getAccessRequest(), MenuController.this.vt.getAccessReqSource().getPublicId(), MenuController.this.vt.getAccessReqSource().getSystemId(), MenuController.this.vt.getAccessReqSource().getEncoding(), false);
                        MenuController.this.vt.getAccessReqViewer().setVisible(true);
                    } else if (com.equals(Strings.MENU_TOOLS_DECISION_LIST_VIEWER)) {
                        if (MenuController.this.vt.getDecisionListViewer().isVisible()) {
                            MenuController.this.vt.getDecisionListViewer().setVisible(false);
                            return;
                        }
                        MenuController.this.vt.getDecisionListTP().writeDOM(MenuController.this.vt.getDecisionList(), null, null, null, false);
                        MenuController.this.vt.getDecisionListViewer().setVisible(true);
                    } else {
                        return;
                    }
                }
            };
        }
        return this.listenerTools;
    }

    private ActionListener actionXPTerm() {
        if (this.listenerXPTerm == null) {
            this.listenerXPTerm = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(Strings.XP_REMOVE)) {
                        MenuController.removeTerm(((MenuController)MenuController.this).vt.tfHref);
                    } else {
                        MenuController.insertText(e, ((MenuController)MenuController.this).vt.tfHref);
                    }
                }
            };
        }
        return this.listenerXPTerm;
    }

    private static void insertText(ActionEvent e, JTextField text) {
        String command = e.getActionCommand();
        javax.swing.text.Document doc = text.getDocument();
        int pos = text.getCaretPosition();
        try {
            doc.insertString(pos, command, null);
        }
        catch (BadLocationException exc) {
            return;
        }
        text.requestFocus();
        text.setCaretPosition(pos + command.length());
    }

    private static void removeTerm(JTextField text) {
        String s;
        javax.swing.text.Document doc = text.getDocument();
        try {
            s = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException exc) {
            return;
        }
        if (s != null) {
            int pos = text.getCaretPosition();
            int left = s.lastIndexOf(".", pos - 1);
            left = left < 0 ? 0 : ++left;
            int right = s.indexOf(".", pos);
            if (right < 0) {
                right = doc.getLength();
                if (left > 0) {
                    --left;
                }
            } else {
                ++right;
            }
            if (left < right) {
                try {
                    doc.remove(left, right - left);
                }
                catch (BadLocationException exc) {
                    return;
                }
            }
        }
        text.requestFocus();
    }

    public boolean close() {
        this.target_documents.saveList();
        this.access_requests.saveList();
        return true;
    }

    public JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            XMLFileFilter ff = new XMLFileFilter();
            this.fileChooser.addChoosableFileFilter(ff);
            this.fileChooser.setFileFilter(ff);
            if (this.currentDir == null) {
                this.currentDir = new File(".");
            }
            this.fileChooser.setCurrentDirectory(this.currentDir);
        }
        return this.fileChooser;
    }

    private JMenu getFileMenu() {
        this.fileMenu = new JMenu(Strings.MENU_MAIN_FILE);
        JMenuItem menuItem = new JMenuItem(Strings.MENU_OPEN_TARGET_DOC);
        menuItem.setActionCommand(Strings.MENU_OPEN_TARGET_DOC);
        menuItem.addActionListener(this.actionFile());
        this.fileMenu.add(menuItem);
        this.fileMenu = this.target_documents.setListMenu(this.fileMenu, this.actionDocList(), Strings.MENU_FILE_RECENT);
        this.fileMenu.addSeparator();
        menuItem = new JMenuItem(Strings.MENU_LOAD_ACCESS_REQ);
        menuItem.setActionCommand(Strings.MENU_LOAD_ACCESS_REQ);
        menuItem.addActionListener(this.actionFile());
        this.fileMenu.add(menuItem);
        this.fileMenu = this.access_requests.setListMenu(this.fileMenu, this.actionAccessReqList(), Strings.MENU_FILE_RECENT);
        menuItem = new JMenuItem(Strings.MENU_SAVE_ACCESS_REQ);
        menuItem.setActionCommand(Strings.MENU_SAVE_ACCESS_REQ);
        menuItem.addActionListener(this.actionFile());
        this.fileMenu.add(menuItem);
        this.fileMenu.addSeparator();
        menuItem = new JMenuItem(Strings.MENU_CLOSE_ALL_DOCS);
        menuItem.setEnabled(false);
        menuItem.setActionCommand(Strings.MENU_CLOSE_ALL_DOCS);
        menuItem.addActionListener(this.actionFile());
        this.fileMenu.add(menuItem);
        this.closeDocItem = menuItem;
        menuItem = new JMenuItem(Strings.MENU_FILE_EXIT);
        menuItem.setActionCommand(Strings.MENU_FILE_EXIT);
        menuItem.addActionListener(this.actionFile());
        this.fileMenu.add(menuItem);
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        this.helpMenu = new JMenu(Strings.MENU_MAIN_HELP);
        JMenuItem menuItem = new JMenuItem(Strings.MENU_HELP_ABOUT);
        menuItem.setActionCommand(Strings.MENU_HELP_ABOUT);
        menuItem.addActionListener(this.actionHelp());
        this.helpMenu.add(menuItem);
        menuItem = new JMenuItem(Strings.MENU_HELP_VERSION);
        menuItem.setActionCommand(Strings.MENU_HELP_VERSION);
        menuItem.addActionListener(this.actionHelp());
        this.helpMenu.add(menuItem);
        return this.helpMenu;
    }

    private JMenu getToolsMenu() {
        this.toolsMenu = new JMenu(Strings.MENU_MAIN_TOOLS);
        JMenuItem menuItem = new JMenuItem(Strings.MENU_TOOLS_POLICY_VIEWER);
        menuItem.setActionCommand(Strings.MENU_TOOLS_POLICY_VIEWER);
        menuItem.addActionListener(this.actionTools());
        this.toolsMenu.add(menuItem);
        menuItem = new JMenuItem(Strings.MENU_TOOLS_STATUS_VIEWER);
        menuItem.setActionCommand(Strings.MENU_TOOLS_STATUS_VIEWER);
        menuItem.addActionListener(this.actionTools());
        this.toolsMenu.add(menuItem);
        menuItem = new JMenuItem(Strings.MENU_TOOLS_ACCESS_REQ_VIEWER);
        menuItem.setActionCommand(Strings.MENU_TOOLS_ACCESS_REQ_VIEWER);
        menuItem.addActionListener(this.actionTools());
        this.toolsMenu.add(menuItem);
        menuItem = new JMenuItem(Strings.MENU_TOOLS_DECISION_LIST_VIEWER);
        menuItem.setActionCommand(Strings.MENU_TOOLS_DECISION_LIST_VIEWER);
        menuItem.addActionListener(this.actionTools());
        this.toolsMenu.add(menuItem);
        this.toolsMenu.addSeparator();
        menuItem = new JMenuItem(Strings.MENU_TOOLS_CLEAR_REQUEST);
        menuItem.setActionCommand(Strings.MENU_TOOLS_CLEAR_REQUEST);
        menuItem.addActionListener(this.actionTools());
        this.toolsMenu.add(menuItem);
        menuItem = new JMenuItem(Strings.MENU_TOOLS_CLEAR_CONSOLE);
        menuItem.setActionCommand(Strings.MENU_TOOLS_CLEAR_CONSOLE);
        menuItem.addActionListener(this.actionTools());
        this.toolsMenu.add(menuItem);
        return this.toolsMenu;
    }

    private JPopupMenu getXPathMenu() {
        if (this.xPathMenu == null) {
            try {
                JMenuItem menuItem;
                int i;
                this.xPathMenu = new JPopupMenu();
                this.xPathMenu.setName("XPathMenu");
                JMenu subMenu = new JMenu(Strings.XP_AXIS);
                for (i = 0; i < Strings.XP_AXIS_TERMS.length; ++i) {
                    menuItem = new JMenuItem(Strings.XP_AXIS_TERMS[i]);
                    menuItem.setActionCommand(Strings.XP_AXIS_TERMS[i]);
                    menuItem.addActionListener(this.actionXPTerm());
                    subMenu.add(menuItem);
                }
                this.xPathMenu.add(subMenu);
                subMenu = new JMenu(Strings.XP_FUNCTION);
                for (i = 0; i < Strings.XP_FUNCTION_TERMS.length; ++i) {
                    menuItem = new JMenuItem(Strings.XP_FUNCTION_TERMS[i]);
                    menuItem.setActionCommand(Strings.XP_FUNCTION_TERMS[i] + "()");
                    menuItem.addActionListener(this.actionXPTerm());
                    subMenu.add(menuItem);
                }
                this.xPathMenu.add(subMenu);
            }
            catch (Throwable ivjExc) {
                this.vt.handleException(ivjExc);
            }
        }
        return this.xPathMenu;
    }

    public void installMenuBar() {
        this.menuBar = new JMenuBar();
        this.vt.setJMenuBar(this.menuBar);
        this.menuBar.add(this.getFileMenu());
        this.menuBar.add(this.getToolsMenu());
        this.menuBar.add(this.getHelpMenu());
        this.getXPathMenu();
    }

    public void switchOff(JMenuItem item) {
        item.setEnabled(false);
    }

    public void switchOn(JMenuItem item) {
        item.setEnabled(true);
    }
}

