/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class LoadList {
    private String list = null;
    private String fileName = null;
    private JMenu parentMenu = null;
    private JMenu listMenu = null;
    private ActionListener listener = null;
    private String DELIMITER = "?";
    private int LIMIT = 3;
    private int ABRIDGE_LENGTH = 40;
    private StringTokenizer st = null;

    public LoadList(String fn) {
        this.fileName = fn;
        this.loadList();
    }

    public String abridge(String str) {
        if (this.ABRIDGE_LENGTH <= 10) {
            this.ABRIDGE_LENGTH = 10;
        }
        if (str.length() >= this.ABRIDGE_LENGTH + 12) {
            return str.substring(0, 8) + "..." + str.substring(str.length() - this.ABRIDGE_LENGTH);
        }
        return str;
    }

    public void add(String element) {
        if (this.list == null) {
            this.list = element;
        } else {
            boolean exist = false;
            StringTokenizer stTemp = new StringTokenizer(this.list, this.DELIMITER, false);
            while (stTemp.hasMoreElements()) {
                if (!stTemp.nextElement().equals(element)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                if (stTemp.countTokens() >= this.LIMIT) {
                    this.removeLast();
                }
                this.list = element + this.DELIMITER + this.list;
            }
        }
        this.reset();
        this.updateListMenu();
    }

    public String loadList() {
        try {
            FileInputStream in = new FileInputStream(this.fileName);
            ObjectInputStream s = new ObjectInputStream(in);
            this.list = (String)s.readObject();
            return this.list;
        }
        catch (IOException exc) {
            this.list = null;
            return this.list;
        }
        catch (ClassNotFoundException cexc) {
            this.list = null;
            return this.list;
        }
    }

    public String nextElement() {
        if (this.st == null) {
            this.st = new StringTokenizer(this.list, this.DELIMITER, false);
        }
        if (this.st.hasMoreTokens()) {
            return this.st.nextToken();
        }
        return null;
    }

    public String nextElement(boolean abridged) {
        if (this.st == null) {
            this.st = new StringTokenizer(this.list, this.DELIMITER, false);
        }
        if (this.st.hasMoreTokens()) {
            if (abridged) {
                return this.abridge(this.st.nextToken());
            }
            return this.st.nextToken();
        }
        return null;
    }

    private void removeLast() {
        this.list = this.list.substring(0, this.list.lastIndexOf(this.DELIMITER));
        this.reset();
    }

    public void reset() {
        if (this.list != null) {
            this.st = new StringTokenizer(this.list, this.DELIMITER, false);
        }
    }

    public boolean saveList() {
        try {
            FileOutputStream out = new FileOutputStream(this.fileName);
            ObjectOutputStream s = new ObjectOutputStream(out);
            s.writeObject(this.list);
            s.flush();
            s.close();
            out.close();
            return true;
        }
        catch (IOException exc) {
            return false;
        }
    }

    public void setLimit(int l) {
        if (l > 3) {
            this.LIMIT = l;
        }
    }

    public JMenu setListMenu(JMenu parentMenu, ActionListener l, String name) {
        this.listener = l;
        this.listMenu = new JMenu(name);
        this.updateListMenu();
        parentMenu.add(this.listMenu);
        return parentMenu;
    }

    public void updateListMenu() {
        if (this.listMenu == null) {
            return;
        }
        if (this.listMenu.getItemCount() > 0) {
            this.listMenu.removeAll();
        }
        this.reset();
        if (this.st != null && this.st.countTokens() > 0) {
            while (this.st.hasMoreTokens()) {
                String name = this.st.nextToken();
                JMenuItem menuItem = new JMenuItem(this.abridge(name));
                menuItem.setActionCommand(name);
                menuItem.addActionListener(this.listener);
                this.listMenu.add(menuItem);
            }
            this.listMenu.setEnabled(true);
        } else {
            this.listMenu.setEnabled(false);
        }
    }
}

