/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.List;
import com.ibm.xml.policy.tool.Strings;
import com.ibm.xml.policy.tool.VisualTool;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class DecisionTreeNode {
    String label = null;
    VisualTool vt;
    List menuParaList;
    String href = "";
    String permission = "";
    String pactions = null;
    List paction_parameters = null;
    JPopupMenu popup = null;
    Color popupBack;
    Color popupFore;
    Object orgUserObject = null;
    int ERROR = 0;
    String ERROR_MESSAGE = null;

    DecisionTreeNode() {
    }

    DecisionTreeNode(Element d, VisualTool vt) {
        this.vt = vt;
        JToolTip jtt = new JToolTip();
        jtt.setTipText("aux");
        this.popupBack = jtt.getBackground();
        this.popupFore = jtt.getForeground();
        if (d != null) {
            this.href = d.getAttribute("href");
            this.permission = d.getAttribute("permission");
            this.extractPActions(d);
        } else {
            this.setError("DecisionTreeNode constructor: no decision element passed");
        }
    }

    void addProvisionalAction(String list, String paction) {
        if (paction != null && (list == null || list.indexOf(paction) == -1)) {
            list = list == null ? paction : list + paction;
            return;
        }
    }

    DecisionTreeNode cloneNode() {
        DecisionTreeNode clone = new DecisionTreeNode();
        clone.vt = this.vt;
        clone.label = this.label;
        clone.href = this.href;
        clone.permission = this.permission;
        clone.pactions = this.pactions;
        clone.paction_parameters = this.paction_parameters;
        clone.ERROR = this.ERROR;
        clone.ERROR_MESSAGE = this.ERROR_MESSAGE;
        return clone;
    }

    void extractPActions(Element d) {
        NodeList list = d.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "provisional_action");
        for (int i = 0; i < list.getLength(); ++i) {
            Element pactionNode = (Element)list.item(i);
            String name = pactionNode.getAttribute("name");
            String timing = pactionNode.getAttribute("timing");
            if (this.pactions == null) {
                this.pactions = "";
            }
            this.pactions = this.pactions + "provisional_action: " + name + " (" + timing + ")\n";
            if (this.paction_parameters == null) {
                this.paction_parameters = new List();
            }
            this.paction_parameters.append(pactionNode.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "provisional_action"));
        }
    }

    int getErrorCount() {
        return this.ERROR;
    }

    String getErrorMessage() {
        return this.ERROR_MESSAGE;
    }

    private JComponent getParaMenuComponent(String name, Element para) {
        if (para == null) {
            return null;
        }
        para.normalize();
        if (para.getChildNodes().getLength() == 1 && para.getFirstChild().getNodeType() == 3) {
            String pcdata = ((Text)para.getFirstChild()).getData();
            JLabel l = new JLabel(this.wrap("parameter: " + pcdata.trim()));
            l.setBackground(this.popupBack);
            l.setForeground(this.popupFore);
            return l;
        }
        JMenuItem mi = new JMenuItem('<' + Strings.PARA_INSPECTOR + '>');
        Parameter p = new Parameter(name, para);
        if (this.menuParaList == null) {
            this.menuParaList = new List();
        }
        this.menuParaList.append(p);
        mi.addMouseListener(p);
        mi.setBackground(this.popupBack);
        mi.setForeground(this.popupFore);
        return mi;
    }

    JPopupMenu getPopup() {
        if (this.popup == null) {
            this.popup = (JPopupMenu)this.getSinglePopup(true);
            this.popup.addPopupMenuListener(new PopupListener());
        }
        return this.popup;
    }

    private JComponent getSinglePopup(boolean single) {
        JLabel l;
        JComponent popup = null;
        popup = single ? new JPopupMenu() : new JMenu();
        String ref = this.wrap("href : " + this.href);
        if (ref != null) {
            StringTokenizer st = new StringTokenizer(ref, "\n", false);
            while (st.hasMoreTokens()) {
                l = new JLabel(st.nextToken());
                l.setBackground(this.popupBack);
                l.setForeground(this.popupFore);
                popup.add(l);
            }
        }
        if (single) {
            ((JPopupMenu)popup).addSeparator();
        } else {
            ((JMenu)popup).addSeparator();
        }
        String actionLabel = "permission: " + this.permission;
        l = new JLabel(actionLabel);
        l.setBackground(this.popupBack);
        l.setForeground(this.popupFore);
        popup.add(l);
        if (this.pactions != null) {
            if (single) {
                ((JPopupMenu)popup).addSeparator();
            } else {
                ((JMenu)popup).addSeparator();
            }
            StringTokenizer st = new StringTokenizer(this.pactions, "\n", false);
            List.Enumeration en = this.paction_parameters.getList();
            while (st.hasMoreTokens()) {
                String enfLabel = st.nextToken();
                l = new JLabel(enfLabel);
                l.setBackground(this.popupBack);
                l.setForeground(this.popupFore);
                popup.add(l);
                if (!en.hasMoreElements()) continue;
                List.Element el = en.nextElement();
                NodeList nl = (NodeList)el.listedObject;
                int len = nl.getLength();
                for (int i = 0; i < len; ++i) {
                    popup.add(this.getParaMenuComponent(enfLabel, (Element)nl.item(i)));
                }
            }
        }
        return popup;
    }

    static String getTextFrom(Node n) {
        StringBuffer text = new StringBuffer();
        NodeList textNodes = n.getChildNodes();
        for (int i = 0; i < textNodes.getLength(); ++i) {
            Node textNode = textNodes.item(i);
            if (textNode == null) continue;
            short type = textNode.getNodeType();
            if (type == 3) {
                text.append(textNode.getNodeValue());
            }
            if (type != 4) continue;
            text.append("<![CDATA[");
            text.append(textNode.getNodeValue());
            text.append("]]>");
        }
        return text.toString().trim();
    }

    String getTooltipText() {
        StringBuffer strb = new StringBuffer();
        if (this.href != null) {
            strb.append("href: " + this.href + ", ");
        }
        if (this.permission != null) {
            strb.append("permission: " + this.permission);
        }
        return strb.toString();
    }

    boolean isError() {
        return this.ERROR > 0;
    }

    private void setError(String message) {
        ++this.ERROR;
        this.ERROR_MESSAGE = this.ERROR_MESSAGE == null ? message : this.ERROR_MESSAGE + "; " + message;
    }

    static Node setTextFrom(String text, Document doc) {
        Element collector = doc.createElement("collector");
        int start = 0;
        while (start < text.length()) {
            int cdataEnd;
            int end = text.indexOf("<![CDATA[", start);
            if (end == -1) {
                collector.appendChild(doc.createTextNode(text.substring(start)));
                break;
            }
            if (end > 0) {
                collector.appendChild(doc.createTextNode(text.substring(start, end)));
            }
            if ((cdataEnd = text.indexOf("]]>", end)) == -1) {
                collector.appendChild(doc.createTextNode(text.substring(end + 9)));
                System.err.println("Error: End of CDATA section not found.");
                break;
            }
            collector.appendChild(doc.createCDATASection(text.substring(end + 9, cdataEnd)));
            start = cdataEnd + 3;
        }
        return collector;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        if (this.orgUserObject != null) {
            strb.insert(0, this.orgUserObject.toString() + " ");
        }
        strb.append("[" + this.permission + "]");
        return strb.toString();
    }

    private String wrap(String line) {
        return this.wrapLine(line, Strings.POPUP_LINE_LENGTH);
    }

    private String wrapLine(String line, int length) {
        if (line.length() < length) {
            return line;
        }
        String wrappedLine = "";
        for (int i = 0; i < line.length(); i += length) {
            int j = i + length;
            if (j > line.length()) {
                j = line.length();
            }
            wrappedLine = wrappedLine + line.substring(i, j) + "\n";
        }
        return wrappedLine;
    }

    private class PopupListener
    implements PopupMenuListener {
        private PopupListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (DecisionTreeNode.this.vt != null) {
                DecisionTreeNode.this.vt.getParameterViewer().setVisible(false);
            }
        }
    }

    private class Parameter
    implements MouseListener {
        String name;
        Node parameter;
        MouseEvent last = null;

        Parameter(String n, Node para) {
            this.parameter = para;
            this.name = n;
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            if (DecisionTreeNode.this.vt != null && e != this.last) {
                DecisionTreeNode.this.vt.getParameterViewer().setVisible(true);
                DecisionTreeNode.this.vt.getParameterViewer().clearDOM();
                DecisionTreeNode.this.vt.getParameterViewer().writeDOM(this.name, this.parameter);
                this.last = e;
            }
        }
    }
}

