/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.JXMLTextPane;
import java.awt.Color;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private Color node_name_color = new Color(160, 0, 0);
    private boolean canonical;
    private boolean PURE = false;
    private boolean INDENT_NEXT = true;
    private String publicId = null;
    private String systemId = null;
    private String encoding = null;

    private String normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        continue block7;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
        }
        return str.toString();
    }

    public void print(JXMLTextPane jtp, Node node) {
        this.print(jtp, node, null);
    }

    public void print(JXMLTextPane jtp, Node node, String indent) {
        if (indent == null) {
            indent = "";
        }
        if (node == null) {
            return;
        }
        if (this.PURE) {
            indent = "";
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                DocumentType docType;
                if (jtp != null) {
                    jtp.print("<?xml version=\"1.0\"", Color.blue);
                    if (this.encoding != null) {
                        jtp.print(" encoding=\"" + this.encoding + '\"', Color.blue);
                    }
                    jtp.print("?>", Color.blue);
                }
                if ((docType = ((Document)node).getDoctype()) != null) {
                    if (jtp != null) {
                        if (this.publicId == null) {
                            this.publicId = docType.getName();
                        }
                        jtp.print("\n<!DOCTYPE " + this.publicId, Color.blue);
                        if (this.systemId != null) {
                            jtp.print(" SYSTEM \"" + this.systemId + '\"', Color.blue);
                        }
                        jtp.print(">", Color.blue);
                    }
                } else {
                    Element root = ((Document)node).getDocumentElement();
                    if (this.publicId == null) {
                        this.publicId = root.getNodeName();
                    }
                    if (root != null && jtp != null) {
                        jtp.print("\n<!DOCTYPE " + this.publicId, Color.blue);
                        if (this.systemId != null) {
                            jtp.print(" SYSTEM \"" + this.systemId + '\"', Color.blue);
                        }
                        jtp.print(">", Color.blue);
                    }
                }
                this.print(jtp, ((Document)node).getDocumentElement(), "\n");
                break;
            }
            case 1: {
                NodeList children;
                if (jtp != null) {
                    jtp.print(indent, Color.white);
                    jtp.print("<", Color.blue);
                    jtp.print(node.getNodeName(), this.node_name_color);
                }
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                boolean xmlns_flag = false;
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    if (attr.getNodeName().equals("xmlns")) {
                        xmlns_flag = true;
                    }
                    if (jtp == null) continue;
                    jtp.print(" ", Color.white);
                    jtp.print(attr.getNodeName(), this.node_name_color);
                    jtp.print("=\"", Color.blue);
                    if (attr.getNodeName().equals("permission") || attr.getNodeName().equals("xmlns")) {
                        if (attr.getNodeValue().equals("grant")) {
                            jtp.print(this.normalize(attr.getNodeValue()), Color.green.darker());
                        } else if (attr.getNodeValue().equals("deny")) {
                            jtp.print(this.normalize(attr.getNodeValue()), Color.red);
                        } else {
                            jtp.print(this.normalize(attr.getNodeValue()), Color.red);
                        }
                    } else {
                        jtp.print(this.normalize(attr.getNodeValue()), Color.black);
                    }
                    jtp.print("\"", Color.blue);
                }
                if (!xmlns_flag) {
                    String ns_uri = node.getNamespaceURI();
                    Node parent = node.getParentNode();
                    String parent_ns_uri = parent.getNodeType() == 1 ? parent.getNamespaceURI() : null;
                    if ((parent_ns_uri != null || ns_uri != null) && (parent_ns_uri == null && ns_uri != null || parent_ns_uri != null && ns_uri == null || !parent_ns_uri.equals(ns_uri))) {
                        if (parent.getNodeType() == 9 && ns_uri == null) {
                            ns_uri = null;
                        }
                        if (parent.getNodeType() == 9 && ns_uri.equals("")) {
                            ns_uri = null;
                        }
                        if (ns_uri != null && jtp != null) {
                            jtp.print(" ", Color.white);
                            jtp.print("xmlns", this.node_name_color);
                            jtp.print("=\"", Color.blue);
                            jtp.print(this.normalize(ns_uri), Color.red);
                            jtp.print("\"", Color.blue);
                        }
                    }
                }
                if (!node.hasChildNodes()) {
                    if (jtp == null) break;
                    jtp.print("/>", Color.blue);
                    break;
                }
                if (jtp != null) {
                    jtp.print(">", Color.blue);
                }
                if ((children = node.getChildNodes()) == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(jtp, children.item(i), indent + "  ");
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.print(jtp, children.item(i), indent + "  ");
                    }
                    break;
                }
                if (jtp == null) break;
                jtp.print("&", Color.blue);
                jtp.print(node.getNodeName(), Color.blue);
                jtp.print(";", Color.blue);
                break;
            }
            case 4: {
                String data = node.getNodeValue();
                if (data == null || data.equals("") || jtp == null) break;
                jtp.print(indent, Color.black);
                jtp.print("<![CDATA[" + data + "]]>", Color.black);
                break;
            }
            case 3: {
                String data = node.getNodeValue();
                if (!this.PURE) {
                    data = this.normalize(data.trim());
                }
                if (data == null || data.equals("")) break;
                if (jtp != null) {
                    jtp.print(data, Color.black);
                }
                this.INDENT_NEXT = false;
                break;
            }
            case 7: {
                String data = node.getNodeValue();
                if (jtp == null) break;
                jtp.print(indent, Color.blue);
                jtp.print("<?", Color.blue);
                jtp.print(node.getNodeName(), Color.blue);
                if (data != null && data.length() > 0) {
                    jtp.print(" ", Color.blue);
                    jtp.print(data, Color.black);
                }
                jtp.print("?>", Color.blue);
                break;
            }
            case 8: {
                if (jtp == null) break;
                jtp.print(indent, Color.white);
                jtp.print("<!--\n", Color.blue);
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    jtp.print(data, Color.gray);
                }
                jtp.print("\n-->", Color.blue);
            }
        }
        if (type == 1 && node.hasChildNodes() && jtp != null) {
            if (this.INDENT_NEXT) {
                jtp.print(indent, Color.white);
            } else {
                this.INDENT_NEXT = true;
            }
            jtp.print("</", Color.blue);
            jtp.print(node.getNodeName(), this.node_name_color);
            jtp.print(">", Color.blue);
        }
    }

    public void setCanonical(boolean canonical) {
        Boolean ovalue = this.canonical ? Boolean.TRUE : Boolean.FALSE;
        this.canonical = canonical;
        Boolean nvalue = this.canonical ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public void setPublicId(String pid) {
        this.publicId = pid;
    }

    public void setSystemId(String sid) {
        this.systemId = sid;
    }

    public void setPure(boolean p) {
        this.PURE = p;
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }
}

