/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import com.ibm.xml.policy.tool.DecisionTreeNode;
import com.ibm.xml.policy.tool.MyMutableTreeNode;
import com.ibm.xml.policy.tool.Strings;
import com.ibm.xml.policy.tool.VisualTool;
import com.ibm.xml.policy.util.Util;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMTree
extends JTree {
    private static short[] relevantNodeTypes = new short[]{1, 3};
    private static final char SPACE = ' ';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char LINE_FEED = '\n';
    private static final char TAB = '\t';
    private VisualTool vt = null;
    private Document document = null;
    private MyMutableTreeNode selectedTreeNode = null;
    private TreePath selectedTreePath = null;
    private TreePath[] decisionSelection = null;
    private TreePathPair[] savedExpansion = null;
    private String undoUserObject = null;
    private boolean popupMouseClick = false;
    private boolean editFunction = false;
    private static ToolTipManager ttm;
    private int initialDelay;
    private int dismissDelay;

    public DOMTree(VisualTool vt, boolean edit, TreeCellRenderer tcr) {
        super(new Model());
        this.setRootVisible(false);
        this.vt = vt;
        this.editFunction = edit;
        this.installTreeSelectionListener();
        if (edit) {
            this.installCellEditorListener();
        }
        this.installMouseListener();
        ttm = ToolTipManager.sharedInstance();
        ttm.registerComponent(this);
        this.setEditable(false);
        this.setRowHeight(Strings.TREE_CELL_HEIGHT);
        this.setCellRenderer(tcr);
    }

    public void setDocument(Document document) {
        this.document = document;
        ((Model)this.getModel()).setDocument(document);
        this.expandRow(0);
        this.actExpand(null);
    }

    public Document getDocument() {
        return this.document;
    }

    public void documentReady(Document doc) {
        this.setDocument(doc);
        this.decisionSelection = null;
    }

    public void checkXPath(String href) {
        if (href == null) {
            return;
        }
        this.clearSelection();
        this.xpath(href, null);
    }

    public void actCollapse(TreeNode node) {
        TreePath path;
        if (this.document == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (node == null) {
            node = this.selectedTreeNode;
        }
        if (node == null) {
            node = (TreeNode)model.getChild(model.getRoot(), 0);
        }
        if (this.isCollapsed(path = new TreePath(model.getPathToRoot(node)))) {
            return;
        }
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            TreeNode n = en.nextElement();
            if (n == null) continue;
            this.actCollapse(n);
        }
        this.collapsePath(path);
    }

    public void actExpand(TreeNode node) {
        if (this.document == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (node == null) {
            node = this.selectedTreeNode;
        }
        if (node == null) {
            node = (TreeNode)model.getChild(model.getRoot(), 0);
        }
        this.expandPath(new TreePath(model.getPathToRoot(node)));
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            TreeNode n = en.nextElement();
            if (n == null) continue;
            this.actExpand(n);
        }
    }

    private void attachDecision(MyMutableTreeNode node, DecisionTreeNode decision) {
        Object o;
        decision.orgUserObject = o = node.getUserObject();
        node.setUserObject(decision);
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    private void installCellEditorListener() {
        this.setEditable(true);
        DefaultTreeCellEditor editor = (DefaultTreeCellEditor)this.getCellEditor();
        this.setEditable(false);
        editor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent e) {
            }

            public void editingStopped(ChangeEvent e) {
                if (DOMTree.this.selectedTreeNode == null) {
                    return;
                }
                Node node = DOMTree.this.selectedTreeNode.getNode();
                if (node.getNodeType() == 3) {
                    Element el = (Element)node.getParentNode();
                    Object obj = DOMTree.this.selectedTreeNode.getUserObject();
                    if (obj == null || !(obj instanceof String) || ((String)obj).trim().equals("")) {
                        DOMTree.this.selectedTreeNode.setUserObject(DOMTree.this.undoUserObject);
                        ((DefaultTreeModel)DOMTree.this.getModel()).nodeChanged(DOMTree.this.selectedTreeNode);
                        return;
                    }
                    Text newNode = DOMTree.this.document.createTextNode((String)obj);
                    el.replaceChild(newNode, node);
                }
            }
        });
    }

    private void installMouseListener() {
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                TreePath selPath;
                if (e.isPopupTrigger() && DOMTree.this.selectedTreeNode != null && (selPath = DOMTree.this.getPathForLocation(e.getX(), e.getY())) != null && selPath.equals(DOMTree.this.selectedTreePath)) {
                    DOMTree.this.nodeInfoPopup(e, DOMTree.this.selectedTreeNode);
                }
            }

            public void mouseReleased(MouseEvent e) {
                TreePath selPath;
                if (e.isPopupTrigger() && DOMTree.this.selectedTreeNode != null && (selPath = DOMTree.this.getPathForLocation(e.getX(), e.getY())) != null && selPath.equals(DOMTree.this.selectedTreePath)) {
                    DOMTree.this.nodeInfoPopup(e, DOMTree.this.selectedTreeNode);
                }
            }
        });
    }

    private void installTreeSelectionListener() {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DOMTree.this.selectedTreeNode = (MyMutableTreeNode)DOMTree.this.getLastSelectedPathComponent();
                if (DOMTree.this.selectedTreeNode != null) {
                    DefaultTreeModel model = (DefaultTreeModel)DOMTree.this.getModel();
                    DOMTree.this.selectedTreePath = new TreePath(model.getPathToRoot(DOMTree.this.selectedTreeNode));
                    Object obj = DOMTree.this.selectedTreeNode.getUserObject();
                    if (obj == null || !(obj instanceof String)) {
                        DOMTree.this.setEditable(false);
                    } else {
                        DOMTree.this.undoUserObject = new String((String)obj);
                        DOMTree.this.setEditable(DOMTree.this.isEditable(DOMTree.this.selectedTreeNode) && DOMTree.this.editFunction);
                    }
                }
                DOMTree.this.popupMouseClick = false;
            }
        });
    }

    private boolean isEditable(MyMutableTreeNode treeNode) {
        if (treeNode == null) {
            return false;
        }
        Node node = treeNode.getNode();
        return node.getNodeType() == 3;
    }

    public void makeXPath() {
        MyMutableTreeNode selected = (MyMutableTreeNode)this.getLastSelectedPathComponent();
        if (selected == null) {
            return;
        }
        Node node = selected.getNode();
        String xp = null;
        xp = Util.makeXPath(node);
        if (xp == null) {
            this.vt.warning("Failed to make an XPath expression you selected.\nPlease make sure it is either an element or an attribute.");
            return;
        }
        this.vt.tfHref.setText(xp.toString());
        this.vt.tfHref.requestFocus();
    }

    private void nodeInfoPopup(MouseEvent e, MyMutableTreeNode node) {
        Object o = node.getUserObject();
        if (o instanceof DecisionTreeNode) {
            ((DecisionTreeNode)o).getPopup().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void removeDecisions() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (this.decisionSelection != null) {
            for (int i = 0; i < this.decisionSelection.length; ++i) {
                MyMutableTreeNode node = (MyMutableTreeNode)this.decisionSelection[i].getLastPathComponent();
                DecisionTreeNode dtn = (DecisionTreeNode)node.getUserObject();
                node.setUserObject(dtn.orgUserObject);
                model.nodeChanged(node);
            }
        }
        this.clearSelection();
        this.decisionSelection = null;
    }

    public void showDecisions(Document decision_list) {
        this.removeDecisions();
        Element root = decision_list.getDocumentElement();
        NodeList list = root.getElementsByTagNameNS("http://www.trl.ibm.com/projects/xml/xacl", "decision");
        for (int i = 0; i < list.getLength(); ++i) {
            Element decision = (Element)list.item(i);
            DecisionTreeNode dtn = new DecisionTreeNode(decision, this.vt);
            if (dtn.href == null) continue;
            this.xpath(dtn.href, dtn);
        }
        this.decisionSelection = this.getSelectionPaths();
    }

    public void xpath(String href, DecisionTreeNode decision) {
        if (this.document == null) {
            return;
        }
        NodeList nl = null;
        try {
            nl = XPathAPI.selectNodeList((Node)this.document.getDocumentElement(), (String)href);
        }
        catch (Exception e) {
            this.vt.println("XPath " + href + " was not successfully interpreted.");
            this.vt.println(e.getMessage());
            return;
        }
        if (nl != null) {
            if (nl.getLength() > 1) {
                this.vt.warning("The XPath expression identifies multiple nodes.");
                return;
            }
            if (nl.getLength() == 0) {
                this.vt.warning("The XPath expression " + href + " identifies no node.");
                return;
            }
            Model model = (Model)this.getModel();
            Node n = nl.item(0);
            TreeNode treeNode = model.getTreeNode(n);
            TreePath treePath = new TreePath(model.getPathToRoot(treeNode));
            this.addSelectionPath(treePath);
            if (decision != null) {
                this.attachDecision((MyMutableTreeNode)treeNode, decision.cloneNode());
            }
        }
        this.vt.getConsole().scrollToEnd();
    }

    public static Node getNode(Document d, Node startNode, int[] path, boolean mindType) {
        if (path == null) {
            return d.getDocumentElement();
        }
        if (startNode == null) {
            System.out.println("Document.getNode(): No start node!");
            return null;
        }
        NodeList list = startNode.getChildNodes();
        Node node = startNode;
        for (int i = 0; i < path.length; ++i) {
            if (list.getLength() == 0) {
                System.out.println("Document.getNode(): Can't walk path in document! No more child nodes.");
                return null;
            }
            node = DOMTree.item(list, relevantNodeTypes, mindType, path[i]);
            if (node == null) {
                System.out.println("Document.getNode(): Can't walk path in document! Child node missing.");
                return null;
            }
            list = node.getChildNodes();
        }
        return node;
    }

    public static int index(Node child, short[] type, boolean mindType) {
        if (child == null) {
            return -1;
        }
        Node parent = child.getParentNode();
        if (parent != null) {
            NodeList list = parent.getChildNodes();
            int c = 0;
            for (int i = 0; i < list.getLength(); ++i) {
                if (mindType) {
                    for (int t = 0; t < type.length; ++t) {
                        if (list.item(i).getNodeType() != type[t]) continue;
                        if (type[t] == 3) {
                            if (DOMTree.isIgnorableWhitespace((Text)list.item(i))) break;
                            ++c;
                            break;
                        }
                        ++c;
                        break;
                    }
                }
                if (list.item(i) != child) continue;
                if (mindType) {
                    return c - 1;
                }
                return i;
            }
        }
        return -1;
    }

    public static boolean isIgnorableWhitespace(Text node) {
        if (node == null) {
            return true;
        }
        String data = node.getData();
        return data == null || data.trim().length() == 0;
    }

    public static Node item(NodeList list, short[] type, boolean mindType, int index) {
        if (list == null) {
            return null;
        }
        int length = list.getLength();
        if (length == 0) {
            return null;
        }
        if (index < 0 || index >= length) {
            return null;
        }
        if (!mindType) {
            return list.item(index);
        }
        int c = 0;
        for (int i = 0; i < length; ++i) {
            for (int t = 0; t < type.length; ++t) {
                if (list.item(i).getNodeType() != type[t]) continue;
                if (type[t] == 3) {
                    if (!DOMTree.isIgnorableWhitespace((Text)list.item(i))) {
                        ++c;
                    }
                } else {
                    ++c;
                }
                if (c != index + 1) continue;
                return list.item(i);
            }
        }
        return null;
    }

    static class Model
    extends DefaultTreeModel
    implements Serializable {
        private Document document;
        private Hashtable Node2TreeNode;

        public Model() {
            this((Document)null);
        }

        public TreeNode getTreeNode(Node n) {
            if (this.Node2TreeNode != null) {
                return (TreeNode)this.Node2TreeNode.get(n);
            }
            return null;
        }

        public Model(Document document) {
            super(new MyMutableTreeNode());
            this.setDocument(document);
        }

        public synchronized void setDocument(Document document) {
            this.document = document;
            ((MyMutableTreeNode)this.getRoot()).removeAllChildren();
            this.buildTree();
            this.fireTreeStructureChanged(this, new Object[]{this.getRoot()}, new int[0], new Object[0]);
        }

        public Document getDocument() {
            return this.document;
        }

        private void buildTree() {
            if (this.document == null) {
                return;
            }
            NodeList nodes = this.document.getChildNodes();
            int len = nodes != null ? nodes.getLength() : 0;
            MyMutableTreeNode root = (MyMutableTreeNode)this.getRoot();
            block4: for (int i = 0; i < len; ++i) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case 9: {
                        root = this.insertDocumentNode(node, root);
                        continue block4;
                    }
                    case 1: {
                        this.insertElementNode(node, root);
                        continue block4;
                    }
                }
            }
        }

        private MyMutableTreeNode insertNode(Node n, String what, MyMutableTreeNode where) {
            MyMutableTreeNode node = new MyMutableTreeNode(what);
            node.setNode(n);
            if (this.Node2TreeNode == null) {
                this.Node2TreeNode = new Hashtable();
            }
            this.Node2TreeNode.put(n, node);
            this.insertNodeInto(node, where, where.getChildCount());
            return node;
        }

        private MyMutableTreeNode insertDocumentNode(Node what, MyMutableTreeNode where) {
            return this.insertNode(what, "<" + what.getNodeName() + '>', where);
        }

        private MyMutableTreeNode insertElementNode(Node what, MyMutableTreeNode where) {
            StringBuffer name = new StringBuffer();
            name.append('<');
            name.append(what.getNodeName());
            name.append('>');
            MyMutableTreeNode element = this.insertNode(what, name.toString(), where);
            NamedNodeMap attrs = what.getAttributes();
            int attrCount = attrs != null ? attrs.getLength() : 0;
            for (int i = 0; i < attrCount; ++i) {
                Node attr = attrs.item(i);
                this.insertAttributeNode(attr, element);
            }
            NodeList children = what.getChildNodes();
            int len = children != null ? children.getLength() : 0;
            block5: for (int i = 0; i < len; ++i) {
                Node node = children.item(i);
                switch (node.getNodeType()) {
                    case 3: {
                        this.insertTextNode(node, element);
                        continue block5;
                    }
                    case 1: {
                        this.insertElementNode(node, element);
                        continue block5;
                    }
                }
            }
            return element;
        }

        private MyMutableTreeNode insertTextNode(Node what, MyMutableTreeNode where) {
            String value = what.getNodeValue().trim();
            if (value.length() > 0) {
                return this.insertNode(what, "TEXT_NODE: " + value, where);
            }
            return null;
        }

        private MyMutableTreeNode insertAttributeNode(Node what, MyMutableTreeNode where) {
            String value = "ATTR_NODE: " + what.getNodeName().trim() + "=\"" + what.getNodeValue().trim() + "\"";
            return this.insertNode(what, value, where);
        }
    }

    private class TreePathPair {
        public TreePath treePath = null;
        public int[] intPath = null;

        public TreePathPair(TreePath tp, int[] ip) {
            this.treePath = tp;
            this.intPath = ip;
        }
    }
}

