/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.policy.tool;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.JViewport;

class Console
extends JTextArea {
    ScrollThread consoleThread;
    private boolean CONSOLE_LOCK = false;
    private PrintStream orgOut;
    private PrintStream orgErr;

    Console(PrintStream systemOut, PrintStream systemErr) {
        this.orgOut = systemOut;
        this.orgErr = systemErr;
        this.setMargin(new Insets(5, 5, 5, 5));
        this.setEditable(false);
    }

    void clear() {
        this.setText(null);
    }

    void print(char[] c) {
        this.append(new String(c));
    }

    void print(String message) {
        if (message != null && !this.CONSOLE_LOCK) {
            this.append(message);
        }
    }

    void println(String message) {
        if (message != null && !this.CONSOLE_LOCK) {
            this.append(message + "\n");
        }
    }

    void scrollToEnd() {
        if (this.consoleThread != null) {
            this.consoleThread.stopped = true;
            this.consoleThread.interrupt();
        }
        this.consoleThread = new ScrollThread();
        this.consoleThread.start();
    }

    private class ScrollThread
    extends Thread {
        boolean stopped = false;

        private ScrollThread() {
        }

        public void run() {
            try {
                ScrollThread.sleep(600L);
                if (!this.stopped) {
                    Dimension text = Console.this.getSize(null);
                    Container parent = Console.this.getParent();
                    if (parent instanceof JViewport) {
                        Rectangle viewport = ((JViewport)parent).getViewRect();
                        Rectangle newViewport = new Rectangle(viewport.x, text.height - viewport.height, viewport.width, viewport.height);
                        Console.this.scrollRectToVisible(newViewport);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

