/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XNISerializationEngine
implements XMLDocumentHandler {
    private XMLDocumentSource fDocumentSource;

    public abstract String getType();

    public abstract void setOutputStream(OutputStream var1);

    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    static class ErrorHandlerImpl
    implements ErrorHandler {
        ErrorHandlerImpl() {
        }

        private void printStackTrace(SAXException exception) {
            Exception e = exception.getException();
            if (e == null) {
                e = exception;
            }
            e.printStackTrace();
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.printStackTrace(exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            this.printStackTrace(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    }

    static class XMLElement
    extends XMLContent {
        private boolean fFirstElement = true;
        private boolean fInScope;
        private int fDepthOfNestOfElements;

        XMLElement() {
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void setOutputStream(OutputStream out) {
            super.setOutputStream(out);
            this.fFirstElement = true;
            this.fInScope = false;
            this.fDepthOfNestOfElements = 0;
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.startDocument(locator, encoding, namespaceContext, augs);
            }
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.xmlDecl(version, encoding, standalone, augs);
            }
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.doctypeDecl(rootElement, publicId, systemId, augs);
            }
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.comment(text, augs);
            }
        }

        public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.processingInstruction(target, data, augs);
            }
        }

        public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.startPrefixMapping(prefix, uri, augs);
            }
        }

        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                ++this.fDepthOfNestOfElements;
                super.startElement(element, attributes, augs);
            } else if (this.fFirstElement) {
                this.fFirstElement = false;
                this.fInScope = true;
                this.startElement(element, attributes, augs);
            }
        }

        public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            this.startElement(element, attributes, augs);
            this.endElement(element, augs);
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.startGeneralEntity(name, identifier, encoding, augs);
            }
        }

        public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.textDecl(version, encoding, augs);
            }
        }

        public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.endGeneralEntity(name, augs);
            }
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.characters(text, augs);
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.ignorableWhitespace(text, augs);
            }
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.endElement(element, augs);
                --this.fDepthOfNestOfElements;
                if (this.fDepthOfNestOfElements < 1) {
                    this.fInScope = false;
                }
            }
        }

        public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.endPrefixMapping(prefix, augs);
            }
        }

        public void startCDATA(Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.startCDATA(augs);
            }
        }

        public void endCDATA(Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.endCDATA(augs);
            }
        }

        public void endDocument(Augmentations augs) throws XNIException {
            if (this.fInScope) {
                super.endDocument(augs);
            }
        }
    }

    static class XMLContent
    extends XNISerializationEngine {
        private SAXParser fSAXParser;

        XMLContent() {
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        public void setOutputStream(OutputStream out) {
            this.fSAXParser = null;
            if (out != null) {
                OutputFormat of = new OutputFormat();
                of.setEncoding("UTF-8");
                of.setOmitDocumentType(true);
                of.setOmitXMLDeclaration(true);
                of.setPreserveSpace(true);
                ContentHandler ch = null;
                try {
                    ch = new XMLSerializer(out, of).asContentHandler();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.fSAXParser = new SAXParser();
                this.fSAXParser.setContentHandler(ch);
                this.fSAXParser.setErrorHandler((ErrorHandler)new ErrorHandlerImpl());
                try {
                    this.fSAXParser.setFeature("http://xml.org/sax/features/namespaces", true);
                    this.fSAXParser.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                }
                catch (SAXException e) {
                    Exception e2 = e.getException();
                    if (e2 == null) {
                        e2 = e;
                    }
                    e2.printStackTrace();
                }
                this.fSAXParser.reset();
            }
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.startDocument(locator, encoding, namespaceContext, augs);
            }
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.xmlDecl(version, encoding, standalone, augs);
            }
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.doctypeDecl(rootElement, publicId, systemId, augs);
            }
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.comment(text, augs);
            }
        }

        public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.processingInstruction(target, data, augs);
            }
        }

        public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.startPrefixMapping(prefix, uri, augs);
            }
        }

        public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.startElement(element, attributes, augs);
            }
        }

        public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.emptyElement(element, attributes, augs);
            }
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.startGeneralEntity(name, identifier, encoding, augs);
            }
        }

        public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.textDecl(version, encoding, augs);
            }
        }

        public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.endGeneralEntity(name, augs);
            }
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.characters(text, augs);
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.ignorableWhitespace(text, augs);
            }
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.endElement(element, augs);
            }
        }

        public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.endPrefixMapping(prefix, augs);
            }
        }

        public void startCDATA(Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.startCDATA(augs);
            }
        }

        public void endCDATA(Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.endCDATA(augs);
            }
        }

        public void endDocument(Augmentations augs) throws XNIException {
            if (this.fSAXParser != null) {
                this.fSAXParser.endDocument(augs);
            }
        }
    }
}

