/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.KeyInfoResolverBase;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.type.CarriedKeyName;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.KeyName;
import com.ibm.xml.enc.xni.XNI2DOM;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XNIKeyInfoResolver
extends KeyInfoResolverBase
implements XMLComponent,
XMLDocumentHandler {
    private static final String[] RECOGNIZED_FEATURES = new String[0];
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[0];
    private static final String[] RECOGNIZED_PROPERTIES = new String[0];
    private static final Object[] PROPERTY_DEFAULTS = new Object[0];
    private XMLDocumentSource fDocumentSource;
    private Map fEncryptedKeyLists = new HashMap();
    private Document fDocument;
    private boolean fInScope;
    private XNI2DOM fXNI2DOM = new XNI2DOM();
    private int fDepthOfNest;

    private boolean isEncryptedKey(QName elem, XMLAttributes attrs) {
        return elem.uri != null && elem.uri.equals("http://www.w3.org/2001/04/xmlenc#") && elem.localpart != null && elem.localpart.equals("EncryptedKey");
    }

    private void addEncryptedKeys(EncryptedKey encKey) {
        KeyInfo ki;
        String s;
        CarriedKeyName kn = encKey.getCarriedKeyName();
        if (kn != null && (s = kn.getName()) != null) {
            if (!this.fEncryptedKeyLists.containsKey(s)) {
                this.fEncryptedKeyLists.put(s, new ArrayList());
            }
            ((List)this.fEncryptedKeyLists.get(s)).add(encKey);
        }
        if ((ki = encKey.getKeyInfo()) != null) {
            Iterator i = ki.getKeyIds().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)o);
            }
        }
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        String s;
        if (!this.fInEncryptMode && (s = keyName.getName()) != null && this.fEncryptedKeyLists.containsKey(s)) {
            Iterator i = ((List)this.fEncryptedKeyLists.get(s)).iterator();
            while (key == null && i.hasNext()) {
                key = super.resolveEncryptedKey((EncryptedKey)i.next(), encMeth, key);
            }
        }
        return key;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fEncryptedKeyLists.clear();
        this.fDocument = new DocumentImpl();
        this.fInScope = false;
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String featureId) {
        Boolean state = null;
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            state = FEATURE_DEFAULTS[i];
        }
        return state;
    }

    public Object getPropertyDefault(String propertyId) {
        Object value = null;
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            value = PROPERTY_DEFAULTS[i];
        }
        return value;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startDocument(locator, encoding, namespaceContext, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.processingInstruction(target, data, augs);
        }
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startPrefixMapping(prefix, uri, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startElement(element, attributes, augs);
            ++this.fDepthOfNest;
        } else if (this.isEncryptedKey(element, attributes)) {
            this.fInScope = true;
            this.fXNI2DOM.reset(this.fDocument);
            this.fDepthOfNest = 0;
            this.startElement(element, attributes, augs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startGeneralEntity(name, identifier, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endGeneralEntity(name, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.characters(text, augs);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.ignorableWhitespace(text, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endElement(element, augs);
            --this.fDepthOfNest;
            if (this.fDepthOfNest < 1) {
                this.addEncryptedKeys(new EncryptedKey((Element)this.fXNI2DOM.getNodeList().item(0)));
                this.fInScope = false;
            }
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endPrefixMapping(prefix, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endDocument(augs);
        }
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }
}

