/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.IdResolverBase;
import com.ibm.xml.enc.xni.XNI2DOM;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XNIIdResolver
extends IdResolverBase
implements XMLComponent,
XMLDocumentHandler {
    private static final String[] RECOGNIZED_FEATURES = new String[0];
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[0];
    private static final String[] RECOGNIZED_PROPERTIES = new String[0];
    private static final Object[] PROPERTY_DEFAULTS = new Object[0];
    private XMLDocumentSource fDocumentSource;
    private Map fElements = new HashMap();
    private Document fDocument;
    private boolean fInScope;
    private XNI2DOM fXNI2DOM = new XNI2DOM();
    private int fDepthOfNest;

    protected String getId(QName elem, XMLAttributes attrs) {
        String id = null;
        int l = attrs.getLength();
        for (int i = 0; id == null && i < l; ++i) {
            String s = attrs.getType(i);
            if (s == null || !s.equals("ID")) continue;
            id = attrs.getValue(i);
        }
        return id;
    }

    public Element resolveID(Document doc, String id) {
        Element elem = null;
        if (id != null) {
            if (doc == null) {
                throw new NullPointerException("Document not specified");
            }
            Element e = doc.getDocumentElement();
            if (e != null) {
                elem = super.resolveID(doc, id);
            } else if (this.fElements.containsKey(id)) {
                elem = (Element)doc.importNode((Element)this.fElements.get(id), true);
            }
        }
        return elem;
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        this.fElements.clear();
        this.fDocument = new DocumentImpl();
        this.fInScope = false;
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String featureId) {
        Boolean state = null;
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(featureId)) continue;
            state = FEATURE_DEFAULTS[i];
        }
        return state;
    }

    public Object getPropertyDefault(String propertyId) {
        Object value = null;
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(propertyId)) continue;
            value = PROPERTY_DEFAULTS[i];
        }
        return value;
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startDocument(locator, encoding, namespaceContext, augs);
        }
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.xmlDecl(version, encoding, standalone, augs);
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.doctypeDecl(rootElement, publicId, systemId, augs);
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.comment(text, augs);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.processingInstruction(target, data, augs);
        }
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startPrefixMapping(prefix, uri, augs);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startElement(element, attributes, augs);
            ++this.fDepthOfNest;
            String s = this.getId(element, attributes);
            if (s != null) {
                this.fElements.put(s, (Element)this.fXNI2DOM.getCurrentNode());
            }
        } else {
            String s = this.getId(element, attributes);
            if (s != null) {
                this.fInScope = true;
                this.fXNI2DOM.reset(this.fDocument);
                this.fDepthOfNest = 0;
                this.startElement(element, attributes, augs);
            }
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startGeneralEntity(name, identifier, encoding, augs);
        }
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.textDecl(version, encoding, augs);
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endGeneralEntity(name, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.characters(text, augs);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.ignorableWhitespace(text, augs);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endElement(element, augs);
            --this.fDepthOfNest;
            if (this.fDepthOfNest < 1) {
                this.fInScope = false;
            }
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endPrefixMapping(prefix, augs);
        }
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.startCDATA(augs);
        }
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endCDATA(augs);
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.fInScope) {
            this.fXNI2DOM.endDocument(augs);
        }
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }
}

