/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.xni.AugmentationsExtn;
import com.ibm.xml.enc.xni.XMLAttributesExtn;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLDocumentSource;

class XNIEventBuffer
implements XMLDocumentHandler {
    private XMLDocumentSource fDocumentSource;
    private List fXNIEvents = new ArrayList();

    XNIEventBuffer() {
    }

    void flush(XMLDocumentHandler handler) throws XNIException {
        if (handler != null) {
            Iterator i = this.fXNIEvents.iterator();
            while (i.hasNext()) {
                XNIEvent xe = (XNIEvent)i.next();
                Object[] p = xe.fParameters;
                switch (xe.fType) {
                    case 1: {
                        handler.startDocument((XMLLocator)p[0], (String)p[1], (NamespaceContext)p[3], (Augmentations)p[2]);
                        break;
                    }
                    case 2: {
                        handler.xmlDecl((String)p[0], (String)p[1], (String)p[2], (Augmentations)p[3]);
                        break;
                    }
                    case 3: {
                        handler.doctypeDecl((String)p[0], (String)p[1], (String)p[2], (Augmentations)p[3]);
                        break;
                    }
                    case 4: {
                        handler.comment((XMLString)p[0], (Augmentations)p[1]);
                        break;
                    }
                    case 5: {
                        handler.processingInstruction((String)p[0], (XMLString)p[1], (Augmentations)p[2]);
                        break;
                    }
                    case 6: {
                        handler.startPrefixMapping((String)p[0], (String)p[1], (Augmentations)p[2]);
                        break;
                    }
                    case 7: {
                        handler.startElement((QName)p[0], (XMLAttributes)p[1], (Augmentations)p[2]);
                        break;
                    }
                    case 8: {
                        handler.emptyElement((QName)p[0], (XMLAttributes)p[1], (Augmentations)p[2]);
                        break;
                    }
                    case 9: {
                        handler.startGeneralEntity((String)p[0], (XMLResourceIdentifier)p[1], (String)p[2], (Augmentations)p[3]);
                        break;
                    }
                    case 10: {
                        handler.textDecl((String)p[0], (String)p[1], (Augmentations)p[2]);
                        break;
                    }
                    case 11: {
                        handler.endGeneralEntity((String)p[0], (Augmentations)p[1]);
                        break;
                    }
                    case 12: {
                        handler.characters((XMLString)p[0], (Augmentations)p[1]);
                        break;
                    }
                    case 13: {
                        handler.ignorableWhitespace((XMLString)p[0], (Augmentations)p[1]);
                        break;
                    }
                    case 14: {
                        handler.endElement((QName)p[0], (Augmentations)p[1]);
                        break;
                    }
                    case 15: {
                        handler.endPrefixMapping((String)p[0], (Augmentations)p[1]);
                        break;
                    }
                    case 16: {
                        handler.startCDATA((Augmentations)p[0]);
                        break;
                    }
                    case 17: {
                        handler.endCDATA((Augmentations)p[0]);
                        break;
                    }
                    case 18: {
                        handler.endDocument((Augmentations)p[0]);
                    }
                }
            }
        }
    }

    void clear() {
        this.fXNIEvents.clear();
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(1, new Object[]{locator, encoding, namespaceContext, AugmentationsExtn.getCopy(augs)}));
    }

    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(2, new Object[]{version, encoding, standalone, AugmentationsExtn.getCopy(augs)}));
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(3, new Object[]{rootElement, publicId, systemId, AugmentationsExtn.getCopy(augs)}));
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(4, new Object[]{new XMLStringExtn(text), AugmentationsExtn.getCopy(augs)}));
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(5, new Object[]{target, new XMLStringExtn(data), AugmentationsExtn.getCopy(augs)}));
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(6, new Object[]{prefix, uri, AugmentationsExtn.getCopy(augs)}));
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(7, new Object[]{new QName(element), new XMLAttributesExtn(attributes), AugmentationsExtn.getCopy(augs)}));
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(8, new Object[]{new QName(element), new XMLAttributesExtn(attributes), AugmentationsExtn.getCopy(augs)}));
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(9, new Object[]{name, identifier, encoding, AugmentationsExtn.getCopy(augs)}));
    }

    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(10, new Object[]{version, encoding, AugmentationsExtn.getCopy(augs)}));
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(11, new Object[]{name, AugmentationsExtn.getCopy(augs)}));
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(12, new Object[]{new XMLStringExtn(text), AugmentationsExtn.getCopy(augs)}));
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(13, new Object[]{new XMLStringExtn(text), AugmentationsExtn.getCopy(augs)}));
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(14, new Object[]{new QName(element), AugmentationsExtn.getCopy(augs)}));
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(15, new Object[]{prefix, AugmentationsExtn.getCopy(augs)}));
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(16, new Object[]{AugmentationsExtn.getCopy(augs)}));
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(17, new Object[]{AugmentationsExtn.getCopy(augs)}));
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.fXNIEvents.add(new XNIEvent(18, new Object[]{AugmentationsExtn.getCopy(augs)}));
    }

    public void setDocumentSource(XMLDocumentSource source) {
        this.fDocumentSource = source;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    class XMLStringExtn
    extends XMLString {
        XMLStringExtn() {
        }

        XMLStringExtn(XMLString string) {
            this.setValues(string);
        }

        public void setValues(XMLString string) {
            char[] cc = new char[string.length];
            System.arraycopy(string.ch, string.offset, cc, 0, cc.length);
            super.setValues(cc, 0, cc.length);
        }
    }

    class XNIEvent {
        static final int START_DOCUMENT = 1;
        static final int XML_DECL = 2;
        static final int DOCTYPE_DECL = 3;
        static final int COMMENT = 4;
        static final int PROCESSING_INSTRUCTION = 5;
        static final int START_PREFIX_MAPPING = 6;
        static final int START_ELEMENT = 7;
        static final int EMPTY_ELEMENT = 8;
        static final int START_ENTITY = 9;
        static final int TEXT_DECL = 10;
        static final int END_ENTITY = 11;
        static final int CHARACTERS = 12;
        static final int IGNORABLE_WHITESPACE = 13;
        static final int END_ELEMENT = 14;
        static final int END_PREFIX_MAPPING = 15;
        static final int START_CDATA = 16;
        static final int END_CDATA = 17;
        static final int END_DOCUMENT = 18;
        int fType;
        Object[] fParameters;

        XNIEvent(int type) {
            this(type, null);
        }

        XNIEvent(int type, Object[] params) {
            this.fType = type;
            this.fParameters = params;
        }
    }
}

