/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.util.DOMUtil;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XNI2DOM
extends AbstractDOMParser {
    private Node fRootNode;

    XNI2DOM() {
        super((XMLParserConfiguration)new StandardParserConfiguration());
        this.fConfiguration.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
    }

    void reset(Document factory) throws XNIException {
        super.reset();
        this.fDocument = factory;
        if (this.fDocument instanceof DocumentImpl) {
            this.fDocumentImpl = (DocumentImpl)this.fDocument;
            this.fDocumentImpl.setErrorChecking(false);
        }
        this.fCurrentNode = this.fRootNode = this.fDocument.createDocumentFragment();
        this.fInDocument = true;
    }

    NodeList getNodeList() {
        NodeList nodes = null;
        switch (this.fRootNode.getNodeType()) {
            case 11: {
                nodes = this.fRootNode.getChildNodes();
                break;
            }
            case 9: {
                nodes = new DOMUtil.NodeListImpl(this.fRootNode);
            }
        }
        return nodes;
    }

    Node getCurrentNode() {
        return this.fCurrentNode;
    }

    public void reset() throws XNIException {
        this.reset((Document)new DocumentImpl());
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.setActualEncoding(encoding);
        }
        this.fCurrentNode = this.fRootNode = this.fDocument;
    }

    public void endDocument(Augmentations augs) throws XNIException {
        if (this.fDocumentImpl != null) {
            this.fDocumentImpl.setErrorChecking(true);
        }
        this.fCurrentNode = null;
        this.fInDocument = false;
    }
}

