/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.xni.XMLAttributesExtn;
import com.ibm.xml.enc.xni.XMLDocumentHandlerImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;

class PathEvaluator
extends XMLDocumentHandlerImpl {
    private String fPath;
    private boolean fMatched;
    private List fPairs;
    private int fIndex;
    private int fPreviousIndex;
    private int fMarkedIndex;
    private List fBuffer;
    private List fPreviousBuffer;
    private List fMarkedBuffer;

    PathEvaluator(String path) {
        this.fPath = path;
        this.fPairs = this.parse(path);
        this.fBuffer = new ArrayList();
        this.fPreviousBuffer = new ArrayList();
        this.fMarkedBuffer = new ArrayList();
    }

    String getPath() {
        return this.fPath;
    }

    boolean matched() {
        return this.fMatched;
    }

    void mark() {
        this.fMarkedIndex = this.fPreviousIndex;
        this.fMarkedBuffer.clear();
        this.fMarkedBuffer.addAll(this.fPreviousBuffer);
    }

    void unmark() {
        this.fIndex = this.fMarkedIndex;
        this.fBuffer.clear();
        this.fBuffer.addAll(this.fMarkedBuffer);
    }

    void reset() {
        this.fMatched = false;
        this.fIndex = 0;
        this.fBuffer.clear();
    }

    private List parse(String path) {
        ArrayList pairs = new ArrayList();
        this.path(path.toCharArray(), 0, pairs);
        return pairs;
    }

    private int path(char[] path, int index, List buf) {
        while (index < path.length && path[index] == '/') {
            index = this.element(path, index + 1, buf);
        }
        return index;
    }

    private int element(char[] path, int index, List buf) {
        ArrayList l = new ArrayList();
        if ((index = this.name(path, index, l)) < path.length && path[index] == '[') {
            if (path[index = this.attributes(path, index + 1, l)] == ']') {
                ++index;
            } else {
                throw new RuntimeException(Integer.toString(index));
            }
        }
        Iterator i = l.iterator();
        String s = (String)i.next();
        QName qn = new QName();
        XMLAttributesImpl xa = new XMLAttributesImpl();
        while (i.hasNext()) {
            qn.setValues(null, null, (String)i.next(), null);
            xa.addAttribute(qn, null, (String)i.next());
        }
        qn.setValues(null, null, s, null);
        buf.add(new Pair(qn, (XMLAttributes)xa));
        return index;
    }

    private int attributes(char[] path, int index, List buf) {
        index = this.attribute(path, index, buf);
        index = this.skip(path, index);
        while (index + 2 < path.length && path[index] == 'a' && path[index + 1] == 'n' && path[index + 2] == 'd') {
            index = this.skip(path, index + 3);
            index = this.attribute(path, index, buf);
            index = this.skip(path, index);
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int attribute(char[] path, int index, List buf) {
        if (path[index] != '@') throw new RuntimeException(Integer.toString(index));
        if (path[index = this.name(path, index + 1, buf)] != '=') throw new RuntimeException(Integer.toString(index));
        char c = path[index + 1];
        if (c != '\'' && c != '\"') {
            throw new RuntimeException(Integer.toString(index));
        }
        index = this.value(path, index + 2, c, buf);
        c = path[index];
        return ++index;
    }

    private int name(char[] path, int index, List buf) {
        char c;
        int i = index;
        while (index < path.length && (c = path[index]) != '/' && c != '[' && c != ']' && c != ',' && c != '=' && c != '\'' && c != '\"' && c != ' ') {
            ++index;
        }
        buf.add(new String(path, i, index - i));
        return index;
    }

    private int value(char[] path, int index, char delim, List buf) {
        int i = index;
        while (index < path.length && path[index] != delim) {
            ++index;
        }
        buf.add(new String(path, i, index - i));
        return index;
    }

    private int skip(char[] path, int index) {
        while (index < path.length && path[index] == ' ') {
            ++index;
        }
        return index;
    }

    private void push(QName element, XMLAttributes attributes) {
        this.fMatched = false;
        this.fPreviousIndex = this.fIndex;
        this.fPreviousBuffer.clear();
        this.fPreviousBuffer.addAll(this.fBuffer);
        this.fBuffer.add(new Pair(new QName(element), (XMLAttributes)new XMLAttributesExtn(attributes)));
        if (this.fBuffer.size() == this.fIndex + 1 && this.fIndex < this.fPairs.size()) {
            Pair p = (Pair)this.fPairs.get(this.fIndex);
            if (this.equals(element, p.fElement) && this.contains(attributes, p.fAttributes)) {
                ++this.fIndex;
            }
            if (this.fIndex == this.fPairs.size()) {
                this.fMatched = true;
            }
        }
    }

    private boolean equals(QName elem0, QName elem1) {
        return elem0.rawname != null && elem0.rawname.equals(elem1.rawname);
    }

    private boolean contains(XMLAttributes attrs0, XMLAttributes attrs1) {
        boolean contains = true;
        int l = attrs1.getLength();
        for (int i = 0; contains && i < l; ++i) {
            String n = attrs1.getQName(i);
            String v = attrs0.getValue(n);
            contains = v != null && v.equals(attrs1.getValue(n));
        }
        return contains;
    }

    private void pop() {
        this.fMatched = false;
        this.fPreviousIndex = this.fIndex;
        this.fPreviousBuffer.clear();
        this.fPreviousBuffer.addAll(this.fBuffer);
        this.fBuffer.remove(this.fBuffer.size() - 1);
        if (this.fBuffer.size() < this.fIndex) {
            --this.fIndex;
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.push(element, attributes);
        super.startElement(element, attributes, augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        this.pop();
    }

    class Pair {
        QName fElement;
        XMLAttributes fAttributes;

        Pair(QName element, XMLAttributes attributes) {
            this.fElement = element;
            this.fAttributes = attributes;
        }
    }
}

