/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.EncryptionContext;
import com.ibm.xml.enc.EncryptionOutputStream;
import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.xni.AugmentationsExtn;
import com.ibm.xml.enc.xni.DOM2XNI;
import com.ibm.xml.enc.xni.EncryptedTypeContainer;
import com.ibm.xml.enc.xni.PathEvaluator;
import com.ibm.xml.enc.xni.XMLDocumentFilterImpl;
import com.ibm.xml.enc.xni.XNIAlgorithmFactoryExtn;
import com.ibm.xml.enc.xni.XNIEventBuffer;
import com.ibm.xml.enc.xni.XNISerializationEngine;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.crypto.NoSuchPaddingException;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.XMLNamespaceBinder;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.w3c.dom.Element;

public class Encryptor
extends XMLDocumentFilterImpl
implements XMLComponent {
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private Map fPathEvaluators = new HashMap();
    private Map fEncryptedDataContainers = new HashMap();
    private Map fParameters = new HashMap();
    private Map fKeys = new HashMap();
    private Map fOuts = new HashMap();
    private Set fReplacedData = new HashSet();
    private XNIAlgorithmFactoryExtn fAlgorithmFactory;
    private KeyInfoResolver fKeyInfoResolver;
    private Map fEncryptionContexts = new HashMap();
    private XMLNamespaceBinder fNamespaceBinder = new XMLNamespaceBinder();
    private boolean fInScope;
    private String fPath;
    private boolean fContentOnly;
    private QName fElement = new QName();
    private int fDepthOfNestOfElements;
    private List fPrefixMappings = new ArrayList();
    private int fDepthOfNestOfPrefixMappings;
    private boolean fInNestOfPrefixMappings;
    private Stack fDocumentHandlers = new Stack();
    private Stack fStates = new Stack();
    private SymbolTable fSymbolTable;
    private XMLErrorReporter fErrorReporter;

    public void addData(String path) {
        if (path != null) {
            this.fPathEvaluators.put(path, new PathEvaluator(path));
        }
    }

    public void addEncryptedData(String path, Element encData) {
        this.addEncryptedData(path, encData, null, null, null);
    }

    public void addEncryptedData(String path, Element encData, String type, Element encMeth, Element keyInfo) {
        this.fEncryptedDataContainers.put(path, new EncryptedTypeContainer(encData, type, encMeth, keyInfo));
    }

    public void addParameters(String path, AlgorithmParameterSpec params) {
        this.fParameters.put(path, params);
    }

    public void addKey(String path, Key key) {
        this.fKeys.put(path, key);
    }

    public void addOutputStream(String path, OutputStream out) {
        this.fOuts.put(path, out);
    }

    public void addReplacedData(String path) {
        this.fReplacedData.add(path);
    }

    public void setAlgorithmFactory(XNIAlgorithmFactoryExtn factory) {
        this.fAlgorithmFactory = factory;
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver) {
        this.fKeyInfoResolver = resolver;
    }

    public InputStream getEncryptedData(String path) {
        EncryptionContext ec = (EncryptionContext)this.fEncryptionContexts.get(path);
        InputStream encData = null;
        if (ec != null) {
            encData = ec.getEncryptedType();
        }
        return encData;
    }

    public Element getEncryptedDataAsElement(String path) {
        EncryptionContext ec = (EncryptionContext)this.fEncryptionContexts.get(path);
        Element encData = null;
        if (ec != null) {
            encData = ec.getEncryptedTypeAsElement();
        }
        return encData;
    }

    private void setContentOnly() throws XNIException {
        this.fContentOnly = false;
        EncryptedTypeContainer etc = (EncryptedTypeContainer)this.fEncryptedDataContainers.get(this.fPath);
        if (etc == null) {
            throw new NullPointerException("EncryptedData or EncryptedKey element not specified");
        }
        String s = etc.getType();
        if (s == null) {
            throw new XNIException((Exception)new StructureException("Type attribute not specified"));
        }
        if (!s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            if (s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                this.fContentOnly = true;
            } else {
                throw new XNIException((Exception)new StructureException("Unknown type: " + s));
            }
        }
    }

    private void startPrefixMappings() {
        Iterator i = this.fPrefixMappings.iterator();
        while (i.hasNext()) {
            Object[] oo = (Object[])i.next();
            super.startPrefixMapping((String)oo[0], (String)oo[1], (Augmentations)oo[2]);
        }
        this.fPrefixMappings.clear();
    }

    private void encryptAndReplace() throws XNIException {
        XMLDocumentHandler dh;
        ((EncryptorBody)this.fDocumentHandler).encryptAndReplace();
        this.fDocumentHandler = dh = (XMLDocumentHandler)this.fDocumentHandlers.pop();
        if (dh instanceof EncryptorBody) {
            State s = (State)this.fStates.pop();
            this.fPath = s.fPath;
            this.fContentOnly = s.fContentOnly;
            this.fElement.setValues(s.fElement);
            this.fDepthOfNestOfElements = s.fDepthOfNestOfElements;
            this.fDepthOfNestOfPrefixMappings = s.fDepthOfNestOfPrefixMappings;
        } else {
            this.fInScope = false;
            this.fPath = null;
            this.fContentOnly = false;
            this.fElement.clear();
            this.fDepthOfNestOfPrefixMappings = 0;
        }
    }

    public void reset(XMLComponentManager componentManager) throws XMLConfigurationException {
        ((XMLDocumentFilterImpl)this).fDocumentHandlers.clear();
        if (this.fKeyInfoResolver instanceof XMLDocumentHandler) {
            ((XMLDocumentFilterImpl)this).fDocumentHandlers.add(this.fKeyInfoResolver);
        }
        Iterator i = this.fPathEvaluators.values().iterator();
        while (i.hasNext()) {
            ((PathEvaluator)i.next()).reset();
        }
        if (this.fKeyInfoResolver instanceof XMLComponent) {
            ((XMLComponent)this.fKeyInfoResolver).reset(componentManager);
        }
        this.fNamespaceBinder.reset(componentManager);
        this.fInScope = false;
        this.fPath = null;
        this.fContentOnly = false;
        this.fElement.clear();
        this.fDepthOfNestOfElements = 0;
        this.fPrefixMappings.clear();
        this.fDepthOfNestOfPrefixMappings = 0;
        this.fInNestOfPrefixMappings = false;
        this.fDocumentHandlers.clear();
        this.fStates.clear();
        this.fSymbolTable = (SymbolTable)componentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)componentManager.getProperty(ERROR_REPORTER);
    }

    public String[] getRecognizedFeatures() {
        return this.fNamespaceBinder.getRecognizedFeatures();
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.fNamespaceBinder.setFeature(featureId, state);
    }

    public String[] getRecognizedProperties() {
        return this.fNamespaceBinder.getRecognizedProperties();
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.fNamespaceBinder.setProperty(propertyId, value);
        if (propertyId.startsWith("http://apache.org/xml/properties/")) {
            String s = propertyId.substring("http://apache.org/xml/properties/".length());
            if (s.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)value;
            } else if (s.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)value;
            }
        }
    }

    public Boolean getFeatureDefault(String featureId) {
        return this.fNamespaceBinder.getFeatureDefault(featureId);
    }

    public Object getPropertyDefault(String propertyId) {
        return this.fNamespaceBinder.getPropertyDefault(propertyId);
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, this.fNamespaceBinder.getNamespaceContext(), augs);
    }

    public void startPrefixMapping(String prefix, String uri, Augmentations augs) throws XNIException {
        this.fPrefixMappings.add(new Object[]{prefix, uri, AugmentationsExtn.getCopy(augs)});
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.fNamespaceBinder.startElement(element, attributes, augs);
        Iterator i = this.fPathEvaluators.values().iterator();
        while (i.hasNext()) {
            ((PathEvaluator)i.next()).startElement(element, attributes, augs);
        }
        PathEvaluator pe = null;
        Iterator i2 = this.fPathEvaluators.values().iterator();
        while (i2.hasNext()) {
            PathEvaluator pe2 = (PathEvaluator)i2.next();
            if (!pe2.matched()) continue;
            pe = pe2;
            break;
        }
        if (pe != null) {
            if (this.fInScope) {
                this.fStates.push(new State(this.fPath, this.fContentOnly, this.fElement, this.fDepthOfNestOfElements, this.fDepthOfNestOfPrefixMappings));
                this.fDepthOfNestOfElements = 0;
            } else {
                this.fInScope = true;
            }
            this.fPath = pe.getPath();
            this.setContentOnly();
            this.fElement.setValues(element);
            ++this.fDepthOfNestOfElements;
            this.fDepthOfNestOfPrefixMappings = this.fPrefixMappings.size();
            if (this.fContentOnly) {
                this.startPrefixMappings();
                super.startElement(element, attributes, augs);
            }
            this.fDocumentHandlers.push(this.fDocumentHandler);
            this.fDocumentHandler = new EncryptorBody();
            if (!this.fContentOnly) {
                this.startPrefixMappings();
                super.startElement(element, attributes, augs);
            }
        } else {
            if (this.fInScope && element.equals((Object)this.fElement)) {
                ++this.fDepthOfNestOfElements;
            }
            this.startPrefixMappings();
            super.startElement(element, attributes, augs);
        }
    }

    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.fNamespaceBinder.endElement(element, augs);
        Iterator i = this.fPathEvaluators.values().iterator();
        while (i.hasNext()) {
            ((PathEvaluator)i.next()).endElement(element, augs);
        }
        if (this.fInScope) {
            if (element.equals((Object)this.fElement)) {
                --this.fDepthOfNestOfElements;
                if (this.fDepthOfNestOfElements < 1) {
                    if (!this.fContentOnly && this.fDepthOfNestOfPrefixMappings > 0) {
                        super.endElement(element, augs);
                        this.fInNestOfPrefixMappings = true;
                    } else {
                        if (!this.fContentOnly) {
                            super.endElement(element, augs);
                        }
                        this.encryptAndReplace();
                        if (this.fContentOnly) {
                            super.endElement(element, augs);
                        }
                    }
                }
            } else {
                super.endElement(element, augs);
            }
        } else {
            super.endElement(element, augs);
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
        super.endPrefixMapping(prefix, augs);
        if (this.fInScope && this.fInNestOfPrefixMappings) {
            --this.fDepthOfNestOfPrefixMappings;
            if (this.fDepthOfNestOfPrefixMappings < 1) {
                this.encryptAndReplace();
                this.fInNestOfPrefixMappings = false;
            }
        }
    }

    class State {
        String fPath;
        boolean fContentOnly;
        QName fElement;
        int fDepthOfNestOfElements;
        int fDepthOfNestOfPrefixMappings;

        State(String path, boolean contentOnly, QName element, int depthOfNestOfElements, int depthOfNestOfPrefixMappings) {
            this.fPath = path;
            this.fContentOnly = contentOnly;
            this.fElement = new QName(element);
            this.fDepthOfNestOfElements = depthOfNestOfElements;
            this.fDepthOfNestOfPrefixMappings = depthOfNestOfPrefixMappings;
        }
    }

    class EncryptorBody
    extends XNIEventBuffer {
        private DOM2XNI fDOM2XNI;

        EncryptorBody() {
            this.fDOM2XNI = new DOM2XNI(Encryptor.this.fSymbolTable);
        }

        void reset() {
            this.clear();
        }

        void encryptAndReplace() throws XNIException {
            boolean b = false;
            try {
                this.encrypt();
                Encryptor.this.fPathEvaluators.remove(Encryptor.this.fPath);
                b = true;
            }
            catch (Exception e) {
                Exception e2;
                if (e instanceof XNIException && (e2 = ((XNIException)e).getException()) != null) {
                    e = e2;
                }
                e.printStackTrace();
                Encryptor.this.fErrorReporter.reportError("http://www.w3.org/2001/04/xmlenc#", null, new Object[]{e.getMessage()}, (short)1);
            }
            if (b && Encryptor.this.fReplacedData.contains(Encryptor.this.fPath)) {
                this.replace();
            } else {
                this.flush();
            }
        }

        private void encrypt() throws IOException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XNIException {
            EncryptedTypeContainer etc = (EncryptedTypeContainer)Encryptor.this.fEncryptedDataContainers.get(Encryptor.this.fPath);
            if (etc == null) {
                throw new NullPointerException("EncryptedData or EncryptedKey element not specified");
            }
            EncryptionContext ec = new EncryptionContext();
            ec.setEncryptedType(etc.getEncryptedType(), etc.getType(), etc.getEncryptionMethod(), etc.getKeyInfo());
            ec.setParameters((AlgorithmParameterSpec)Encryptor.this.fParameters.get(Encryptor.this.fPath));
            ec.setKey((Key)Encryptor.this.fKeys.get(Encryptor.this.fPath));
            ec.setOutputStream((OutputStream)Encryptor.this.fOuts.get(Encryptor.this.fPath));
            ec.setAlgorithmFactory(Encryptor.this.fAlgorithmFactory);
            ec.setKeyInfoResolver(Encryptor.this.fKeyInfoResolver);
            EncryptionOutputStream eos = ec.getEncryptionOutputStream();
            String s = etc.getType();
            if (s == null) {
                throw new StructureException("Type attribute not specified");
            }
            XNISerializationEngine xse = Encryptor.this.fAlgorithmFactory.getXNISerializationEngine(s);
            xse.setOutputStream(eos);
            this.flush(xse);
            ec.doFinal(eos);
            Encryptor.this.fEncryptionContexts.put(Encryptor.this.fPath, ec);
        }

        private void replace() throws XNIException {
            this.fDOM2XNI.setDocumentHandler((XMLDocumentHandler)Encryptor.this.fDocumentHandlers.peek());
            this.fDOM2XNI.traverse(((EncryptionContext)Encryptor.this.fEncryptionContexts.get(Encryptor.this.fPath)).getEncryptedTypeAsElement());
        }

        private void flush() throws XNIException {
            this.flush((XMLDocumentHandler)Encryptor.this.fDocumentHandlers.peek());
        }
    }
}

