/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.KeyInfoResolver;
import com.ibm.xml.enc.xni.Encryptor;
import com.ibm.xml.enc.xni.MessageFormatterImpl;
import com.ibm.xml.enc.xni.XNIAlgorithmFactoryExtn;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.w3c.dom.Element;

public class EncryptionParserConfiguration
extends StandardParserConfiguration {
    private Encryptor fEncryptor = new Encryptor();

    public EncryptionParserConfiguration() {
        this.addComponent(this.fEncryptor);
        this.fErrorReporter.putMessageFormatter("http://www.w3.org/2001/04/xmlenc#", (MessageFormatter)new MessageFormatterImpl());
    }

    public void addData(String path) {
        this.fEncryptor.addData(path);
    }

    public void addEncryptedData(String path, Element encData) {
        this.addEncryptedData(path, encData, null, null, null);
    }

    public void addEncryptedData(String path, Element encData, String type, Element encMeth, Element keyInfo) {
        this.fEncryptor.addEncryptedData(path, encData, type, encMeth, keyInfo);
    }

    public void addParameters(String path, AlgorithmParameterSpec params) {
        this.fEncryptor.addParameters(path, params);
    }

    public void addKey(String path, Key key) {
        this.fEncryptor.addKey(path, key);
    }

    public void addOutputStream(String path, OutputStream out) {
        this.fEncryptor.addOutputStream(path, out);
    }

    public void addReplacedData(String path) {
        this.fEncryptor.addReplacedData(path);
    }

    public void setAlgorithmFactory(XNIAlgorithmFactoryExtn factory) {
        this.fEncryptor.setAlgorithmFactory(factory);
    }

    public void setKeyInfoResolver(KeyInfoResolver resolver) {
        this.fEncryptor.setKeyInfoResolver(resolver);
    }

    public InputStream getEncryptedData(String path) {
        return this.fEncryptor.getEncryptedData(path);
    }

    public Element getEncryptedDataAsElement(String path) {
        return this.fEncryptor.getEncryptedDataAsElement(path);
    }

    protected void configurePipeline() {
        super.configurePipeline();
        this.fLastComponent.setDocumentHandler((XMLDocumentHandler)this.fEncryptor);
        this.fEncryptor.setDocumentSource(this.fLastComponent);
        this.fEncryptor.setDocumentHandler(this.fDocumentHandler);
        this.fDocumentHandler.setDocumentSource((XMLDocumentSource)this.fEncryptor);
        this.fLastComponent = this.fEncryptor;
    }
}

