/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import com.ibm.xml.enc.type.EncryptedType;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyInfo;
import org.w3c.dom.Element;

class EncryptedTypeContainer {
    private EncryptedType fEncryptedType;
    private String fType;
    private EncryptionMethod fEncryptionMethod;
    private KeyInfo fKeyInfo;

    EncryptedTypeContainer(Element encType, String type, Element encMeth, Element keyInfo) {
        this.fType = type;
        this.setEncryptionMethod(encMeth);
        this.setKeyInfo(keyInfo);
        this.setEncryptedType(encType);
    }

    EncryptedTypeContainer(EncryptedType encType, String type, EncryptionMethod encMeth, KeyInfo keyInfo) {
        this.fType = type;
        this.fEncryptionMethod = encMeth;
        this.fKeyInfo = keyInfo;
        this.setET(encType);
    }

    void setEncryptedType(Element encType) {
        EncryptedType et = null;
        if (encType != null) {
            et = EncryptedType.getInstance(encType);
        }
        this.setET(et);
    }

    void setET(EncryptedType encType) {
        this.fEncryptedType = encType;
        if (encType != null) {
            if (this.fType == null) {
                this.fType = encType.getType();
            }
            if (this.fEncryptionMethod == null) {
                this.fEncryptionMethod = encType.getEncryptionMethod();
            }
            if (this.fKeyInfo == null) {
                this.fKeyInfo = encType.getKeyInfo();
            }
        }
    }

    Element getEncryptedType() {
        Element encType = null;
        if (this.fEncryptedType != null) {
            encType = this.fEncryptedType.getBase();
        }
        return encType;
    }

    EncryptedType getET() {
        return this.fEncryptedType;
    }

    void setType(String type) {
        this.fType = type;
    }

    String getType() {
        return this.fType;
    }

    void setEncryptionMethod(Element encMeth) {
        EncryptionMethod em = null;
        if (encMeth != null) {
            em = new EncryptionMethod(encMeth);
        }
        this.fEncryptionMethod = em;
    }

    void setEM(EncryptionMethod encMeth) {
        this.fEncryptionMethod = encMeth;
    }

    Element getEncryptionMethod() {
        Element encMeth = null;
        if (this.fEncryptionMethod != null) {
            encMeth = this.fEncryptionMethod.getBase();
        }
        return encMeth;
    }

    EncryptionMethod getEM() {
        return this.fEncryptionMethod;
    }

    void setKeyInfo(Element keyInfo) {
        KeyInfo ki = null;
        if (keyInfo != null) {
            ki = new KeyInfo(keyInfo);
        }
        this.fKeyInfo = ki;
    }

    void setKI(KeyInfo keyInfo) {
        this.fKeyInfo = keyInfo;
    }

    Element getKeyInfo() {
        Element keyInfo = null;
        if (this.fKeyInfo != null) {
            keyInfo = this.fKeyInfo.getBase();
        }
        return keyInfo;
    }

    KeyInfo getKI() {
        return this.fKeyInfo;
    }
}

