/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.xni;

import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

class DOM2XNI {
    private SymbolTable fSymbolTable;
    private XMLDocumentHandler fDocumentHandler;

    DOM2XNI(SymbolTable table) {
        this.fSymbolTable = table;
    }

    void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocumentHandler = handler;
    }

    void traverse(Node node) throws XNIException {
        if (node != null && this.fDocumentHandler != null) {
            this._traverse(node);
        }
    }

    private void _traverse(Node node) throws XNIException {
        switch (node.getNodeType()) {
            case 2: {
                break;
            }
            case 4: {
                this.cdataSection((CDATASection)node);
                break;
            }
            case 8: {
                this.comment((Comment)node);
                break;
            }
            case 11: {
                this.documentFragment((DocumentFragment)node);
                break;
            }
            case 9: {
                this.document((Document)node);
                break;
            }
            case 10: {
                this.documentType((DocumentType)node);
                break;
            }
            case 1: {
                this.element((Element)node);
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                this.entityReference((EntityReference)node);
                break;
            }
            case 12: {
                break;
            }
            case 7: {
                this.processingInstruction((ProcessingInstruction)node);
                break;
            }
            case 3: {
                this.text((Text)node);
            }
        }
    }

    private void comment(Comment comment) throws XNIException {
        String d = comment.getData();
        if (d == null) {
            d = "";
        }
        char[] cc = d.toCharArray();
        this.fDocumentHandler.comment(new XMLString(cc, 0, cc.length), null);
    }

    private void cdataSection(CDATASection cdataSec) throws XNIException {
        this.fDocumentHandler.startCDATA(null);
        String d = cdataSec.getData();
        if (d != null) {
            char[] cc = d.toCharArray();
            this.fDocumentHandler.characters(new XMLString(cc, 0, cc.length), null);
        }
        this.fDocumentHandler.endCDATA(null);
    }

    private void documentFragment(DocumentFragment docFrag) throws XNIException {
        for (Node n = docFrag.getFirstChild(); n != null; n = n.getNextSibling()) {
            this._traverse(n);
        }
    }

    private void document(Document doc) throws XNIException {
        this.fDocumentHandler.startDocument(null, null, null, null);
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            this._traverse(n);
        }
        this.fDocumentHandler.endDocument(null);
    }

    private void documentType(DocumentType docType) throws XNIException {
        String si;
        String n = this.fSymbolTable.addSymbol(docType.getName());
        String pi = docType.getPublicId();
        if (pi != null) {
            pi = this.fSymbolTable.addSymbol(pi);
        }
        if ((si = docType.getSystemId()) != null) {
            si = this.fSymbolTable.addSymbol(si);
        }
        this.fDocumentHandler.doctypeDecl(n, pi, si, null);
    }

    private void element(Element elem) throws XNIException {
        QName qn = this.getQName(elem);
        XMLAttributes xa = this.getXMLAttributes(elem);
        if (elem.hasChildNodes()) {
            this.fDocumentHandler.startElement(qn, xa, null);
            for (Node n = elem.getFirstChild(); n != null; n = n.getNextSibling()) {
                this._traverse(n);
            }
            this.fDocumentHandler.endElement(qn, null);
        } else {
            this.fDocumentHandler.emptyElement(qn, xa, null);
        }
    }

    private QName getQName(Element elem) {
        String ln;
        String p = elem.getPrefix();
        if (p != null) {
            p = this.fSymbolTable.addSymbol(p);
        }
        if ((ln = elem.getLocalName()) != null) {
            ln = this.fSymbolTable.addSymbol(ln);
        }
        String n = this.fSymbolTable.addSymbol(elem.getTagName());
        String u = elem.getNamespaceURI();
        if (u != null) {
            u = this.fSymbolTable.addSymbol(u);
        }
        return new QName(p, ln, n, u);
    }

    private XMLAttributes getXMLAttributes(Element elem) {
        XMLAttributesImpl attrs = new XMLAttributesImpl();
        if (elem.hasAttributes()) {
            NamedNodeMap nnm = elem.getAttributes();
            QName qn = new QName();
            int l = nnm.getLength();
            for (int i = 0; i < l; ++i) {
                String ln;
                Attr a = (Attr)nnm.item(i);
                String p = a.getPrefix();
                if (p != null) {
                    p = this.fSymbolTable.addSymbol(p);
                }
                if ((ln = a.getLocalName()) != null) {
                    ln = this.fSymbolTable.addSymbol(ln);
                }
                String n = this.fSymbolTable.addSymbol(a.getName());
                String u = a.getNamespaceURI();
                if (u != null) {
                    u = this.fSymbolTable.addSymbol(u);
                }
                qn.setValues(p, ln, n, u);
                String v = a.getValue();
                if (v == null) {
                    v = "";
                }
                v = this.fSymbolTable.addSymbol(v);
                attrs.addAttribute(qn, null, v);
            }
        }
        return attrs;
    }

    private void entityReference(EntityReference entityRef) throws XNIException {
        String na = this.fSymbolTable.addSymbol(entityRef.getNodeName());
        this.fDocumentHandler.startGeneralEntity(na, null, null, null);
        for (Node n = entityRef.getFirstChild(); n != null; n = n.getNextSibling()) {
            this._traverse(n);
        }
        this.fDocumentHandler.endGeneralEntity(na, null);
    }

    private void processingInstruction(ProcessingInstruction pi) throws XNIException {
        String t = this.fSymbolTable.addSymbol(pi.getTarget());
        String d = pi.getData();
        XMLString xs = null;
        if (d != null) {
            char[] cc = d.toCharArray();
            xs = new XMLString(cc, 0, cc.length);
        }
        this.fDocumentHandler.processingInstruction(t, xs, null);
    }

    private void text(Text text) throws XNIException {
        String d = text.getData();
        if (d == null) {
            d = "";
        }
        char[] cc = d.toCharArray();
        this.fDocumentHandler.characters(new XMLString(cc, 0, cc.length), null);
    }
}

