/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.util;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.ReferenceList;
import com.ibm.xml.enc.type.ReferenceType;
import com.ibm.xml.enc.xni.XNIEncryptedKeyRetriever;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Element;

public class XNISameDocumentEncryptedKeyRetriever
extends XNIEncryptedKeyRetriever {
    private Map fEncryptedKeyLists = new HashMap();
    private int fDepthOfNest;

    private boolean isEncryptedKey(QName elem, XMLAttributes attrs) {
        return elem.uri != null && elem.uri.equals("http://www.w3.org/2001/04/xmlenc#") && elem.localpart != null && elem.localpart.equals("EncryptedKey");
    }

    private void addEncryptedKeys(EncryptedKey encKey) throws StructureException {
        KeyInfo ki;
        ReferenceList rl = encKey.getReferenceList();
        if (rl != null) {
            Iterator i = rl.getReferences().iterator();
            while (i.hasNext()) {
                String s = ((ReferenceType)i.next()).getURI();
                if (s == null) {
                    throw new StructureException("URI not specified");
                }
                if (!(s = s.trim()).startsWith("#") || s.length() < 2) continue;
                s = this.getId(s);
                this.retrieve(s).add(encKey);
            }
        }
        if ((ki = encKey.getKeyInfo()) != null) {
            Iterator i = ki.getKeyIds().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)o);
            }
        }
    }

    private String getId(String uri) {
        char c;
        String s;
        String id = uri.substring(1);
        if (id.startsWith("xpointer(") && id.endsWith(")") && (s = id.substring(9, id.length() - 1).trim()).startsWith("id(") && s.endsWith(")") && (s = s.substring(3, id.length() - 1).trim()).length() > 2 && ((c = s.charAt(0)) == '\"' || c == '\'') && c == s.charAt(s.length() - 1)) {
            id = s.substring(1, s.length() - 1);
        }
        return id;
    }

    public List retrieve(String id) {
        List encKeys = null;
        if (id != null) {
            if (!this.fEncryptedKeyLists.containsKey(id)) {
                this.fEncryptedKeyLists.put(id, new ArrayList());
            }
            encKeys = (List)this.fEncryptedKeyLists.get(id);
        }
        return encKeys;
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (this.fInScope) {
            ++this.fDepthOfNest;
        } else if (this.isEncryptedKey(element, attributes)) {
            super.enterScope();
            this.fDepthOfNest = 1;
        }
        super.startElement(element, attributes, augs);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        super.endElement(element, augs);
        if (this.fInScope) {
            --this.fDepthOfNest;
            if (this.fDepthOfNest < 1) {
                try {
                    this.addEncryptedKeys(new EncryptedKey((Element)super.leaveScope().item(0)));
                }
                catch (StructureException e) {
                    throw new XNIException((Exception)e);
                }
            }
        }
    }
}

