/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.util;

import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.KeyName;
import com.ibm.xml.enc.xni.XNIKeyInfoResolver;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class XNIKeyStoreKeyInfoResolver
extends XNIKeyInfoResolver {
    private KeyStore fKeyStore;
    private Map fPasswords;

    public XNIKeyStoreKeyInfoResolver(KeyStore store) {
        this.fKeyStore = store;
        this.fPasswords = new HashMap();
    }

    public void putAliasAndPassword(String alias, char[] password) {
        this.fPasswords.put(alias, password);
    }

    public char[] getPassword(String alias) {
        return (char[])this.fPasswords.get(alias);
    }

    protected String getAlias(String name) {
        return name;
    }

    protected Key resolveKeyName(KeyName keyName, EncryptionMethod encMeth, Key key) throws KeyInfoResolvingException {
        String n;
        if (key == null) {
            key = super.resolveKeyName(keyName, encMeth, key);
        }
        if (key == null && (n = keyName.getName()) != null) {
            String a = this.getAlias(n);
            if (this.fKeyStore == null) {
                throw new KeyInfoResolvingException("Keystore not specified");
            }
            try {
                if (this.fKeyStore.containsAlias(a)) {
                    char[] p;
                    Certificate c;
                    if (this.fInEncryptMode && (c = this.fKeyStore.getCertificate(a)) != null) {
                        key = c.getPublicKey();
                    }
                    if (key == null && (p = this.getPassword(a)) != null) {
                        key = this.fKeyStore.getKey(a, p);
                    }
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
                throw new KeyInfoResolvingException(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return key;
    }
}

