/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.util;

import com.ibm.xml.enc.EncryptedKeyRetriever;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.KeyInfo;
import com.ibm.xml.enc.type.ReferenceList;
import com.ibm.xml.enc.type.ReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SameDocumentEncryptedKeyRetriever
implements EncryptedKeyRetriever {
    private Map fEncryptedKeyLists = new HashMap();

    public SameDocumentEncryptedKeyRetriever(Document doc) throws StructureException {
        if (doc == null) {
            throw new NullPointerException("Document not specified");
        }
        Element e = doc.getDocumentElement();
        if (e != null) {
            this.addEncryptedKeys(e);
        }
    }

    private void addEncryptedKeys(Node node) throws StructureException {
        if (node.getNodeType() == 1 && EncryptedKey.isOfType((Element)node)) {
            this.addEncryptedKeys(new EncryptedKey((Element)node));
        } else {
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                this.addEncryptedKeys(n);
            }
        }
    }

    private void addEncryptedKeys(EncryptedKey encKey) throws StructureException {
        KeyInfo ki;
        ReferenceList rl = encKey.getReferenceList();
        if (rl != null) {
            Iterator i = rl.getReferences().iterator();
            while (i.hasNext()) {
                String s = ((ReferenceType)i.next()).getURI();
                if (s == null) {
                    throw new StructureException("URI not specified");
                }
                if (!(s = s.trim()).startsWith("#") || s.length() < 2) continue;
                s = this.getId(s);
                this.retrieve(s).add(encKey);
            }
        }
        if ((ki = encKey.getKeyInfo()) != null) {
            Iterator i = ki.getKeyIds().iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof EncryptedKey)) continue;
                this.addEncryptedKeys((EncryptedKey)o);
            }
        }
    }

    private String getId(String uri) {
        char c;
        String s;
        String id = uri.substring(1);
        if (id.startsWith("xpointer(") && id.endsWith(")") && (s = id.substring(9, id.length() - 1).trim()).startsWith("id(") && s.endsWith(")") && (s = s.substring(3, id.length() - 1).trim()).length() > 2 && ((c = s.charAt(0)) == '\"' || c == '\'') && c == s.charAt(s.length() - 1)) {
            id = s.substring(1, s.length() - 1);
        }
        return id;
    }

    public List retrieve(String id) {
        List encKeys = null;
        if (id != null) {
            if (!this.fEncryptedKeyLists.containsKey(id)) {
                this.fEncryptedKeyLists.put(id, new ArrayList());
            }
            encKeys = (List)this.fEncryptedKeyLists.get(id);
        }
        return encKeys;
    }
}

