/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static final String XML_NS = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_NS_PREFIX = "xml";
    public static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String XMLNS_NS_PREFIX = "xmlns";

    public static Map getNamespaceDeclAttrNodes(Node node) {
        HashMap<String, Attr> attrs = null;
        if (node != null) {
            attrs = new HashMap<String, Attr>();
            DOMUtil._getNamespaceDeclAttrNodes(node, node, attrs);
            Document d = node.getOwnerDocument();
            if (node.getNodeType() == 9) {
                d = (Document)node;
            }
            Attr a = d.createAttributeNS(XMLNS_NS, "xmlns:xml");
            a.setValue(XML_NS);
            attrs.put(a.getName(), a);
        }
        return attrs;
    }

    private static void _getNamespaceDeclAttrNodes(Node current, Node start, Map attrs) {
        if (DOMUtil.hasParentNode(current)) {
            DOMUtil._getNamespaceDeclAttrNodes(current.getParentNode(), start, attrs);
        }
        if (current != start && current.getNodeType() == 1) {
            NamedNodeMap nnm = current.getAttributes();
            int l = nnm.getLength();
            for (int i = 0; i < l; ++i) {
                Attr a = (Attr)nnm.item(i);
                String s = a.getName();
                if (!s.equals(XMLNS_NS_PREFIX) && !s.startsWith("xmlns:")) continue;
                attrs.put(s, a);
            }
        }
    }

    public static Node getRootNode(Node node) {
        Node root = null;
        if (node != null) {
            root = DOMUtil._getRootNode(node);
        }
        return root;
    }

    private static Node _getRootNode(Node node) {
        Node root = node;
        if (DOMUtil.hasParentNode(node)) {
            root = DOMUtil._getRootNode(node.getParentNode());
        }
        return root;
    }

    public static Element getFirstElement(NodeList nodes) {
        return (Element)DOMUtil.getFirstNodeOfType(nodes, (short)1);
    }

    public static Node getFirstNodeOfType(NodeList nodes, short type) {
        Node first = null;
        if (nodes != null) {
            int l = nodes.getLength();
            for (int i = 0; i < l; ++i) {
                Node n = nodes.item(i);
                if (n.getNodeType() != type) continue;
                first = n;
                break;
            }
        }
        return first;
    }

    public static Element getFirstChildElement(Node node) {
        return (Element)DOMUtil.getFirstChildNodeOfType(node, (short)1);
    }

    public static Node getFirstChildNodeOfType(Node node, short type) {
        Node first = null;
        if (node != null && node.hasChildNodes()) {
            first = DOMUtil.getNextSiblingNodeOfType(node.getFirstChild(), type);
        }
        return first;
    }

    public static Element getNextSiblingElement(Node node) {
        return (Element)DOMUtil.getNextSiblingNodeOfType(node, (short)1);
    }

    public static Node getNextSiblingNodeOfType(Node node, short type) {
        Node next = null;
        if (node != null) {
            while (node != null) {
                if (node.getNodeType() == type) {
                    next = node;
                    break;
                }
                node = node.getNextSibling();
            }
        }
        return next;
    }

    public static Element getLastChildElement(Node node) {
        return (Element)DOMUtil.getLastChildNodeOfType(node, (short)1);
    }

    public static Node getLastChildNodeOfType(Node node, short type) {
        Node last = null;
        if (node != null && node.hasChildNodes()) {
            last = DOMUtil.getPreviousSiblingNodeOfType(node.getLastChild(), type);
        }
        return last;
    }

    public static Node getPreviousSiblingElement(Node node) {
        return (Element)DOMUtil.getPreviousSiblingNodeOfType(node, (short)1);
    }

    public static Node getPreviousSiblingNodeOfType(Node node, short type) {
        Node prev = null;
        if (node != null) {
            while (node != null) {
                if (node.getNodeType() == type) {
                    prev = node;
                    break;
                }
                node = node.getPreviousSibling();
            }
        }
        return prev;
    }

    public static void moveChildNodes(Node oldNode, Node newNode) {
        if (oldNode == null || newNode == null) {
            return;
        }
        while (oldNode.hasChildNodes()) {
            Node n = oldNode.getFirstChild();
            newNode.appendChild(n);
        }
    }

    public static void removeChildNodes(Node node) {
        if (node == null) {
            return;
        }
        while (node.hasChildNodes()) {
            Node n = node.getFirstChild();
            node.removeChild(n);
        }
    }

    public static NodeList getChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeListImpl nodeList = new NodeListImpl();
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            nodeList.add(n);
        }
        return nodeList;
    }

    public static void replaceNode(Node oldNode, Node newNode) {
        if (oldNode != null && DOMUtil.hasParentNode(oldNode) && newNode != null) {
            Node n = oldNode.getParentNode();
            n.replaceChild(newNode, oldNode);
        }
    }

    public static void replaceNode(Node oldNode, NodeList newNodes) {
        if (oldNode != null && DOMUtil.hasParentNode(oldNode) && newNodes != null && newNodes.getLength() > 0) {
            Node p = oldNode.getParentNode();
            Node c = newNodes.item(newNodes.getLength() - 1);
            p.replaceChild(c, oldNode);
            int l = newNodes.getLength() - 1;
            for (int i = 0; i < l; ++i) {
                p.insertBefore(newNodes.item(i), c);
            }
        }
    }

    public static void replaceNodes(NodeList oldNodes, Node newNode) {
        if (oldNodes != null && oldNodes.getLength() > 0 && DOMUtil.hasParentNode(oldNodes.item(0)) && newNode != null) {
            Node c = oldNodes.item(0);
            Node p = c.getParentNode();
            p.replaceChild(newNode, c);
            int l = oldNodes.getLength();
            for (int i = 1; i < l; ++i) {
                p.removeChild(oldNodes.item(i));
            }
        }
    }

    public static NodeList getElementsByTagNameNS(Node node, String nsUri, String localName) {
        NodeListImpl nodeList = null;
        if (node != null) {
            nodeList = new NodeListImpl();
            DOMUtil.getElementsByTagName(node, nsUri, localName, nodeList, true);
        }
        return nodeList;
    }

    public static NodeList getElementsByTagName(Node node, String name) {
        NodeListImpl nodeList = null;
        if (node != null) {
            nodeList = new NodeListImpl();
            DOMUtil.getElementsByTagName(node, null, name, nodeList, false);
        }
        return nodeList;
    }

    private static void getElementsByTagName(Node node, String nsUri, String localName, NodeListImpl nodeList, boolean withNs) {
        Object n;
        if (node.getNodeType() == 1) {
            if (withNs) {
                String ns = node.getNamespaceURI();
                if (nsUri == null || nsUri.equals("*") || nsUri.equals(ns)) {
                    String ln = node.getLocalName();
                    if (localName == null || localName.equals("*") || localName.equals(ln)) {
                        nodeList.add(node);
                    }
                }
            } else {
                n = ((Element)node).getTagName();
                if (localName == null || localName.equals("*") || localName.equals(n)) {
                    nodeList.add(node);
                }
            }
        }
        for (n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            DOMUtil.getElementsByTagName((Node)n, nsUri, localName, nodeList, withNs);
        }
    }

    public static NodeList getElementsByAttribute(Node node, String name, String value) {
        NodeListImpl nodeList = null;
        if (node != null) {
            nodeList = new NodeListImpl();
            DOMUtil.getElementsByAttribute(node, name, value, nodeList);
        }
        return nodeList;
    }

    private static void getElementsByAttribute(Node node, String name, String value, NodeListImpl nodeList) {
        if (node.getNodeType() == 1) {
            if (name == null || name.equals("*")) {
                NamedNodeMap m = node.getAttributes();
                int l = m.getLength();
                for (int i = 0; i < l; ++i) {
                    String v = ((Attr)m.item(i)).getValue();
                    if (value != null && !value.equals("*") && !value.equals(v)) continue;
                    nodeList.add(node);
                    break;
                }
            } else {
                Element e = (Element)node;
                if (value == null || value.equals("*") || e.hasAttribute(name) && value.equals(e.getAttribute(name))) {
                    nodeList.add(node);
                }
            }
        }
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            DOMUtil.getElementsByAttribute(n, name, value, nodeList);
        }
    }

    static void printNode(Node node, boolean deep) {
        if (node != null) {
            DOMUtil.printNode(node, "", deep);
        }
    }

    private static void printNode(Node node, String indent, boolean deep) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append(DOMUtil.getString(node.getNodeType()));
        sb.append(" [");
        sb.append("ns=" + DOMUtil.getQuotedString(node.getNamespaceURI()));
        sb.append(", ");
        sb.append("ln=" + DOMUtil.getQuotedString(node.getLocalName()));
        sb.append(", ");
        sb.append("name=" + DOMUtil.getQuotedString(node.getNodeName()));
        sb.append(", ");
        sb.append("value=" + DOMUtil.getQuotedString(node.getNodeValue()));
        sb.append("]");
        System.err.println(sb.toString());
        if (deep) {
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                DOMUtil.printNode(n, indent + "  ", deep);
            }
        }
    }

    private static String getString(short type) {
        String str = null;
        switch (type) {
            case 2: {
                str = "ATTRIBUTE";
                break;
            }
            case 4: {
                str = "CDATA_SECTION";
                break;
            }
            case 8: {
                str = "COMMENT";
                break;
            }
            case 11: {
                str = "DOCUMENT_FRAGMENT";
                break;
            }
            case 9: {
                str = "DOCUMENT";
                break;
            }
            case 10: {
                str = "DOCUMENT_TYPE";
                break;
            }
            case 1: {
                str = "ELEMENT";
                break;
            }
            case 6: {
                str = "ENTITY";
                break;
            }
            case 5: {
                str = "ENTITY_REFERENCE";
                break;
            }
            case 12: {
                str = "NOTATION";
                break;
            }
            case 7: {
                str = "PROCESSING_INSTRUCTION";
                break;
            }
            case 3: {
                str = "TEXT";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + type);
            }
        }
        return str;
    }

    private static String getQuotedString(String str) {
        if (str != null) {
            str = "\"" + str + "\"";
        }
        return str;
    }

    public static boolean isDescendantNode(Node node, Node ancestor) {
        boolean descendant = false;
        if (node != null && ancestor != null) {
            descendant = DOMUtil._isDescendantNode(node, ancestor);
        }
        return descendant;
    }

    private static boolean _isDescendantNode(Node node, Node ancestor) {
        boolean descendant = false;
        if (node == ancestor) {
            descendant = true;
        } else if (node.getNodeType() == 2) {
            if ((node = ((Attr)node).getOwnerElement()) != null) {
                descendant = DOMUtil._isDescendantNode(node, ancestor);
            }
        } else if (DOMUtil.hasParentNode(node)) {
            descendant = DOMUtil._isDescendantNode(node.getParentNode(), ancestor);
        }
        return descendant;
    }

    public static boolean contains(NodeList nodes, int start, Node node) {
        return DOMUtil.contains(nodes, start, nodes != null ? nodes.getLength() : -1, node);
    }

    public static boolean contains(NodeList nodes, int start, int end, Node node) {
        return DOMUtil.getIndex(node, nodes, start, end) >= 0;
    }

    public static int getIndex(Node node, NodeList nodes, int start) {
        return DOMUtil.getIndex(node, nodes, start, nodes != null ? nodes.getLength() : -1);
    }

    public static int getIndex(Node node, NodeList nodes, int start, int end) {
        int index = -1;
        if (node != null && nodes != null) {
            if (start < 0 || start >= nodes.getLength()) {
                throw new IndexOutOfBoundsException(Integer.toString(start));
            }
            if (end <= start || end > nodes.getLength()) {
                throw new IndexOutOfBoundsException(Integer.toString(end));
            }
            for (int i = start; index < 0 && i < end; ++i) {
                if (nodes.item(i) != node) continue;
                index = i;
            }
        }
        return index;
    }

    public static String getStringValue(NodeList nodeSet, int index) {
        String value = null;
        if (nodeSet != null) {
            if (index < 0 || index >= nodeSet.getLength()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            Node n = nodeSet.item(index);
            short s = n.getNodeType();
            switch (s) {
                case 1: 
                case 9: {
                    StringBuffer sb = new StringBuffer();
                    DOMUtil._getStringValue(n, nodeSet, index + 1, sb);
                    value = sb.toString();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    value = DOMUtil.getString(n.getNodeValue());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown node type: " + s);
                }
            }
        }
        return value;
    }

    private static int _getStringValue(Node node, NodeList nodeSet, int index, StringBuffer buf) {
        int index2 = index;
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: 
                case 5: {
                    index2 = DOMUtil._getStringValue(n, nodeSet, index2, buf);
                    continue block4;
                }
                case 3: 
                case 4: {
                    int i = DOMUtil.getIndex(n, nodeSet, index2);
                    if (i < 0) continue block4;
                    buf.append(DOMUtil.getString(n.getNodeValue()));
                    index2 = i + 1;
                }
            }
        }
        return index2;
    }

    private static String getString(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }

    public static DocumentFragment cloneChildNodes(Node node) {
        DocumentFragment frag = null;
        if (node != null) {
            frag = node.getOwnerDocument().createDocumentFragment();
            for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                frag.appendChild(n.cloneNode(true));
            }
        }
        return frag;
    }

    public static boolean hasParentNode(Node node) {
        return node != null && DOMUtil.canHaveParentNode(node) && node.getParentNode() != null;
    }

    private static boolean canHaveParentNode(Node node) {
        boolean can = true;
        switch (node.getNodeType()) {
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                can = false;
            }
        }
        return can;
    }

    public static class NodeListImpl
    implements NodeList {
        private List fList = new ArrayList();

        public NodeListImpl() {
            this(null);
        }

        public NodeListImpl(Node node) {
            if (node != null) {
                this.fList.add(node);
            }
        }

        public void add(Node node) {
            if (node != null) {
                this.fList.add(node);
            }
        }

        public Node item(int index) {
            return (Node)this.fList.get(index);
        }

        public int getLength() {
            return this.fList.size();
        }
    }
}

