/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Transform
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "Transform";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final String ELEM_XPATH = "XPath";
    private String fAlgorithm;

    public Transform() {
        this(null);
    }

    public Transform(Element trans) {
        super(trans);
        if (trans != null) {
            if (!Transform.isOfType(trans)) {
                throw new IllegalArgumentException("Not Transform element");
            }
            if (trans.hasAttribute(ATTR_ALGORITHM)) {
                this.fAlgorithm = trans.getAttribute(ATTR_ALGORITHM);
            }
            this.init(trans);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(Element elem) {
        String s1 = elem.getNamespaceURI();
        String s2 = elem.getLocalName();
        return s1 != null && (!s1.equals(NAMESPACE) || s2 != null && s2.equals(ELEM_XPATH));
    }

    public void setAlgorithm(String uri) {
        this.fAlgorithm = uri;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(Element param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element trans = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            trans.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        trans.setAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm));
        super.createElement(trans, factory, NAMESPACE);
        return trans;
    }
}

