/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.type.EncryptedKey;
import com.ibm.xml.enc.type.KeyName;
import com.ibm.xml.enc.type.RetrievalMethod;
import com.ibm.xml.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfo
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "KeyInfo";
    private static final String ATTR_ID = "Id";
    private static final String ELEM_KEY_VALUE = "KeyValue";
    private static final String ELEM_X509_DATA = "X509Data";
    private static final String ELEM_PGP_DATA = "PGPData";
    private static final String ELEM_SPKI_DATA = "SPKIData";
    private static final String ELEM_MGMT_DATA = "MgmtData";
    private String fId;

    public KeyInfo() {
        this(null);
    }

    public KeyInfo(Element keyInfo) {
        super(keyInfo);
        if (keyInfo != null) {
            if (!KeyInfo.isOfType(keyInfo)) {
                throw new IllegalArgumentException("Not KeyInfo element");
            }
            if (keyInfo.hasAttribute(ATTR_ID)) {
                this.fId = keyInfo.getAttribute(ATTR_ID);
            }
            this.init(keyInfo);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    Object o = null;
                    if (EncryptedKey.isOfType(e)) {
                        o = new EncryptedKey(e);
                    } else if (KeyName.isOfType(e)) {
                        o = new KeyName(e);
                    } else if (RetrievalMethod.isOfType(e)) {
                        o = new RetrievalMethod(e);
                    } else if (this.isKeyId(e)) {
                        o = e;
                    }
                    super.addElement(o);
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isKeyId(Element elem) {
        String s1 = elem.getNamespaceURI();
        String s2 = elem.getLocalName();
        return s1 != null && (!s1.equals(NAMESPACE) || s2 != null && (s2.equals(ELEM_KEY_VALUE) || s2.equals(ELEM_X509_DATA) || s2.equals(ELEM_PGP_DATA) || s2.equals(ELEM_SPKI_DATA) || s2.equals(ELEM_MGMT_DATA)));
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public void addEncryptedKey(EncryptedKey encKey) {
        super.addElement(encKey);
    }

    public void addKeyName(KeyName keyName) {
        super.addElement(keyName);
    }

    public void addRetrievalMethod(RetrievalMethod retMeth) {
        super.addElement(retMeth);
    }

    public void addKeyId(Element keyId) {
        if (keyId != null) {
            if (!this.isKeyId(keyId)) {
                throw new IllegalArgumentException("Wrong key id");
            }
            super.addElement(keyId);
        }
    }

    public List getKeyIds() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element keyInfo = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            keyInfo.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fId != null) {
            keyInfo.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Key ids not specified");
        }
        super.createElement(keyInfo, factory, NAMESPACE);
        return keyInfo;
    }
}

