/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EncryptionProperty
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionProperty";
    private static final String ATTR_TARGET = "Target";
    private static final String ATTR_ID = "Id";
    private String fTarget;
    private String fId;
    private List fAttributes = new ArrayList();

    public EncryptionProperty() {
        this(null);
    }

    public EncryptionProperty(Element encProp) {
        super(encProp);
        if (encProp != null) {
            if (!EncryptionProperty.isOfType(encProp)) {
                throw new IllegalArgumentException("Not EncryptionProperty element");
            }
            NamedNodeMap nnm = encProp.getAttributes();
            int l = nnm.getLength();
            for (int i = 0; i < l; ++i) {
                Attr a = (Attr)nnm.item(i);
                String s = a.getName();
                if (s.equals(ATTR_TARGET)) {
                    this.fTarget = a.getValue();
                    continue;
                }
                if (s.equals(ATTR_ID)) {
                    this.fId = a.getValue();
                    continue;
                }
                if (!this.isAttribute(a)) continue;
                this.fAttributes.add(a);
            }
            this.init(encProp);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private boolean isAttribute(Attr attr) {
        String s = attr.getNamespaceURI();
        return s != null && s.equals("http://www.w3.org/XML/1998/namespace");
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(Element elem) {
        String s = elem.getNamespaceURI();
        return s != null && !s.equals(NAMESPACE);
    }

    public void setTarget(String uri) {
        this.fTarget = uri;
    }

    public String getTarget() {
        return this.fTarget;
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public void addAttribute(Attr attr) {
        if (attr != null) {
            if (!this.isAttribute(attr)) {
                throw new IllegalArgumentException("Wrong attribute");
            }
            this.fAttributes.add(attr);
        }
    }

    public List getAttributes() {
        return this.fAttributes;
    }

    public void addParameter(Element param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element encProp = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            encProp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fTarget != null) {
            encProp.setAttribute(ATTR_TARGET, Util.normalize(this.fTarget));
        }
        if (this.fId != null) {
            encProp.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        Iterator i = this.fAttributes.iterator();
        while (i.hasNext()) {
            Attr a = (Attr)factory.importNode((Attr)i.next(), true);
            encProp.setAttributeNodeNS(a);
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("Parameters not specified");
        }
        super.createElement(encProp, factory, NAMESPACE);
        return encProp;
    }
}

