/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.type.EncryptionProperty;
import com.ibm.xml.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionProperties
extends ElementsType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptionProperties";
    private static final String ATTR_ID = "Id";
    public static final String TYPE = "http://www.w3.org/2001/04/xmlenc#EncryptionProperties";
    private String fId;

    public EncryptionProperties() {
        this(null);
    }

    public EncryptionProperties(Element encProps) {
        super(encProps);
        if (encProps != null) {
            if (!EncryptionProperties.isOfType(encProps)) {
                throw new IllegalArgumentException("Not EncryptionProperties element");
            }
            if (encProps.hasAttribute(ATTR_ID)) {
                this.fId = encProps.getAttribute(ATTR_ID);
            }
            this.init(encProps);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!EncryptionProperty.isOfType(e)) continue block4;
                    super.addElement(new EncryptionProperty(e));
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    public void setId(String id) {
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public void addEncryptionProperty(EncryptionProperty encProp) {
        super.addElement(encProp);
    }

    public List getEncryptionProperties() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element encProps = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            encProps.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fId != null) {
            encProps.setAttribute(ATTR_ID, Util.normalize(this.fId));
        }
        if (this.fElements.isEmpty()) {
            throw new StructureException("EncryptionProperties not specified");
        }
        super.createElement(encProps, factory, NAMESPACE);
        return encProps;
    }
}

