/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.CarriedKeyName;
import com.ibm.xml.enc.type.EncryptedType;
import com.ibm.xml.enc.type.ReferenceList;
import com.ibm.xml.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptedKey
extends EncryptedType {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "EncryptedKey";
    private static final String ATTR_RECIPIENT = "Recipient";
    public static final String TYPE = "http://www.w3.org/2001/04/xmlenc#EncryptedKey";
    private String fRecipient;
    private ReferenceList fReferenceList;
    private CarriedKeyName fKeyName;

    public EncryptedKey() {
        this(null);
    }

    public EncryptedKey(Element encKey) {
        super(encKey);
        if (encKey != null) {
            if (!EncryptedKey.isOfType(encKey)) {
                throw new IllegalArgumentException("Not EncryptedKey element");
            }
            if (encKey.hasAttribute(ATTR_RECIPIENT)) {
                this.fRecipient = encKey.getAttribute(ATTR_RECIPIENT);
            }
            this.init(encKey);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (ReferenceList.isOfType(e)) {
                        this.fReferenceList = new ReferenceList(e);
                        continue block4;
                    }
                    if (!CarriedKeyName.isOfType(e)) continue block4;
                    this.fKeyName = new CarriedKeyName(e);
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    public void setRecipient(String recipient) {
        this.fRecipient = recipient;
    }

    public String getRecipient() {
        return this.fRecipient;
    }

    public void setReferenceList(ReferenceList refList) {
        this.fReferenceList = refList;
    }

    public ReferenceList getReferenceList() {
        return this.fReferenceList;
    }

    public void setCarriedKeyName(CarriedKeyName keyName) {
        this.fKeyName = keyName;
    }

    public CarriedKeyName getCarriedKeyName() {
        return this.fKeyName;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        Element e;
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element encKey = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            encKey.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        super.createElement(encKey, factory);
        if (this.fRecipient != null) {
            encKey.setAttribute(ATTR_RECIPIENT, Util.normalize(this.fRecipient));
        }
        if (this.fReferenceList != null) {
            e = this.fReferenceList.createElement(factory, false);
            encKey.appendChild(e);
        }
        if (this.fKeyName != null) {
            e = this.fKeyName.createElement(factory, false);
            encKey.appendChild(e);
        }
        return encKey;
    }
}

