/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.ElementsType;
import com.ibm.xml.enc.util.Util;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DigestMethod
extends ElementsType {
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String RIPEMD160 = "http://www.w3.org/2001/04/xmlenc#ripemd160";
    private static final String NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    private static final String NAME = "DigestMethod";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private String fAlgorithm;

    public DigestMethod() {
        this(null);
    }

    public DigestMethod(Element digMeth) {
        super(digMeth);
        if (digMeth != null) {
            if (!DigestMethod.isOfType(digMeth)) {
                throw new IllegalArgumentException("Not DigestMethod element");
            }
            if (digMeth.hasAttribute(ATTR_ALGORITHM)) {
                this.fAlgorithm = digMeth.getAttribute(ATTR_ALGORITHM);
            }
            this.init(digMeth);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!this.isParameter(e)) continue block4;
                    super.addElement(e);
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    private boolean isParameter(Element elem) {
        String s = elem.getNamespaceURI();
        return s != null && !s.equals(NAMESPACE);
    }

    public void setAlgorithm(String uri) {
        this.fAlgorithm = uri;
    }

    public String getAlgorithm() {
        return this.fAlgorithm;
    }

    public void addParameter(Element param) {
        if (param != null) {
            if (!this.isParameter(param)) {
                throw new IllegalArgumentException("Wrong parameter");
            }
            super.addElement(param);
        }
    }

    public List getParameters() {
        return super.getElements();
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element digMeth = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            digMeth.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fAlgorithm == null) {
            throw new StructureException("Algorithm not specified");
        }
        digMeth.setAttribute(ATTR_ALGORITHM, Util.normalize(this.fAlgorithm));
        super.createElement(digMeth, factory, NAMESPACE);
        return digMeth;
    }
}

