/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc.type;

import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.Transforms;
import com.ibm.xml.enc.type.Type;
import com.ibm.xml.enc.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CipherReference
extends Type {
    private static final String NAMESPACE = "http://www.w3.org/2001/04/xmlenc#";
    private static final String NAME = "CipherReference";
    private static final String ATTR_URI = "URI";
    private String fUri;
    private Transforms fTransforms;

    public CipherReference() {
        this(null);
    }

    public CipherReference(Element ciphRef) {
        super(ciphRef);
        if (ciphRef != null) {
            if (!CipherReference.isOfType(ciphRef)) {
                throw new IllegalArgumentException("Not CipherReference element");
            }
            if (ciphRef.hasAttribute(ATTR_URI)) {
                this.fUri = ciphRef.getAttribute(ATTR_URI);
            }
            this.init(ciphRef);
        }
    }

    public static boolean isOfType(Element elem) {
        return elem != null && NAMESPACE.equals(elem.getNamespaceURI()) && NAME.equals(elem.getLocalName());
    }

    private void init(Node node) {
        block4: for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 1: {
                    Element e = (Element)n;
                    if (!Transforms.isOfType(e)) continue block4;
                    this.fTransforms = new Transforms(e);
                    continue block4;
                }
                case 5: {
                    this.init(n);
                }
            }
        }
    }

    public void setURI(String uri) {
        this.fUri = uri;
    }

    public String getURI() {
        return this.fUri;
    }

    public void setTransforms(Transforms transs) {
        this.fTransforms = transs;
    }

    public Transforms getTransforms() {
        return this.fTransforms;
    }

    public String getNamespaceURI() {
        return NAMESPACE;
    }

    public Element createElement(Document factory, boolean withNsDecl) throws StructureException {
        if (factory == null) {
            throw new NullPointerException("Node factory not specified");
        }
        Element ciphRef = factory.createElementNS(NAMESPACE, NAME);
        if (withNsDecl) {
            ciphRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NAMESPACE);
        }
        if (this.fUri == null) {
            throw new StructureException("URI not specified");
        }
        ciphRef.setAttribute(ATTR_URI, Util.normalize(this.fUri));
        if (this.fTransforms != null) {
            Element e = this.fTransforms.createElement(factory, false);
            ciphRef.appendChild(e);
        }
        return ciphRef;
    }
}

