/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.type.EncryptionMethod;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyGenerationEngine {
    private static SecureRandom fRandom;

    public abstract EncryptionMethod getEncryptionMethod();

    public abstract Provider getProvider();

    public abstract void init(AlgorithmParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract Key generateKey();

    public abstract Key generateKey(byte[] var1, String var2) throws InvalidKeyException;

    public abstract int getKeyLength(String var1);

    static synchronized SecureRandom getRandom() {
        if (fRandom == null) {
            fRandom = new SecureRandom();
        }
        return fRandom;
    }

    static class AES256
    extends AES {
        private static final int KEY_LENGTH = 32;

        AES256(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            super(encMeth, provider, 32);
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 32) {
                throw new InvalidKeyException("Too short material");
            }
            return this.generateKey(new SecretKeySpec(keyMat, 0, 32, "AES"));
        }

        public int getKeyLength(String type) {
            return 32;
        }
    }

    static class AES192
    extends AES {
        private static final int KEY_LENGTH = 24;

        AES192(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            super(encMeth, provider, 24);
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 24) {
                throw new InvalidKeyException("Too short material");
            }
            return this.generateKey(new SecretKeySpec(keyMat, 0, 24, "AES"));
        }

        public int getKeyLength(String type) {
            return 24;
        }
    }

    static class AES128
    extends AES {
        private static final int KEY_LENGTH = 16;

        AES128(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            super(encMeth, provider, 16);
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 16) {
                throw new InvalidKeyException("Too short material");
            }
            return this.generateKey(new SecretKeySpec(keyMat, 0, 16, "AES"));
        }

        public int getKeyLength(String type) {
            return 16;
        }
    }

    static abstract class AES
    extends KeyGenerationEngine {
        static final String ALGORITHM = "AES";
        private EncryptionMethod fEncryptionMethod;
        private KeyGenerator fKeyGenerator;
        private SecretKeyFactory fKeyFactory;
        private boolean fUsingKeyGenerator;

        AES(EncryptionMethod encMeth, String provider, int keyLen) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            if (provider != null) {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
            } else {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            }
            this.fKeyGenerator.init(keyLen * 8, AES.getRandom());
            this.fUsingKeyGenerator = true;
        }

        Key generateKey(KeySpec keySpec) {
            SecretKey key = null;
            try {
                key = this.fKeyFactory.generateSecret(keySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
            this.fUsingKeyGenerator = false;
            return key;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            Provider provider = null;
            provider = this.fUsingKeyGenerator ? this.fKeyGenerator.getProvider() : this.fKeyFactory.getProvider();
            return provider;
        }

        public void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                this.fKeyGenerator.init(params, AES.getRandom());
            }
            this.fUsingKeyGenerator = true;
        }

        public Key generateKey() {
            SecretKey key = this.fKeyGenerator.generateKey();
            this.fUsingKeyGenerator = true;
            return key;
        }
    }

    static class TripleDES
    extends KeyGenerationEngine {
        private static final String ALGORITHM = "DESede";
        private static final int KEY_LENGTH = 24;
        private EncryptionMethod fEncryptionMethod;
        private KeyGenerator fKeyGenerator;
        private SecretKeyFactory fKeyFactory;
        private boolean fUsingKeyGenerator;

        TripleDES(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            if (provider != null) {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM, provider);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM, provider);
            } else {
                this.fKeyGenerator = KeyGenerator.getInstance(ALGORITHM);
                this.fKeyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            }
            this.fKeyGenerator.init(TripleDES.getRandom());
            this.fUsingKeyGenerator = true;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            Provider provider = null;
            provider = this.fUsingKeyGenerator ? this.fKeyGenerator.getProvider() : this.fKeyFactory.getProvider();
            return provider;
        }

        public void init(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params != null) {
                this.fKeyGenerator.init(params, TripleDES.getRandom());
            }
            this.fUsingKeyGenerator = true;
        }

        public Key generateKey() {
            SecretKey key = this.fKeyGenerator.generateKey();
            this.fUsingKeyGenerator = true;
            return key;
        }

        public Key generateKey(byte[] keyMat, String type) throws InvalidKeyException {
            if (keyMat == null) {
                throw new NullPointerException("Key material not specified");
            }
            if (keyMat.length < 24) {
                throw new InvalidKeyException("Too short material");
            }
            SecretKey key = null;
            try {
                key = this.fKeyFactory.generateSecret(new DESedeKeySpec(keyMat));
            }
            catch (InvalidKeySpecException e) {
                // empty catch block
            }
            this.fUsingKeyGenerator = false;
            return key;
        }

        public int getKeyLength(String type) {
            return 24;
        }
    }
}

