/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.EncryptionEngine;
import com.ibm.xml.enc.PseudoIOException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionOutputStream
extends FilterOutputStream {
    private EncryptionEngine fEncryptionEngine;
    private boolean fDoneFinal;
    private byte[] fOutputBuffer = new byte[1];

    public EncryptionOutputStream(OutputStream out, EncryptionEngine engine) {
        super(out);
        this.fEncryptionEngine = engine;
        if (this.fEncryptionEngine == null) {
            throw new NullPointerException("Encryption engine not specified");
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void doFinal() throws IOException {
        this.doFinal(null);
    }

    public void doFinal(byte[] b) throws IOException {
        byte[] o = null;
        try {
            o = b != null ? this.fEncryptionEngine.doFinal(b) : this.fEncryptionEngine.doFinal();
        }
        catch (BadPaddingException e) {
            throw new PseudoIOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new PseudoIOException(e);
        }
        this.fDoneFinal = true;
        if (o != null && o.length > 0) {
            this.writeBytes(o);
        }
    }

    private void writeBytes(byte[] b) throws IOException {
        this.out.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] o = this.fEncryptionEngine.update(b, off, len);
        if (o != null && o.length > 0) {
            this.writeBytes(o);
        }
    }

    public void write(int b) throws IOException {
        this.fOutputBuffer[0] = (byte)b;
        byte[] o = this.fEncryptionEngine.update(this.fOutputBuffer);
        if (o != null && o.length > 0) {
            this.writeBytes(o);
        }
    }

    public void close() throws IOException {
        if (!this.fDoneFinal) {
            this.doFinal();
        }
        super.close();
    }
}

