/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.xml.enc.AlgorithmFactoryExtn;
import com.ibm.xml.enc.KeyGenerationEngine;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.type.DigestMethod;
import com.ibm.xml.enc.type.EncryptionMethod;
import com.ibm.xml.enc.type.OAEPParams;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public abstract class EncryptionEngine {
    public static final int ENCRYPT_MODE = 1;
    public static final int DECRYPT_MODE = 2;
    public static final int WRAP_MODE = 3;
    public static final int UNWRAP_MODE = 4;
    private static SecureRandom fRandom;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$com$ibm$xml$enc$type$DigestMethod;
    static /* synthetic */ Class class$com$ibm$xml$enc$type$OAEPParams;

    public abstract EncryptionMethod getEncryptionMethod();

    public abstract Provider getProvider();

    public abstract AlgorithmParameters getParameters();

    public abstract void init(int var1, Key var2, Object var3) throws InvalidAlgorithmParameterException, InvalidKeyException;

    public abstract byte[] update(byte[] var1, int var2, int var3);

    public final byte[] update(byte[] input) {
        return this.update(input, 0, input.length);
    }

    public abstract byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException;

    public abstract byte[] doFinal(byte[] var1) throws BadPaddingException, IllegalBlockSizeException;

    public abstract byte[] wrap(Key var1) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException;

    public abstract Key unwrap(byte[] var1, EncryptionMethod var2, String var3) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException;

    static synchronized SecureRandom getRandom() {
        if (fRandom == null) {
            fRandom = new SecureRandom();
        }
        return fRandom;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class RSAOAEP
    extends RSA {
        private static final String TRANS = "RSA/ECB/OAEP";

        RSAOAEP(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider, factory, TRANS);
        }

        private Object getParameter(Class typeClass) {
            Object param = null;
            try {
                Class[] cc = new Class[]{class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = EncryptionEngine.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element};
                Method m = typeClass.getMethod("isOfType", cc);
                Constructor c = typeClass.getConstructor(cc);
                Iterator i = super.getEncryptionMethod().getParameters().iterator();
                while (param == null && i.hasNext()) {
                    Object[] oo = new Object[]{i.next()};
                    if (!((Boolean)m.invoke(null, oo)).booleanValue()) continue;
                    param = c.newInstance(oo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return param;
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            OAEPParams op;
            DigestMethod dm = (DigestMethod)this.getParameter(class$com$ibm$xml$enc$type$DigestMethod == null ? (class$com$ibm$xml$enc$type$DigestMethod = EncryptionEngine.class$("com.ibm.xml.enc.type.DigestMethod")) : class$com$ibm$xml$enc$type$DigestMethod);
            if (dm == null) {
                throw new NullPointerException("DigestMethod not specified");
            }
            String s = dm.getAlgorithm();
            if (s == null) {
                throw new NullPointerException("Algorithm not specified");
            }
            if (!s.equals("http://www.w3.org/2000/09/xmldsig#sha1")) {
                throw new InvalidAlgorithmParameterException("Unknown algorithm: " + s);
            }
            if (params == null && (op = (OAEPParams)this.getParameter(class$com$ibm$xml$enc$type$OAEPParams == null ? (class$com$ibm$xml$enc$type$OAEPParams = EncryptionEngine.class$("com.ibm.xml.enc.type.OAEPParams")) : class$com$ibm$xml$enc$type$OAEPParams)) != null) {
                byte[] bb = op.getParameters();
            }
            super.init(opMode, key, params);
        }
    }

    static class RSA15
    extends RSA {
        private static final String TRANS = "RSA";

        RSA15(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider, factory, TRANS);
        }
    }

    static abstract class RSA
    extends EncryptionEngine {
        private EncryptionMethod fEncryptionMethod;
        private AlgorithmFactoryExtn fAlgorithmFactory;
        private int fOpMode;
        private Cipher fCipher;

        RSA(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory, String trans) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            this.fAlgorithmFactory = factory;
            this.fCipher = provider != null ? Cipher.getInstance(trans, provider) : Cipher.getInstance(trans);
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            return this.fCipher.getProvider();
        }

        public AlgorithmParameters getParameters() {
            return this.fCipher.getParameters();
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            switch (opMode) {
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    opMode = 1;
                    break;
                }
                case 4: {
                    opMode = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            if (params == null) {
                this.fCipher.init(opMode, key, RSA.getRandom());
            } else if (params instanceof AlgorithmParameterSpec) {
                this.fCipher.init(opMode, key, (AlgorithmParameterSpec)params, RSA.getRandom());
            } else if (params instanceof AlgorithmParameters) {
                this.fCipher.init(opMode, key, (AlgorithmParameters)params, RSA.getRandom());
            } else {
                throw new IllegalArgumentException("Instance of unknown class: " + params.getClass().getName());
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: 
                case 2: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    output = this.fCipher.update(input, off, len);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return output;
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            return this.doFinal(null);
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: 
                case 2: {
                    if (input != null) {
                        output = this.fCipher.doFinal(input);
                        break;
                    }
                    output = this.fCipher.doFinal();
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return output;
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Material not obtained or too short");
                    }
                    wrappedKey = this.fCipher.doFinal(bb);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (wrappedKey.length == 0) {
                        throw new InvalidKeyException("Too short data");
                    }
                    byte[] bb = this.fCipher.doFinal(wrappedKey);
                    KeyGenerationEngine kge = this.fAlgorithmFactory.getKeyGenerationEngine(encMeth);
                    key = kge.generateKey(bb, type);
                    this.fAlgorithmFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return key;
        }
    }

    static class KWAES256
    extends KWAES {
        private static final int KEY_LENGTH = 32;

        KWAES256(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider, factory);
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Material not obtained");
            }
            if (bb.length != 32) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, params);
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES256.update(byte[])");
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES256.doFinal()");
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES256.doFinal(byte[])");
        }
    }

    static class KWAES192
    extends KWAES {
        private static final int KEY_LENGTH = 24;

        KWAES192(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider, factory);
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Material not obtained");
            }
            if (bb.length != 24) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, params);
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES192.update(byte[])");
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES192.doFinal()");
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES192.doFinal(byte[])");
        }
    }

    static class KWAES128
    extends KWAES {
        private static final int KEY_LENGTH = 16;

        KWAES128(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider, factory);
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Material not obtained");
            }
            if (bb.length != 16) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, params);
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES128.update(byte[])");
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES128.doFinal()");
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWAES128.doFinal(byte[])");
        }
    }

    static abstract class KWAES
    extends EncryptionEngine {
        private static final String TRANS = "AES/ECB/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private static final byte[] PADS = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
        private EncryptionMethod fEncryptionMethod;
        private AlgorithmFactoryExtn fAlgorithmFactory;
        private int fOpMode;
        private Cipher fCipher;

        KWAES(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            this.fAlgorithmFactory = factory;
            this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
        }

        private void encryptBlocks(byte[] c, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int j = 0; j <= 5; ++j) {
                for (int i = 1; i <= n; ++i) {
                    int t = i + j * n;
                    this.processBlock(c, i);
                    this.xorBlock(c, t);
                }
            }
        }

        private void decryptBlocks(byte[] p, int n) throws BadPaddingException, IllegalBlockSizeException {
            for (int j = 5; j >= 0; --j) {
                for (int i = n; i >= 1; --i) {
                    int t = i + j * n;
                    this.xorBlock(p, t);
                    this.processBlock(p, i);
                }
            }
        }

        private void processBlock(byte[] bb, int i) throws BadPaddingException, IllegalBlockSizeException {
            byte[] bb2 = new byte[16];
            System.arraycopy(bb, 0, bb2, 0, 8);
            System.arraycopy(bb, 8 * i, bb2, 8, 8);
            bb2 = this.fCipher.doFinal(bb2);
            System.arraycopy(bb2, 0, bb, 0, 8);
            System.arraycopy(bb2, 8, bb, 8 * i, 8);
        }

        private void xorBlock(byte[] bb, int t) {
            byte[] bb2 = BigInteger.valueOf(t).toByteArray();
            for (int i = 0; i < 8; ++i) {
                int j = i - 8 + bb2.length;
                int k = 0;
                if (j >= 0) {
                    k = bb2[j];
                }
                bb[i] = (byte)(k ^= bb[i]);
            }
        }

        private boolean arePadsChanged(byte[] p) {
            boolean changed = false;
            for (int i = 0; !changed && i < PADS.length; ++i) {
                if (p[i] == PADS[i]) continue;
                changed = true;
            }
            return changed;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            return this.fCipher.getProvider();
        }

        public AlgorithmParameters getParameters() {
            return this.fCipher.getParameters();
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            switch (opMode) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                case 3: {
                    this.fCipher.init(1, key, KWAES.getRandom());
                    break;
                }
                case 4: {
                    this.fCipher.init(2, key, KWAES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Material not obtained or too short");
                    }
                    if (bb.length % 8 > 0) {
                        throw new InvalidKeyException("Material not multiple of 8 bytes");
                    }
                    wrappedKey = new byte[PADS.length + bb.length];
                    System.arraycopy(PADS, 0, wrappedKey, 0, PADS.length);
                    System.arraycopy(bb, 0, wrappedKey, PADS.length, bb.length);
                    int n = bb.length / 8;
                    if (n > 1) {
                        this.encryptBlocks(wrappedKey, n);
                        break;
                    }
                    this.processBlock(wrappedKey, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (wrappedKey.length < 16) {
                        throw new InvalidKeyException("Too short data");
                    }
                    if (wrappedKey.length % 8 > 0) {
                        throw new InvalidKeyException("Data not multiple of 8 bytes");
                    }
                    byte[] bb1 = (byte[])wrappedKey.clone();
                    int n = bb1.length / 8 - 1;
                    if (n > 1) {
                        this.decryptBlocks(bb1, n);
                    } else {
                        this.processBlock(bb1, 1);
                    }
                    if (this.arePadsChanged(bb1)) {
                        throw new BadPaddingException("Wrong pads");
                    }
                    byte[] bb2 = new byte[bb1.length - 8];
                    System.arraycopy(bb1, 8, bb2, 0, bb2.length);
                    KeyGenerationEngine kge = this.fAlgorithmFactory.getKeyGenerationEngine(encMeth);
                    key = kge.generateKey(bb2, type);
                    this.fAlgorithmFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return key;
        }
    }

    static class AES256CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 32;

        AES256CBC(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider);
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Material not obtained");
            }
            if (bb.length != 32) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, params);
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$AES256CBC.wrap(java.security.Key)");
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$AES256CBC.unwrap(byte[], com.ibm.xml.enc.EncryptionMethod, java.lang.String)");
        }
    }

    static class AES192CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 24;

        AES192CBC(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider);
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Material not obtained");
            }
            if (bb.length != 24) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, params);
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$AES192CBC.wrap(java.security.Key)");
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$AES192CBC.unwrap(byte[], com.ibm.xml.enc.EncryptionMethod, java.lang.String)");
        }
    }

    static class AES128CBC
    extends AESCBC {
        private static final int KEY_LENGTH = 16;

        AES128CBC(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            super(encMeth, provider);
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            if (key == null) {
                throw new NullPointerException("Key not specified");
            }
            byte[] bb = key.getEncoded();
            if (bb == null) {
                throw new InvalidKeyException("Material not obtained");
            }
            if (bb.length != 16) {
                throw new InvalidKeyException("Wrong length: " + bb.length);
            }
            super.init(opMode, key, params);
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$AES128CBC.wrap(java.security.Key)");
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$AES128CBC.unwrap(byte[], com.ibm.xml.enc.EncryptionMethod, java.lang.String)");
        }
    }

    static abstract class AESCBC
    extends EncryptionEngine {
        private static final String TRANS = "AES/CBC/NoPadding";
        private static final int BLOCK_SIZE = 16;
        private EncryptionMethod fEncryptionMethod;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher;
        private boolean fFirstOutput;
        private int fLength;
        private byte[] fIv;
        private int fIndex;
        private boolean fInitialized;
        private byte[] fBuffer;
        private int fIndex2;

        AESCBC(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            this.fIndex = -1;
            this.fIndex2 = -1;
        }

        private byte[] addIv(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                byte[] bb = this.fCipher.getIV();
                output2 = new byte[bb.length + output.length];
                System.arraycopy(bb, 0, output2, 0, bb.length);
                System.arraycopy(output, 0, output2, bb.length, output.length);
            } else {
                output2 = this.fCipher.getIV();
            }
            return output2;
        }

        private byte[] removeIv(byte[] input, int off, int len) {
            int i = 16 - this.fIndex;
            byte[] input2 = null;
            if (i > len) {
                System.arraycopy(input, off, this.fIv, this.fIndex, len);
                this.fIndex += len;
                input2 = new byte[]{};
            } else {
                System.arraycopy(input, off, this.fIv, this.fIndex, i);
                try {
                    this.fCipher.init(this.fOpMode, this.fKey, new IvParameterSpec(this.fIv), AESCBC.getRandom());
                }
                catch (InvalidAlgorithmParameterException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                this.fIndex = -1;
                this.fInitialized = true;
                input2 = new byte[len - i];
                System.arraycopy(input, off + i, input2, 0, input2.length);
            }
            return input2;
        }

        private byte[] addPads(byte[] input) {
            int i = 16 - this.fLength % 16;
            int j = 0;
            if (input != null) {
                j += input.length;
            }
            byte[] input2 = new byte[j += i];
            if (input != null) {
                System.arraycopy(input, 0, input2, 0, input.length);
            }
            for (int k = j - i; k < j; ++k) {
                input2[k] = (byte)i;
            }
            return input2;
        }

        private byte[] bufferData(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                if (16 - this.fIndex2 >= output.length) {
                    System.arraycopy(output, 0, this.fBuffer, this.fIndex2, output.length);
                    this.fIndex2 += output.length;
                } else {
                    byte[] bb = new byte[this.fIndex2 + output.length];
                    System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
                    System.arraycopy(output, 0, bb, this.fIndex2, output.length);
                    output2 = new byte[bb.length - 16];
                    System.arraycopy(bb, 0, output2, 0, output2.length);
                    System.arraycopy(bb, output2.length, this.fBuffer, 0, 16);
                    this.fIndex2 = 16;
                }
            }
            return output2;
        }

        private byte[] removePads(byte[] output) throws BadPaddingException {
            int i = 0;
            if (output != null) {
                i += output.length;
            }
            byte[] bb = new byte[this.fIndex2 + i];
            System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
            if (output != null) {
                System.arraycopy(output, 0, bb, this.fIndex2, output.length);
            }
            this.fIndex2 = -1;
            if (bb.length == 0) {
                throw new BadPaddingException("No pads");
            }
            int j = bb[bb.length - 1] & 0xFF;
            if (j <= 0 || j > 16) {
                throw new BadPaddingException("Wrong number: " + j);
            }
            if (j > bb.length) {
                throw new BadPaddingException("Fewer pads");
            }
            byte[] output2 = null;
            if (j < bb.length) {
                output2 = new byte[bb.length - j];
                System.arraycopy(bb, 0, output2, 0, output2.length);
            }
            return output2;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            return this.fCipher.getProvider();
        }

        public AlgorithmParameters getParameters() {
            return this.fCipher.getParameters();
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: {
                    if (params == null) {
                        this.fCipher.init(opMode, key, AESCBC.getRandom());
                    } else if (params instanceof AlgorithmParameterSpec) {
                        this.fCipher.init(opMode, key, (AlgorithmParameterSpec)params, AESCBC.getRandom());
                    } else if (params instanceof AlgorithmParameters) {
                        this.fCipher.init(opMode, key, (AlgorithmParameters)params, AESCBC.getRandom());
                    } else {
                        throw new IllegalArgumentException("Instance of unknown class: " + params.getClass().getName());
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    this.fIv = new byte[16];
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fBuffer = new byte[16];
                    this.fIndex2 = 0;
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    output = this.fCipher.update(input, off, len);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                        this.fFirstOutput = false;
                    }
                    this.fLength += len;
                    break;
                }
                case 2: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (!this.fInitialized) {
                        input = this.removeIv(input, off, len);
                        off = 0;
                        len = input.length;
                    }
                    if (!this.fInitialized) break;
                    output = this.fCipher.update(input, off, len);
                    output = this.bufferData(output);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return output;
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            return this.doFinal(null);
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input != null) {
                        this.fLength += input.length;
                    }
                    input = this.addPads(input);
                    output = this.fCipher.doFinal(input);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    if (input != null) {
                        if (!this.fInitialized) {
                            input = this.removeIv(input, 0, input.length);
                        }
                        output = this.fCipher.doFinal(input);
                    } else {
                        output = this.fCipher.doFinal();
                    }
                    output = this.removePads(output);
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fIndex2 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return output;
        }
    }

    static class KWTripleDES
    extends EncryptionEngine {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final byte[] IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
        private EncryptionMethod fEncryptionMethod;
        private AlgorithmFactoryExtn fAlgorithmFactory;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher0;
        private Cipher fCipher1;

        KWTripleDES(EncryptionMethod encMeth, String provider, AlgorithmFactoryExtn factory) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            this.fAlgorithmFactory = factory;
            if (provider != null) {
                this.fCipher0 = Cipher.getInstance(TRANS, provider);
                this.fCipher1 = Cipher.getInstance(TRANS, provider);
            } else {
                this.fCipher0 = Cipher.getInstance(TRANS);
                this.fCipher1 = Cipher.getInstance(TRANS);
            }
        }

        private byte[] addChecksum(byte[] wk) throws NoSuchAlgorithmException, NoSuchProviderException {
            MessageDigest md = this.fAlgorithmFactory.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] bb = md.digest(wk);
            this.fAlgorithmFactory.releaseDigestMethod(md, "http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] wkcks = new byte[wk.length + 8];
            System.arraycopy(wk, 0, wkcks, 0, wk.length);
            System.arraycopy(bb, 0, wkcks, wk.length, 8);
            return wkcks;
        }

        private byte[] addIv(byte[] temp1) {
            byte[] bb = this.fCipher0.getIV();
            byte[] temp2 = new byte[temp1.length + 8];
            System.arraycopy(bb, 0, temp2, 0, 8);
            System.arraycopy(temp1, 0, temp2, 8, temp1.length);
            return temp2;
        }

        private byte[] reverse(byte[] temp2) {
            byte[] temp3 = new byte[temp2.length];
            for (int i = 0; i < temp2.length; ++i) {
                temp3[temp3.length - i - 1] = temp2[i];
            }
            return temp3;
        }

        private boolean isUnreasonable(int length, KeyGenerationEngine engine, String type) {
            return length != engine.getKeyLength(type) + 16;
        }

        private byte[] removeIv(byte[] temp2) {
            byte[] bb = new byte[8];
            byte[] temp1 = new byte[temp2.length - 8];
            System.arraycopy(temp2, 0, bb, 0, 8);
            System.arraycopy(temp2, 8, temp1, 0, temp1.length);
            try {
                this.fCipher0.init(2, this.fKey, new IvParameterSpec(bb), KWTripleDES.getRandom());
            }
            catch (InvalidAlgorithmParameterException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            return temp1;
        }

        private byte[] removeChecksum(byte[] wkcks) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            byte[] wk = new byte[wkcks.length - 8];
            byte[] bb = new byte[8];
            System.arraycopy(wkcks, 0, wk, 0, wk.length);
            System.arraycopy(wkcks, wk.length, bb, 0, 8);
            MessageDigest md = this.fAlgorithmFactory.getDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
            byte[] bb1 = md.digest(wk);
            this.fAlgorithmFactory.releaseDigestMethod(md, "http://www.w3.org/2000/09/xmldsig#sha1");
            for (int i = 0; i < 8; ++i) {
                if (bb[i] == bb1[i]) continue;
                throw new InvalidKeyException("Wrong checksum");
            }
            return wk;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            return this.fCipher0.getProvider();
        }

        public AlgorithmParameters getParameters() {
            return this.fCipher0.getParameters();
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: 
                case 2: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher0.init(1, key, KWTripleDES.getRandom());
                    this.fCipher1.init(1, key, new IvParameterSpec(IV), KWTripleDES.getRandom());
                    break;
                }
                case 4: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    this.fCipher1.init(2, key, new IvParameterSpec(IV), KWTripleDES.getRandom());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWTripleDES.update(byte[])");
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWTripleDES.doFinal()");
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$KWTripleDES.doFinal(byte[])");
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            byte[] wrappedKey = null;
            switch (this.fOpMode) {
                case 3: {
                    if (key == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    byte[] bb = key.getEncoded();
                    if (bb == null || bb.length == 0) {
                        throw new InvalidKeyException("Material not obtained or too short");
                    }
                    bb = this.addChecksum(bb);
                    bb = this.fCipher0.doFinal(bb);
                    bb = this.addIv(bb);
                    bb = this.reverse(bb);
                    wrappedKey = this.fCipher1.doFinal(bb);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return wrappedKey;
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            Key key = null;
            switch (this.fOpMode) {
                case 4: {
                    if (wrappedKey == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    KeyGenerationEngine kge = this.fAlgorithmFactory.getKeyGenerationEngine(encMeth);
                    if (this.isUnreasonable(wrappedKey.length, kge, type)) {
                        this.fAlgorithmFactory.releaseKeyGenerationEngine(kge);
                        throw new InvalidKeyException("Wrong length: " + wrappedKey.length);
                    }
                    byte[] bb = this.fCipher1.doFinal(wrappedKey);
                    bb = this.reverse(bb);
                    bb = this.removeIv(bb);
                    bb = this.fCipher0.doFinal(bb);
                    bb = this.removeChecksum(bb);
                    key = kge.generateKey(bb, type);
                    this.fAlgorithmFactory.releaseKeyGenerationEngine(kge);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return key;
        }
    }

    static class TripleDESCBC
    extends EncryptionEngine {
        private static final String TRANS = "DESede/CBC/NoPadding";
        private static final int BLOCK_SIZE = 8;
        private EncryptionMethod fEncryptionMethod;
        private int fOpMode;
        private Key fKey;
        private Cipher fCipher;
        private boolean fFirstOutput;
        private int fLength;
        private byte[] fIv;
        private int fIndex;
        private boolean fInitialized;
        private byte[] fBuffer;
        private int fIndex2;

        TripleDESCBC(EncryptionMethod encMeth, String provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
            this.fEncryptionMethod = encMeth;
            this.fCipher = provider != null ? Cipher.getInstance(TRANS, provider) : Cipher.getInstance(TRANS);
            this.fIndex = -1;
            this.fIndex2 = -1;
        }

        private byte[] addIv(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                byte[] bb = this.fCipher.getIV();
                output2 = new byte[bb.length + output.length];
                System.arraycopy(bb, 0, output2, 0, bb.length);
                System.arraycopy(output, 0, output2, bb.length, output.length);
            } else {
                output2 = this.fCipher.getIV();
            }
            return output2;
        }

        private byte[] removeIv(byte[] input, int off, int len) {
            int i = 8 - this.fIndex;
            byte[] input2 = null;
            if (i > len) {
                System.arraycopy(input, off, this.fIv, this.fIndex, len);
                this.fIndex += len;
                input2 = new byte[]{};
            } else {
                System.arraycopy(input, off, this.fIv, this.fIndex, i);
                if (this.fKey == null) {
                    throw new NullPointerException("Key not specified");
                }
                try {
                    this.fCipher.init(this.fOpMode, this.fKey, new IvParameterSpec(this.fIv), TripleDESCBC.getRandom());
                }
                catch (InvalidAlgorithmParameterException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                catch (InvalidKeyException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
                this.fIndex = -1;
                this.fInitialized = true;
                input2 = new byte[len - i];
                System.arraycopy(input, off + i, input2, 0, input2.length);
            }
            return input2;
        }

        private byte[] addPads(byte[] input) {
            int i = 8 - this.fLength % 8;
            int j = 0;
            if (input != null) {
                j += input.length;
            }
            byte[] input2 = new byte[j += i];
            if (input != null) {
                System.arraycopy(input, 0, input2, 0, input.length);
            }
            for (int k = j - i; k < j; ++k) {
                input2[k] = (byte)i;
            }
            return input2;
        }

        private byte[] bufferData(byte[] output) {
            byte[] output2 = null;
            if (output != null && output.length > 0) {
                if (8 - this.fIndex2 >= output.length) {
                    System.arraycopy(output, 0, this.fBuffer, this.fIndex2, output.length);
                    this.fIndex2 += output.length;
                } else {
                    byte[] bb = new byte[this.fIndex2 + output.length];
                    System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
                    System.arraycopy(output, 0, bb, this.fIndex2, output.length);
                    output2 = new byte[bb.length - 8];
                    System.arraycopy(bb, 0, output2, 0, output2.length);
                    System.arraycopy(bb, output2.length, this.fBuffer, 0, 8);
                    this.fIndex2 = 8;
                }
            }
            return output2;
        }

        private byte[] removePads(byte[] output) throws BadPaddingException {
            int i = 0;
            if (output != null) {
                i += output.length;
            }
            byte[] bb = new byte[this.fIndex2 + i];
            System.arraycopy(this.fBuffer, 0, bb, 0, this.fIndex2);
            if (output != null) {
                System.arraycopy(output, 0, bb, this.fIndex2, output.length);
            }
            this.fIndex2 = -1;
            if (bb.length == 0) {
                throw new BadPaddingException("No pads");
            }
            int j = bb[bb.length - 1] & 0xFF;
            if (j <= 0 || j > 8) {
                throw new BadPaddingException("Wrong number: " + j);
            }
            if (j > bb.length) {
                throw new BadPaddingException("Fewer pads");
            }
            byte[] output2 = null;
            if (j < bb.length) {
                output2 = new byte[bb.length - j];
                System.arraycopy(bb, 0, output2, 0, output2.length);
            }
            return output2;
        }

        public EncryptionMethod getEncryptionMethod() {
            return this.fEncryptionMethod;
        }

        public Provider getProvider() {
            return this.fCipher.getProvider();
        }

        public AlgorithmParameters getParameters() {
            return this.fCipher.getParameters();
        }

        public void init(int opMode, Key key, Object params) throws InvalidAlgorithmParameterException, InvalidKeyException {
            this.fOpMode = opMode;
            this.fKey = key;
            switch (opMode) {
                case 1: {
                    if (key == null) {
                        throw new NullPointerException("Key not specified");
                    }
                    if (params == null) {
                        this.fCipher.init(opMode, key, TripleDESCBC.getRandom());
                    } else if (params instanceof AlgorithmParameterSpec) {
                        this.fCipher.init(opMode, key, (AlgorithmParameterSpec)params, TripleDESCBC.getRandom());
                    } else if (params instanceof AlgorithmParameters) {
                        this.fCipher.init(opMode, key, (AlgorithmParameters)params, TripleDESCBC.getRandom());
                    } else {
                        throw new IllegalArgumentException("Instance of unknown class: " + params.getClass().getName());
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    this.fIv = new byte[8];
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fBuffer = new byte[8];
                    this.fIndex2 = 0;
                    break;
                }
                case 3: 
                case 4: {
                    throw new IllegalArgumentException("Unsupported operation mode: " + opMode);
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation mode: " + opMode);
                }
            }
        }

        public byte[] update(byte[] input, int off, int len) {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    output = this.fCipher.update(input, off, len);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                        this.fFirstOutput = false;
                    }
                    this.fLength += len;
                    break;
                }
                case 2: {
                    if (input == null) {
                        throw new NullPointerException("Data not specified");
                    }
                    if (!this.fInitialized) {
                        input = this.removeIv(input, off, len);
                        off = 0;
                        len = input.length;
                    }
                    if (!this.fInitialized) break;
                    output = this.fCipher.update(input, off, len);
                    output = this.bufferData(output);
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return output;
        }

        public byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
            return this.doFinal(null);
        }

        public byte[] doFinal(byte[] input) throws BadPaddingException, IllegalBlockSizeException {
            byte[] output = null;
            switch (this.fOpMode) {
                case 1: {
                    if (input != null) {
                        this.fLength += input.length;
                    }
                    input = this.addPads(input);
                    output = this.fCipher.doFinal(input);
                    if (this.fFirstOutput) {
                        output = this.addIv(output);
                    }
                    this.fFirstOutput = true;
                    this.fLength = 0;
                    break;
                }
                case 2: {
                    if (input != null) {
                        if (!this.fInitialized) {
                            input = this.removeIv(input, 0, input.length);
                        }
                        output = this.fCipher.doFinal(input);
                    } else {
                        output = this.fCipher.doFinal();
                    }
                    output = this.removePads(output);
                    this.fIndex = 0;
                    this.fInitialized = false;
                    this.fIndex2 = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Encryption engine not initialized");
                }
            }
            return output;
        }

        public byte[] wrap(Key key) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$TripleDESCBC.wrap(java.security.Key)");
        }

        public Key unwrap(byte[] wrappedKey, EncryptionMethod encMeth, String type) throws BadPaddingException, IllegalBlockSizeException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, StructureException {
            throw new UnsupportedOperationException("Unsupported method: com.ibm.xml.enc.EncryptionEngine$TripleDESCBC.unwrap(byte[], com.ibm.xml.enc.EncryptionMethod, java.lang.String)");
        }
    }
}

