/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.enc;

import com.ibm.dom.util.Serializer;
import com.ibm.xml.enc.util.DOMUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DOMSerializationEngine {
    public abstract String getType();

    public abstract void setOutputStream(OutputStream var1);

    public abstract void serialize(NodeList var1) throws IOException;

    private static Throwable unwrapException(TransformerException exc) {
        Throwable thr = exc.getException();
        if (thr == null) {
            thr = exc;
        }
        return thr;
    }

    static class XMLElement
    extends XMLContent {
        XMLElement() {
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Element";
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                Element n = DOMUtil.getFirstElement(nodeList);
                DOMUtil.NodeListImpl nl = new DOMUtil.NodeListImpl();
                if (n != null) {
                    nl.add(n);
                }
                nodeList = nl;
            }
            super.serialize(nodeList);
        }
    }

    static class XMLContent
    extends DOMSerializationEngine {
        private Writer fOut;

        XMLContent() {
        }

        public String getType() {
            return "http://www.w3.org/2001/04/xmlenc#Content";
        }

        public void setOutputStream(OutputStream out) {
            try {
                this.fOut = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("Internal Error: " + uee.toString());
            }
        }

        public void serialize(NodeList nodeList) throws IOException {
            if (nodeList != null) {
                int l = nodeList.getLength();
                for (int i = 0; i < l; ++i) {
                    Serializer.serializeNode(nodeList.item(i), this.fOut);
                }
                this.fOut.flush();
            }
        }
    }
}

