/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.util;

import com.ibm.xml.dsig.IDResolver;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AdHocIDResolver
implements IDResolver {
    Vector docs = new Vector();
    Vector hashes = new Vector();

    public AdHocIDResolver(Document doc) {
        this.registerDocument(doc);
    }

    private Hashtable searchFor(Document doc) {
        for (int i = 0; i < this.docs.size(); ++i) {
            Object elem = this.docs.elementAt(i);
            if (elem != doc) continue;
            return (Hashtable)this.hashes.elementAt(i);
        }
        return null;
    }

    private Hashtable registerDocument(Document doc) {
        this.docs.addElement(doc);
        Hashtable hash = new Hashtable();
        this.hashes.addElement(hash);
        AdHocIDResolver.traverseNode(hash, doc.getDocumentElement());
        return hash;
    }

    private static void traverseNode(Hashtable hash, Node node) {
        if (node.getNodeType() == 1) {
            NamedNodeMap map = node.getAttributes();
            for (int i = 0; i < map.getLength(); ++i) {
                Attr a = (Attr)map.item(i);
                if (!"id".equalsIgnoreCase(a.getLocalName()) && !"id".equalsIgnoreCase(a.getNodeName())) continue;
                hash.put(a.getNodeValue(), node);
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            AdHocIDResolver.traverseNode(hash, child);
        }
    }

    public Element resolveID(Document doc, String id) {
        Element ret = doc.getElementById(id);
        if (ret != null) {
            return ret;
        }
        Hashtable hash = this.searchFor(doc);
        if (hash == null) {
            hash = this.registerDocument(doc);
        }
        ret = (Element)hash.get(id);
        return ret;
    }
}

