/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLTTransformer
extends Transform {
    private static final boolean DEBUG = false;
    public static final String URI = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    Document styledoc = null;

    public void setParameter(Node node) {
        Document doc;
        if (node == null) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent != null && parent.getNodeType() == 9) {
            this.styledoc = (Document)parent;
            return;
        }
        if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && node.getLocalName().equals("XSLT")) {
            node = DOMUtil.getFirstChildElement(node);
        }
        if (node == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            doc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce.getMessage());
        }
        Element newRoot = (Element)doc.importNode(node, true);
        Hashtable namespaces = XPathCanonicalizer.collectNamespaceNodesInAncestors(node, false);
        Enumeration enumeration = namespaces.elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            if (attr.getNodeName().equals("xmlns:xml")) continue;
            newRoot.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
        }
        doc.appendChild(newRoot);
        this.styledoc = doc;
    }

    private static void print(Node node) {
    }

    public void setParameter(Document doc) {
        this.styledoc = doc;
    }

    public String getURI() {
        return URI;
    }

    public void transform(TransformContext context) throws TransformException {
        if (this.styledoc == null) {
            throw new TransformException("No prameter element.");
        }
        try {
            Document node = context.getDocument();
            XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(node);
            XPathCanonicalizer.copyNamespaceNodesInAncestorsRecursively(this.styledoc);
            XSLTTransformer.print(this.styledoc);
            TransformerFactory trf = TransformerFactory.newInstance();
            Transformer tr = trf.newTransformer(new DOMSource(this.styledoc));
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            tr.transform(new DOMSource(node), new StreamResult(baos));
            context.setContent(baos.toByteArray(), null);
        }
        catch (TransformerException tre) {
            throw TransformException.create(tre);
        }
    }

    public Element createTransformElement(Document factory, IndentConfig iconf) {
        Element trElement = super.createTransformElement(factory, iconf);
        DOMUtil.addIndent(trElement, iconf, 0);
        trElement.appendChild(factory.importNode(this.styledoc.getDocumentElement(), true));
        DOMUtil.addIndent(trElement, iconf, 4);
        return trElement;
    }
}

