/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.transform.Enveloped;
import com.ibm.xml.dsig.transform.XPathTransformer;
import com.ibm.xml.dsig.util.XPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class XPath2Transformer
extends Transform {
    private static final int FILTER_INVALID = -1;
    private static final int FILTER_UNION = 1;
    private static final int FILTER_SUBTRACT = 2;
    private static final int FILTER_INTERSECT = 3;
    private List xpathNodes;

    public String getURI() {
        return "http://www.w3.org/2002/06/xmldsig-filter2";
    }

    public void setParameter(Node node) {
        Vector<Node> v = new Vector<Node>();
        while (node != null) {
            v.addElement(node);
            node = DOMUtil.getNextElement(node);
        }
        this.xpathNodes = v;
    }

    public void transform(TransformContext context) throws TransformException {
        NodeList nodeSet = context.getNodeset();
        int inputSize = nodeSet.getLength();
        if (inputSize <= 0) {
            return;
        }
        Node input = nodeSet.item(0);
        Document doc = input instanceof Document ? (Document)input : input.getOwnerDocument();
        int xpathSize = this.xpathNodes.size();
        List[] iterators = new List[xpathSize + 1];
        int[] filters = new int[xpathSize + 1];
        iterators[0] = Collections.singletonList(doc);
        filters[0] = 1;
        FunctionTable.installFunction((String)"here", (Expression)new XPathTransformer.FuncHere());
        Iterator xiter = this.xpathNodes.iterator();
        int i = 1;
        while (xiter.hasNext()) {
            Node xpathNode = (Node)xiter.next();
            iterators[i] = XPath2Transformer.eval(xpathNode, doc, context);
            filters[i] = XPath2Transformer.getFilter(xpathNode);
            if (filters[i] == -1) {
                throw new TransformException("XPath element has no valid Filter attribute.");
            }
            ++i;
        }
        XPathCanonicalizer.NodeListImpl output = new XPathCanonicalizer.NodeListImpl();
        block1: for (int i2 = 0; i2 < inputSize; ++i2) {
            input = nodeSet.item(i2);
            for (int j = 0; j < filters.length; ++j) {
                if (filters[j] != 1 || !XPath2Transformer.contain(iterators[j], input)) continue;
                boolean z = true;
                for (int k = j + 1; k < filters.length; ++k) {
                    if (filters[k] == 1) continue;
                    if (filters[k] == 3) {
                        if (XPath2Transformer.contain(iterators[k], input)) continue;
                        z = false;
                        break;
                    }
                    if (filters[k] != 2 || !XPath2Transformer.contain(iterators[k], input)) continue;
                    z = false;
                    break;
                }
                if (!z) continue;
                output.add(input);
                continue block1;
            }
        }
        context.setContent(output);
    }

    private static int getFilter(Node xpath) {
        String v = ((Element)xpath).getAttribute("Filter");
        if ("union".equals(v)) {
            return 1;
        }
        if ("subtract".equals(v)) {
            return 2;
        }
        if ("intersect".equals(v)) {
            return 3;
        }
        return -1;
    }

    private static boolean contain(List list, Node n) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Node m = (Node)iter.next();
            if (m != n && !Enveloped.isAncestorOrSelf(n, m)) continue;
            return true;
        }
        return false;
    }

    private static List eval(Node xp2, Document start, TransformContext context) throws TransformException {
        Node n;
        NodeIterator iter;
        XPathUtil.XPathContextWithIR xcontext = new XPathUtil.XPathContextWithIR(xp2, context.getIDResolver());
        PrefixResolverDefault presolver = new PrefixResolverDefault(xp2);
        String exp = DOMUtil.getStringValue(xp2);
        try {
            XPath xpath = new XPath(exp, null, (PrefixResolver)presolver, 0);
            XObject xobj = xpath.execute((XPathContext)xcontext, (Node)start, (PrefixResolver)presolver);
            if (xobj.getType() != 4) {
                throw new TransformException("The result of xpath evaluation for '" + exp + "' is not a nodeset: " + xobj.getTypeString());
            }
            iter = xobj.nodeset();
        }
        catch (TransformerException tre) {
            throw new TransformException("Error occured in an XPath evaluation: " + tre.getMessage());
        }
        ArrayList<Node> result = new ArrayList<Node>();
        while ((n = iter.nextNode()) != null) {
            result.add(n);
        }
        return result;
    }

    public Element createTransformElement(Document factory, IndentConfig iconf) {
        throw new RuntimeException("Not supported.");
    }
}

