/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.dsig.transform.Canonicalizer;
import com.ibm.xml.dsig.transform.DecryptionTransformer;
import com.ibm.xml.enc.DecryptionContext;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.util.DOMUtil;
import com.ibm.xml.enc.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDecryptionTransformer2
extends DecryptionTransformer {
    private NodeList decryptXML(NodeList nodeSet, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        Map m = this.decryptNodeSet(nodeSet, context);
        byte[] bb = Canonicalizer.serializeSubset(nodeSet, false, m);
        Document d = this.parseOctets(bb, context);
        return XPathCanonicalizer.toNodeset(d, null, true);
    }

    private Map decryptNodeSet(NodeList nodeSet, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        HashMap<Node, NodeList> nodeSets = new HashMap<Node, NodeList>();
        int l = nodeSet.getLength();
        for (int i = 0; i < l; ++i) {
            Node n = nodeSet.item(i);
            if (!this.isEncryptedData(n)) continue;
            NodeList nl = this.decryptEncryptedData((Element)n, context);
            nodeSets.put(n, nl);
            Map m = this.decryptNodeSet(nl, context);
            nodeSets.putAll(m);
        }
        return nodeSets;
    }

    private NodeList decryptEncryptedData(Element encData, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, TransformException, XSignatureException {
        byte[] bb = this.decryptEncryptedData(encData);
        bb = DecryptionContext.wrapData(bb, encData);
        Document d = this.parseOctets(bb, context);
        Element e = d.getDocumentElement();
        return this.convertToNodeSet(e.getChildNodes());
    }

    private byte[] decryptEncryptedData(Element encData) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, StructureException, XSignatureException {
        DecryptionContext dc = this.createDecryptionContext();
        dc.setEncryptedType(encData, null, null, null);
        dc.decrypt();
        String s = dc.getType();
        if (s == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!s.equals("http://www.w3.org/2001/04/xmlenc#Element") && !s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            throw new StructureException("Unknown type: " + s);
        }
        return Util.getBytes((InputStream)dc.getData());
    }

    private Document parseOctets(byte[] octets, TransformContext context) throws TransformException {
        context.setContent(octets, "UTF-8");
        return context.getDocument();
    }

    private NodeList convertToNodeSet(NodeList apexNodes) {
        DOMUtil.NodeListImpl nodeSet = new DOMUtil.NodeListImpl();
        int l = apexNodes.getLength();
        for (int i = 0; i < l; ++i) {
            NodeList nl = XPathCanonicalizer.toNodeset(apexNodes.item(i), null, true);
            int l2 = nl.getLength();
            for (int j = 0; j < l2; ++j) {
                nodeSet.add(nl.item(j));
            }
        }
        return nodeSet;
    }

    public String getURI() {
        return "http://www.w3.org/2002/07/decrypt#XML";
    }

    public void transform(TransformContext context) throws TransformException {
        NodeList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset(context.getDocument(), null, true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        if (nl != null) {
            try {
                nl = this.decryptXML(nl, context);
            }
            catch (TransformException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exception e2;
                if (e instanceof XSignatureException && (e2 = ((XSignatureException)e).getException()) != null) {
                    e = e2;
                }
                e.printStackTrace();
                throw new TransformException(e.getMessage());
            }
        }
        context.setContent(nl);
    }
}

