/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.XPathCanonicalizer;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.dsig.transform.DecryptionTransformer;
import com.ibm.xml.enc.DecryptionContext;
import com.ibm.xml.enc.KeyInfoResolvingException;
import com.ibm.xml.enc.StructureException;
import com.ibm.xml.enc.util.DOMUtil;
import com.ibm.xml.enc.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDecryptionTransformer
extends DecryptionTransformer {
    private boolean fReplace;
    private boolean fContinue;
    private Set fFailedEncryptedData = new HashSet();

    public void setReplaceEncryptedData(boolean replace) {
        this.fReplace = replace;
    }

    public void setContinueProcessing(boolean cont) {
        this.fContinue = cont;
    }

    private boolean containsEncryptedData(NodeList nodeSet) throws StructureException {
        return this.getIndexOfEncryptedData(nodeSet) >= 0;
    }

    private NodeList cloneNodeSet(NodeList nodeSet, TransformContext context) throws TransformException {
        byte[] bb = XPathCanonicalizer.serializeSubset(nodeSet, true);
        bb = DecryptionContext.wrapData(bb, nodeSet.item(0));
        Element e = this.parseOctets(bb, context).getDocumentElement();
        return this.convertToNodeSet(e.getChildNodes());
    }

    private NodeList decryptIncludedNodes(NodeList nodeSet, TransformContext context) throws Exception {
        while (true) {
            if (!this.isSingleRooted(nodeSet)) {
                throw new TransformException("Not single-rooted node-set");
            }
            int i = this.getIndexOfEncryptedData(nodeSet);
            if (i < 0) break;
            try {
                nodeSet = this.decrypt(nodeSet, i, context);
            }
            catch (Exception e) {
                if (!this.fContinue) {
                    throw e;
                }
                e = this.getInnerException(e);
                e.printStackTrace();
                this.fFailedEncryptedData.add(nodeSet.item(i));
            }
        }
        return nodeSet;
    }

    private boolean isSingleRooted(NodeList nodeSet) {
        boolean single = true;
        if (nodeSet.getLength() > 0) {
            Node n = nodeSet.item(0);
            int l = nodeSet.getLength();
            for (int i = 1; i < l; ++i) {
                if (DOMUtil.isDescendantNode(nodeSet.item(i), n)) continue;
                single = false;
                break;
            }
        }
        return single;
    }

    private int getIndexOfEncryptedData(NodeList nodeSet) throws StructureException {
        int index = -1;
        int l = nodeSet.getLength();
        for (int i = 0; i < l; ++i) {
            if (!this.isEncryptedData(nodeSet.item(i))) continue;
            index = i;
            break;
        }
        return index;
    }

    boolean isEncryptedData(Node node) throws StructureException {
        return super.isEncryptedData(node) && !this.fFailedEncryptedData.contains(node);
    }

    private NodeList decrypt(NodeList nodeSet, int index, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException {
        int i = this.getIndexOfNextNode(nodeSet, index);
        NodeList nl = this.getSubNodeSet(nodeSet, index, i);
        nl = this.decryptEncryptedData(nl, index == 0, context);
        return this.replaceSubNodeSet(nodeSet, index, i, nl);
    }

    private int getIndexOfNextNode(NodeList nodeSet, int index) {
        int index2;
        Node n = nodeSet.item(index);
        int l = nodeSet.getLength();
        for (index2 = index + 1; index2 < l && DOMUtil.isDescendantNode(nodeSet.item(index2), n); ++index2) {
        }
        return index2;
    }

    private NodeList getSubNodeSet(NodeList nodeSet, int start, int end) {
        DOMUtil.NodeListImpl nodeSet2 = new DOMUtil.NodeListImpl();
        for (int i = start; i < end; ++i) {
            nodeSet2.add(nodeSet.item(i));
        }
        return nodeSet2;
    }

    private NodeList decryptEncryptedData(NodeList nodeSet, boolean firstNode, TransformContext context) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, TransformException, XSignatureException {
        byte[] bb = XPathCanonicalizer.serializeSubset(nodeSet, false);
        bb = this.decryptEncryptedData(bb, firstNode);
        bb = DecryptionContext.wrapData(bb, nodeSet.item(0));
        Element e = this.parseOctets(bb, context).getDocumentElement();
        e = (Element)nodeSet.item(0).getOwnerDocument().importNode(e, true);
        return this.convertToNodeSet(e.getChildNodes());
    }

    private byte[] decryptEncryptedData(byte[] encData, boolean firstNode) throws BadPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException, KeyInfoResolvingException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, ParserConfigurationException, SAXException, StructureException, XSignatureException {
        DecryptionContext dc = this.createDecryptionContext();
        dc.setEncryptedType(new ByteArrayInputStream(encData), null, null, null);
        dc.decrypt();
        String s = dc.getType();
        if (s == null) {
            throw new StructureException("Type attribute not specified");
        }
        if (!s.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            if (s.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
                if (firstNode) {
                    throw new StructureException("Wrong type: " + s);
                }
            } else {
                throw new StructureException("Unknown type: " + s);
            }
        }
        return Util.getBytes((InputStream)dc.getData());
    }

    private Document parseOctets(byte[] octets, TransformContext context) throws TransformException {
        context.setContent(octets, "UTF-8");
        return context.getDocument();
    }

    private NodeList convertToNodeSet(NodeList apexNodes) {
        DOMUtil.NodeListImpl nodeSet = new DOMUtil.NodeListImpl();
        int l = apexNodes.getLength();
        for (int i = 0; i < l; ++i) {
            NodeList nl = XPathCanonicalizer.toNodeset(apexNodes.item(i), null, true);
            int l2 = nl.getLength();
            for (int j = 0; j < l2; ++j) {
                nodeSet.add(nl.item(j));
            }
        }
        return nodeSet;
    }

    private NodeList replaceSubNodeSet(NodeList nodeSet, int start, int end, NodeList subNodeSet) {
        int i;
        DOMUtil.NodeListImpl nodeSet2 = new DOMUtil.NodeListImpl();
        for (i = 0; i < start; ++i) {
            nodeSet2.add(nodeSet.item(i));
        }
        int l = subNodeSet.getLength();
        for (i = 0; i < l; ++i) {
            nodeSet2.add(subNodeSet.item(i));
        }
        l = nodeSet.getLength();
        for (i = end; i < l; ++i) {
            nodeSet2.add(nodeSet.item(i));
        }
        Node c = nodeSet.item(start);
        Node p = c.getParentNode();
        if (p != null) {
            Node c1 = subNodeSet.item(0);
            Node c2 = c1.getNextSibling();
            p.replaceChild(c1, c);
            c = c1.getNextSibling();
            c1 = c2;
            while (c1 != null) {
                c2 = c1.getNextSibling();
                p.insertBefore(c1, c);
                c1 = c2;
            }
        }
        return nodeSet2;
    }

    private Exception getInnerException(Exception exc) {
        Exception e;
        if (exc instanceof SAXException) {
            Exception e2 = ((SAXException)exc).getException();
            if (e2 != null) {
                exc = e2;
            }
        } else if (exc instanceof XSignatureException && (e = ((XSignatureException)exc).getException()) != null) {
            exc = e;
        }
        return exc;
    }

    public String getURI() {
        return "http://www.w3.org/2001/04/decrypt#";
    }

    public void transform(TransformContext context) throws TransformException {
        NodeList nl = null;
        switch (context.getType()) {
            case 0: 
            case 1: {
                nl = XPathCanonicalizer.toNodeset(context.getDocument(), null, true);
                break;
            }
            case 3: {
                nl = XPathCanonicalizer.toNodeset(context.getNode(), null, true);
                break;
            }
            case 2: {
                nl = context.getNodeset();
            }
        }
        if (nl != null) {
            if (!this.isSingleRooted(nl)) {
                throw new TransformException("Not single-rooted node-set");
            }
            try {
                if (this.containsEncryptedData(nl)) {
                    if (!this.fReplace) {
                        nl = this.cloneNodeSet(nl, context);
                    }
                    nl = this.decryptIncludedNodes(nl, context);
                }
            }
            catch (TransformException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                e = this.getInnerException(e);
                e.printStackTrace();
                throw new TransformException(e.getMessage());
            }
        }
        context.setContent(nl);
    }
}

