/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig.transform;

import com.ibm.dom.util.ExclusiveCanonicalizer;
import com.ibm.xml.dsig.Canonicalizer;
import com.ibm.xml.dsig.Transform;
import com.ibm.xml.dsig.TransformContext;
import com.ibm.xml.dsig.TransformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExclusiveC11r
extends Transform
implements Canonicalizer {
    boolean wc = false;
    Hashtable prefixList = null;
    public static final String NS = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public void setParameter(Node node) {
        if (node == null) {
            this.prefixList = null;
            return;
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("The parameter must be an element.");
        }
        Element inp = (Element)node;
        if (inp.getNamespaceURI() == null || !inp.getNamespaceURI().equals(NS)) {
            throw new IllegalArgumentException("The parameter must belong to the 'http://www.w3.org/2001/10/xml-exc-c14n#' namespace.");
        }
        if (!inp.getLocalName().equals("InclusiveNamespaces")) {
            throw new IllegalArgumentException("The parameter element must be 'InclusiveNamespaces'.");
        }
        String v = inp.getAttribute("PrefixList");
        this.prefixList = ExclusiveCanonicalizer.parsePrefixList(v);
    }

    public String getURI() {
        return NS;
    }

    public String getType() {
        return null;
    }

    public String getCharset() {
        return null;
    }

    public void transform(TransformContext context) throws TransformException {
        switch (context.getType()) {
            case 0: 
            case 1: {
                byte[] result = ExclusiveCanonicalizer.serializeAll(this.prefixList, context.getDocument(), this.wc);
                context.setContent(result, "UTF-8");
                break;
            }
            case 3: {
                byte[] result = ExclusiveCanonicalizer.serializeSubset(this.prefixList, context.getNode(), this.wc);
                context.setContent(result, "UTF-8");
                break;
            }
            case 2: {
                byte[] result = ExclusiveCanonicalizer.serializeSubset(this.prefixList, context.getNodeset(), this.wc);
                context.setContent(result, "UTF-8");
                break;
            }
            default: {
                throw new RuntimeException("Internal Error: Unknown type: " + context.getType());
            }
        }
    }

    public void canonicalize(Node node, OutputStream stream) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(stream, "UTF-8");
        ExclusiveCanonicalizer.serializeSubset(null, node, this.wc, (Writer)wr);
        ((Writer)wr).flush();
    }
}

