/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.xml.dsig.AlgorithmFactory;
import com.ibm.xml.dsig.Canonicalizer;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.ProcessKey;
import com.ibm.xml.dsig.ReferenceProcessor;
import com.ibm.xml.dsig.ReferenceValidity;
import com.ibm.xml.dsig.SignatureContext;
import com.ibm.xml.dsig.SignatureMethod;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.Validity;
import com.ibm.xml.dsig.ValidityDOM;
import com.ibm.xml.dsig.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSignature {
    static final boolean DEBUG = false;
    public static final String XMLDSIG_NAMESPACE = "http://www.w3.org/2000/09/xmldsig#";
    static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/";
    public static final String TYPE_MANIFEST = "http://www.w3.org/2000/09/xmldsig#Manifest";
    public static final String TYPE_OBJECT = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static long signTime = 0L;
    public static long canonicalizeTime = 0L;

    private XSignature() {
    }

    static final Element getFirstChild(Node parent, String localPart) {
        return DOMUtil.getFirstChildElementNamed(parent, XMLDSIG_NAMESPACE, localPart);
    }

    static final boolean isDsigElement(Element element) {
        String ns = element.getNamespaceURI();
        if (ns == null) {
            return false;
        }
        return ns.equals(XMLDSIG_NAMESPACE);
    }

    static final boolean isDsigElement(Element element, String localPart) {
        String ns = element.getNamespaceURI();
        if (ns == null) {
            return false;
        }
        return ns.equals(XMLDSIG_NAMESPACE) && element.getLocalName().equals(localPart);
    }

    static byte[] getSignedInfoOctets(SignatureContext scontext, Element signedInfo) throws SignatureStructureException, NoSuchAlgorithmException, IOException {
        Element c14nMethod = XSignature.getFirstChild(signedInfo, "CanonicalizationMethod");
        if (c14nMethod == null) {
            throw new SignatureStructureException("No CanonicalizationMethod element.  This implementation always requires a CanonicalizationMethod.");
        }
        String c14nAlgorithm = c14nMethod.getAttribute("Algorithm");
        if (c14nAlgorithm == null || c14nAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the CanonicalizationMethod element.");
        }
        AlgorithmFactory afactory = scontext.getAlgorithmFactory();
        Canonicalizer c11r = afactory.getCanonicalizer(c14nAlgorithm);
        if (c11r == null) {
            throw new NoSuchAlgorithmException("No canonicalization algorithm: " + c14nAlgorithm);
        }
        c11r.setParameter(DOMUtil.getFirstChildElement(c14nMethod));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long startCanonicalize = System.currentTimeMillis();
        c11r.canonicalize(signedInfo, baos);
        canonicalizeTime += System.currentTimeMillis() - startCanonicalize;
        baos.close();
        byte[] result = baos.toByteArray();
        if (scontext.getResourceShower() != null) {
            scontext.getResourceShower().showSignedResource(scontext.getOwnerElement(), -1, "_SignedInfo_", null, result, null);
        }
        return result;
    }

    static SignatureMethod getSignatureMethod(Element signedInfo, AlgorithmFactory afactory) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException {
        Element signatureMethodElement = XSignature.getFirstChild(signedInfo, "SignatureMethod");
        if (signatureMethodElement == null) {
            throw new SignatureStructureException("No SignatureMethod element.");
        }
        String signatureAlgorithm = signatureMethodElement.getAttribute("Algorithm");
        if (signatureAlgorithm == null || signatureAlgorithm.length() == 0) {
            throw new SignatureStructureException("No Algorithm attribute in the SignatureMethod element.");
        }
        Integer param = null;
        if (signatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            Element hmacol = XSignature.getFirstChild(signatureMethodElement, "HMACOutputLength");
            if (hmacol != null) {
                int outputlength = Integer.parseInt(DOMUtil.getStringValue(hmacol));
                param = new Integer(outputlength);
            }
        } else if (signatureMethodElement.hasChildNodes()) {
            // empty if block
        }
        return afactory.getSignatureMethod(signatureAlgorithm, param);
    }

    public static void resetDigestTime() {
        ReferenceProcessor.digestTime = 0L;
    }

    public static long getDigestTime() {
        return ReferenceProcessor.digestTime;
    }

    static void calculateSignatureValue(Element signature, SignatureMethod signatureMethod, Key pkey, byte[] signedInfoOctets) throws SignatureStructureException, InvalidKeyException, SignatureException {
        long signStart = System.currentTimeMillis();
        signatureMethod.initSign(pkey);
        signatureMethod.update(signedInfoOctets);
        byte[] value = signatureMethod.sign();
        signTime += System.currentTimeMillis() - signStart;
        Element signatureValue = XSignature.getFirstChild(signature, "SignatureValue");
        if (signatureValue == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        DOMUtil.removeAllChildren(signatureValue);
        String strv = Base64.encode(value);
        Node prev = signatureValue.getPreviousSibling();
        if (prev != null && prev.getNodeType() == 3) {
            StringBuffer buffer = new StringBuffer();
            int ind = (prev.getNodeValue().length() - 1) * 2;
            buffer.append(Base64.format(strv, ind, "\n", ""));
            for (int i = 0; i < ind / 2; ++i) {
                buffer.append(" ");
            }
            strv = new String(buffer);
        }
        DOMUtil.appendText(signatureValue, strv);
    }

    static boolean verifySignatureValue(Element signature, SignatureMethod signatureMethod, Key pkey, byte[] signedInfoOctets) throws SignatureStructureException, InvalidKeyException, SignatureException {
        Element signatureValue = XSignature.getFirstChild(signature, "SignatureValue");
        if (signatureValue == null) {
            throw new SignatureStructureException("No SignatureValue element.");
        }
        byte[] valueInSignature = Base64.decode(DOMUtil.getStringValue(signatureValue));
        signatureMethod.initVerify(pkey);
        signatureMethod.update(signedInfoOctets);
        boolean ret = signatureMethod.verify(valueInSignature);
        return ret;
    }

    static Element internalSign(SignatureContext scontext, Key pkey) throws SignatureStructureException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException, TransformException, IOException {
        Element signedInfo;
        Element signature = scontext.getSignatureElement();
        IDResolverWrapper idr = null;
        if (scontext.getUseInternalIDResolver()) {
            idr = new IDResolverWrapper(signature.getOwnerDocument(), scontext.getIDResolver());
            Node ch = DOMUtil.getFirstChild2(signature);
            while (ch != null) {
                String id;
                Element el;
                if (ch.getNodeType() == 1 && XSignature.isDsigElement(el = (Element)ch) && XSignature.isDsigElement(el, "Object") && (id = el.getAttribute("Id")) != null && id.length() != 0) {
                    idr.registerID(id, el);
                }
                ch = DOMUtil.getNextSibling2(ch);
            }
            scontext.setWrappedIDResolver(idr);
        }
        if ((signedInfo = DOMUtil.getFirstChildElement(signature)) == null) {
            throw new SignatureStructureException("No SignedInfo element.");
        }
        int refno = 0;
        Element reference = XSignature.getFirstChild(signedInfo, "Reference");
        while (reference != null) {
            if (!XSignature.isDsigElement(reference, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + reference.getNodeName());
            }
            ReferenceProcessor.substDigest(scontext, reference, refno++);
            reference = DOMUtil.getNextElement(reference);
        }
        byte[] signedInfoOctets = XSignature.getSignedInfoOctets(scontext, signedInfo);
        if (pkey != null) {
            AlgorithmFactory afactory = scontext.getAlgorithmFactory();
            SignatureMethod signatureMethod = XSignature.getSignatureMethod(signedInfo, afactory);
            XSignature.calculateSignatureValue(signature, signatureMethod, pkey, signedInfoOctets);
            afactory.releaseSignatureMethod(signatureMethod);
        }
        return signature;
    }

    static Validity internalVerify(SignatureContext scontext, Key pkey) {
        Element signature = scontext.getSignatureElement();
        IDResolverWrapper idr = null;
        if (scontext.getUseInternalIDResolver()) {
            idr = new IDResolverWrapper(signature.getOwnerDocument(), scontext.getIDResolver());
        }
        ValidityDOM domv = new ValidityDOM();
        try {
            Node ch = DOMUtil.getFirstChild2(signature);
            while (ch != null) {
                Element el;
                if (ch.getNodeType() == 1 && XSignature.isDsigElement(el = (Element)ch)) {
                    String id;
                    if (XSignature.isDsigElement(el, "KeyInfo")) {
                        if (pkey == null) {
                            pkey = ProcessKey.processKeyInfo(scontext, el);
                        }
                    } else if (XSignature.isDsigElement(el, "Object") && idr != null && (id = el.getAttribute("Id")) != null && id.length() != 0) {
                        idr.registerID(id, el);
                    }
                }
                ch = DOMUtil.getNextSibling2(ch);
            }
            if (pkey == null) {
                throw new SignatureStructureException("No KeyInfo element.");
            }
            scontext.setWrappedIDResolver(idr);
            XSignature.verify2(scontext, domv, pkey);
        }
        catch (SignatureStructureException sse) {
            domv.setSignedInfoMessage(sse.getMessage());
        }
        catch (NoSuchAlgorithmException nsae) {
            domv.setSignedInfoMessage(nsae.getMessage());
        }
        catch (CertificateException ce) {
            domv.setSignedInfoMessage(ce.getMessage());
        }
        catch (InvalidKeySpecException ikse) {
            domv.setSignedInfoMessage(ikse.getMessage());
        }
        catch (IOException ioe) {
            domv.setSignedInfoMessage(ioe.getMessage());
        }
        catch (TransformException ioe) {
            domv.setSignedInfoMessage(ioe.getMessage());
        }
        domv.setCoreValidity();
        return domv;
    }

    private static void verify2(SignatureContext scontext, Verifier verifier, Key pkey) {
        boolean valid = false;
        try {
            Element signature = scontext.getSignatureElement();
            Element signedInfo = DOMUtil.getFirstChildElement(signature);
            if (signedInfo == null) {
                throw new SignatureStructureException("No SignedInfo element.");
            }
            int refno = 0;
            Element reference = XSignature.getFirstChild(signedInfo, "Reference");
            while (reference != null) {
                if (!XSignature.isDsigElement(reference, "Reference")) {
                    throw new SignatureStructureException("A Reference element is expected: " + reference.getNodeName());
                }
                ReferenceValidity rv = ReferenceProcessor.verify(scontext, reference, refno++);
                verifier.addReferenceValidity(rv);
                reference = DOMUtil.getNextElement(reference);
            }
            AlgorithmFactory afactory = scontext.getAlgorithmFactory();
            byte[] signedInfoOctets = XSignature.getSignedInfoOctets(scontext, signedInfo);
            SignatureMethod signatureMethod = XSignature.getSignatureMethod(signedInfo, afactory);
            valid = XSignature.verifySignatureValue(signature, signatureMethod, pkey, signedInfoOctets);
            afactory.releaseSignatureMethod(signatureMethod);
            if (!valid) {
                verifier.setSignedInfoMessage("SignatureValue mismatched.");
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.close();
            verifier.setSignedInfoMessage(sw.toString());
        }
        verifier.setSignedInfoValidity(valid);
    }

    static class IDResolverWrapper
    implements IDResolver {
        IDResolver next;
        Hashtable hash;
        Document doc;

        IDResolverWrapper(Document doc, IDResolver idr) {
            this.doc = doc;
            this.next = idr;
            this.hash = null;
        }

        void registerID(String id, Element el) {
            if (this.hash == null) {
                this.hash = new Hashtable();
            }
            this.hash.put(id, el);
        }

        public Element resolveID(Document doc, String id) {
            Element ret = null;
            if (doc == this.doc && this.hash != null && (ret = (Element)this.hash.get(id)) != null) {
                return ret;
            }
            if (this.next == null) {
                return null;
            }
            return this.next.resolveID(doc, id);
        }
    }

    static interface Verifier {
        public void addReferenceValidity(ReferenceValidity var1);

        public void setSignedInfoMessage(String var1);

        public void setSignedInfoValidity(boolean var1);
    }
}

