/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.dom.util.IndentConfig;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SignatureMethod {
    public static final String DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String HMAC = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";

    public abstract String getURI();

    public abstract void initSign(Key var1) throws InvalidKeyException;

    public abstract void initVerify(Key var1) throws InvalidKeyException;

    public abstract void update(byte[] var1) throws SignatureException;

    public abstract byte[] sign() throws SignatureException;

    public abstract boolean verify(byte[] var1) throws SignatureException;

    public Element createElement(Document factory) {
        return this.createElement(factory, null);
    }

    public Element createElement(Document factory, IndentConfig iconf) {
        Element signatureMethodElement = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
        signatureMethodElement.setAttribute("Algorithm", this.getURI());
        return signatureMethodElement;
    }

    static class SignatureMethodHMAC
    extends SignatureMethod {
        private MessageDigest digest = MessageDigest.getInstance("SHA");
        private int outputLength = -1;
        private static final int B = 64;
        private byte[] key_opad;
        static final byte[] MASK_BITS = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128};

        public void setParam(Object param) throws NoSuchAlgorithmException {
            if (param == null) {
                this.outputLength = -1;
            } else {
                Integer length = (Integer)param;
                int bitlength = length;
                if (bitlength <= 0) {
                    throw new NoSuchAlgorithmException("Output length is less than 1: " + bitlength);
                }
                this.outputLength = bitlength;
            }
        }

        public String getURI() {
            return SignatureMethod.HMAC;
        }

        public void initSign(Key privateKey) throws InvalidKeyException {
            this.init(privateKey);
        }

        public void initVerify(Key publicKey) throws InvalidKeyException {
            this.init(publicKey);
        }

        public void update(byte[] data) throws SignatureException {
            this.digest.update(data);
        }

        public byte[] sign() throws SignatureException {
            byte[] value1 = this.digest.digest();
            this.digest.reset();
            this.digest.update(this.key_opad);
            this.digest.update(value1);
            return this.mask(this.digest.digest());
        }

        public boolean verify(byte[] signature) throws SignatureException {
            return MessageDigest.isEqual(this.mask(signature), this.sign());
        }

        public Element createElement(Document factory, IndentConfig iconf) {
            Element elem = super.createElement(factory, iconf);
            if (this.outputLength > 0) {
                Element length = factory.createElementNS("http://www.w3.org/2000/09/xmldsig#", "HMACOutputLength");
                length.appendChild(factory.createTextNode(Integer.toString(this.outputLength)));
                DOMUtil.addIndent(elem, iconf, 3);
                elem.appendChild(length);
                DOMUtil.addIndent(elem, iconf, 2);
            }
            return elem;
        }

        private void init(Key key) {
            byte[] rawKey = key.getEncoded();
            byte[] normalizedKey = new byte[64];
            if (rawKey.length > 64) {
                this.digest.reset();
                rawKey = this.digest.digest(rawKey);
            }
            System.arraycopy(rawKey, 0, normalizedKey, 0, rawKey.length);
            for (int i = rawKey.length; i < 64; ++i) {
                normalizedKey[i] = 0;
            }
            byte[] key_ipad = new byte[64];
            this.key_opad = new byte[64];
            for (int i = 0; i < 64; ++i) {
                key_ipad[i] = (byte)(normalizedKey[i] ^ 0x36);
                this.key_opad[i] = (byte)(normalizedKey[i] ^ 0x5C);
            }
            this.digest.reset();
            this.digest.update(key_ipad);
        }

        private byte[] mask(byte[] in) {
            if (this.outputLength < 0) {
                return in;
            }
            int byteLen = (this.outputLength + 7) / 8;
            int extraBits = byteLen * 8 - this.outputLength;
            if (byteLen > in.length) {
                return in;
            }
            if (byteLen == in.length && extraBits == 0) {
                return in;
            }
            byte[] ret = new byte[byteLen];
            System.arraycopy(in, 0, ret, 0, byteLen);
            if (extraBits == 0) {
                return ret;
            }
            int n = byteLen - 1;
            ret[n] = (byte)(ret[n] & MASK_BITS[extraBits]);
            return ret;
        }
    }

    static class SignatureMethodImpl
    extends SignatureMethod {
        Signature signature;
        String uri;

        public SignatureMethodImpl(String name, String uri, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
            this.signature = provider == null ? Signature.getInstance(name) : Signature.getInstance(name, provider);
            this.uri = uri;
        }

        public String getURI() {
            return this.uri;
        }

        public void initSign(Key privateKey) throws InvalidKeyException {
            this.signature.initSign((PrivateKey)privateKey);
        }

        public void initVerify(Key publicKey) throws InvalidKeyException {
            this.signature.initVerify((PublicKey)publicKey);
        }

        public void update(byte[] data) throws SignatureException {
            this.signature.update(data);
        }

        public byte[] sign() throws SignatureException {
            if (this.uri.equals(SignatureMethod.DSA)) {
                return SignatureMethodImpl.decodeRSfromASN1(this.signature.sign());
            }
            return this.signature.sign();
        }

        public boolean verify(byte[] signature) throws SignatureException {
            if (this.uri.equals(SignatureMethod.DSA)) {
                return this.signature.verify(SignatureMethodImpl.encodeRSinASN1(signature));
            }
            return this.signature.verify(signature);
        }

        private static byte[] encodeRSinASN1(byte[] rs) {
            if (rs.length != 40) {
                System.err.println("DEBUG: r and s: " + rs.length + " Byte");
            }
            int s_index = rs.length / 2;
            int rlen = rs[0] < 0 ? 21 : 20;
            int slen = rs[s_index] < 0 ? 21 : 20;
            byte[] result = new byte[rlen + slen + 6];
            result[0] = 48;
            result[1] = (byte)(rlen + slen + 4);
            result[2] = 2;
            result[3] = (byte)rlen;
            if (rs[0] < 0) {
                result[4] = 0;
                System.arraycopy(rs, 0, result, 5, 20);
            } else {
                System.arraycopy(rs, 0, result, 4, 20);
            }
            result[4 + rlen] = 2;
            result[5 + rlen] = (byte)slen;
            if (rs[s_index] < 0) {
                result[6 + rlen] = 0;
                System.arraycopy(rs, s_index, result, 7 + rlen, rs.length - s_index);
            } else {
                System.arraycopy(rs, s_index, result, 6 + rlen, rs.length - s_index);
            }
            return result;
        }

        private static byte[] decodeRSfromASN1(byte[] asn) {
            int gap;
            byte rlength = asn[3];
            byte slength = asn[4 + rlength + 1];
            byte[] result = new byte[40];
            if (rlength < 20) {
                for (gap = 0; gap < 20 - rlength; ++gap) {
                    result[gap] = 0;
                }
                System.arraycopy(asn, 4, result, 20 - rlength, rlength);
            } else {
                System.arraycopy(asn, 4 + rlength - 20, result, 0, 20);
            }
            if (slength < 20) {
                for (gap = 0; gap < 20 - slength; ++gap) {
                    result[20 + gap] = 0;
                }
                System.arraycopy(asn, 4 + rlength + 2, result, 40 - slength, slength);
            } else {
                System.arraycopy(asn, 4 + rlength + 2 + slength - 20, result, 20, 20);
            }
            return result;
        }
    }
}

