/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.xml.dsig.AlgorithmFactory;
import com.ibm.xml.dsig.IDResolver;
import com.ibm.xml.dsig.KeyInfo;
import com.ibm.xml.dsig.KeyInfoGenerator;
import com.ibm.xml.dsig.ManifestProcessor;
import com.ibm.xml.dsig.NullURIHandler;
import com.ibm.xml.dsig.ProcessKey;
import com.ibm.xml.dsig.ReferenceProcessor;
import com.ibm.xml.dsig.ResourceShower;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.Validity;
import com.ibm.xml.dsig.XSignature;
import com.ibm.xml.dsig.XSignatureException;
import com.ibm.xml.dsig.util.XPathUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SignatureContext
implements ErrorHandler {
    static AlgorithmFactory algorithmFactory = new AlgorithmFactory(null);
    EntityResolver entityResolver = null;
    IDResolver idResolver = null;
    AlgorithmFactory aFactory = null;
    ResourceShower shower = null;
    NullURIHandler nullHandler = null;
    boolean useInternalIDResolver = true;
    IDResolver wrappedIDResolver = null;
    boolean verifyManifest = false;
    Element signature;
    Element owner;

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public IDResolver getIDResolver() {
        return this.idResolver;
    }

    public void setIDResolver(IDResolver resolver) {
        this.idResolver = resolver;
    }

    void setWrappedIDResolver(IDResolver resolver) {
        this.wrappedIDResolver = resolver;
    }

    IDResolver getIDResolver0() {
        return this.wrappedIDResolver != null ? this.wrappedIDResolver : this.idResolver;
    }

    public AlgorithmFactory getAlgorithmFactory() {
        return this.aFactory == null ? algorithmFactory : this.aFactory;
    }

    public void setAlgorithmFactory(AlgorithmFactory factory) {
        this.aFactory = factory;
    }

    public ResourceShower getResourceShower() {
        return this.shower;
    }

    public void setResourceShower(ResourceShower shower) {
        this.shower = shower;
    }

    public NullURIHandler getNullURIHandler() {
        return this.nullHandler;
    }

    public void setNullURIHandler(NullURIHandler nuh) {
        this.nullHandler = nuh;
    }

    public boolean getUseInternalIDResolver() {
        return this.useInternalIDResolver;
    }

    public void setUseInternalIDResolver(boolean use) {
        this.useInternalIDResolver = use;
    }

    Element getSignatureElement() {
        return this.signature;
    }

    Element setSignatureElement(Element newSig) {
        Element prev = this.signature;
        this.signature = newSig;
        return prev;
    }

    Element getOwnerElement() {
        return this.owner;
    }

    Element setOwnerElement(Element newOwner) {
        Element prevOwner = this.owner;
        this.owner = newOwner;
        return prevOwner;
    }

    public Element sign(Element signature, Key pkey) throws XSignatureException {
        this.signature = signature;
        this.owner = signature;
        try {
            return XSignature.internalSign(this, pkey);
        }
        catch (Exception ex) {
            throw new XSignatureException(ex);
        }
    }

    public Validity verify(Element signature, Key pkey) {
        this.signature = signature;
        this.owner = signature;
        return XSignature.internalVerify(this, pkey);
    }

    public Element digestManifest(Element manifest) throws XSignatureException {
        this.signature = null;
        this.owner = manifest;
        try {
            return ManifestProcessor.digest(this);
        }
        catch (Exception ex) {
            throw new XSignatureException(ex);
        }
    }

    public Validity verifyManifest(Element manifest) {
        this.signature = null;
        this.owner = manifest;
        return ManifestProcessor.verify(this);
    }

    public static void setKeyInfo(Element signature, KeyInfoGenerator keyGen) throws SignatureStructureException {
        ProcessKey.setKeyInfo(signature, keyGen);
    }

    protected Document parse(InputSource src) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = this.getAlgorithmFactory().getDocumentBuilder();
        if (this.entityResolver != null) {
            builder.setEntityResolver(this.entityResolver);
        }
        builder.setErrorHandler(this);
        Document doc = builder.parse(src);
        this.getAlgorithmFactory().releaseDocumentBuilder(builder);
        XPathUtil.fixTree(doc);
        return doc;
    }

    private Document parse(byte[] octets) throws IOException, TransformException {
        try {
            return this.parse(new InputSource(new ByteArrayInputStream(octets)));
        }
        catch (SAXException se) {
            throw TransformException.create(se);
        }
        catch (ParserConfigurationException pce) {
            throw TransformException.create(pce);
        }
    }

    private Element parseWithConfirmingRoot(byte[] octets, String expected) throws SignatureStructureException, IOException, TransformException {
        Document doc = this.parse(octets);
        Element root = doc.getDocumentElement();
        if (!XSignature.isDsigElement(root, expected)) {
            throw new SignatureStructureException("Type mismatch: Type=" + expected + ", root=" + root.getNodeName());
        }
        return root;
    }

    public Object retrieve(Element retrieve) throws XSignatureException {
        try {
            byte[] octets;
            this.signature = null;
            this.owner = retrieve;
            Object result = octets = ReferenceProcessor.getTransformedOctets(this, retrieve.getOwnerDocument(), retrieve, -1);
            Attr typeAttr = retrieve.getAttributeNode("Type");
            if (typeAttr == null) {
                return result;
            }
            String type = typeAttr.getNodeValue();
            if (type.equals("http://www.w3.org/2000/09/xmldsig#X509Data")) {
                Element root = this.parseWithConfirmingRoot(octets, "X509Data");
                result = new KeyInfo.X509Data(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#PGPData")) {
                Element root = this.parseWithConfirmingRoot(octets, "PGPData");
                result = new KeyInfo.PGPData(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#SPKIData")) {
                Element root = this.parseWithConfirmingRoot(octets, "SPKIData");
                result = new KeyInfo.SPKIData(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#MgmtData")) {
                Element root = this.parseWithConfirmingRoot(octets, "MgmgtData");
                result = DOMUtil.getStringValue(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#rawX509Certificate")) {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream is = new ByteArrayInputStream(octets);
                X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
                result = cert;
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#DSAKeyValue")) {
                Element root = this.parseWithConfirmingRoot(octets, "DSAKeyValue");
                result = ProcessKey.createDSAKey(root);
            } else if (type.equals("http://www.w3.org/2000/09/xmldsig#RSAKeyValue")) {
                Element root = this.parseWithConfirmingRoot(octets, "RSAKeyValue");
                result = ProcessKey.createRSAKey(root);
            }
            return result;
        }
        catch (Exception ex) {
            throw new XSignatureException(ex);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public boolean isDebug() {
        return false;
    }
}

