/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.dsig;

import com.ibm.dom.util.DOMUtil;
import com.ibm.xml.dsig.ReferenceProcessor;
import com.ibm.xml.dsig.ReferenceValidity;
import com.ibm.xml.dsig.SignatureContext;
import com.ibm.xml.dsig.SignatureStructureException;
import com.ibm.xml.dsig.TransformException;
import com.ibm.xml.dsig.Validity;
import com.ibm.xml.dsig.ValidityDOM;
import com.ibm.xml.dsig.XSignature;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ManifestProcessor {
    private ManifestProcessor() {
    }

    static Element digest(SignatureContext scontext) throws SignatureStructureException, TransformException, IOException, NoSuchAlgorithmException, NoSuchProviderException {
        int refno = 0;
        Element reference = DOMUtil.getFirstChildElement(scontext.getOwnerElement());
        while (reference != null) {
            if (!XSignature.isDsigElement(reference, "Reference")) {
                throw new SignatureStructureException("A Reference element is expected: " + reference.getNodeName());
            }
            ReferenceProcessor.substDigest(scontext, reference, refno++);
            reference = DOMUtil.getNextElement(reference);
        }
        return scontext.getOwnerElement();
    }

    static Validity verify(SignatureContext scontext) {
        ValidityDOM domv = new ValidityDOM();
        int refno = 0;
        try {
            block6: for (Node child = scontext.getOwnerElement().getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getNodeType()) {
                    case 3: 
                    case 7: 
                    case 8: {
                        continue block6;
                    }
                    case 1: {
                        Element reference = (Element)child;
                        if (XSignature.isDsigElement(reference, "Reference")) {
                            ReferenceValidity rv = ReferenceProcessor.verify(scontext, reference, refno++);
                            domv.addReferenceValidity(rv);
                            continue block6;
                        }
                    }
                    default: {
                        throw new SignatureStructureException("Invalid node in the Manifest element:" + child.getNodeName());
                    }
                }
            }
        }
        catch (SignatureStructureException sse) {
            domv.setSignedInfoMessage(sse.getMessage());
        }
        domv.setSignedInfoValidity(true);
        domv.setSignedInfoMessage("N/A");
        domv.setCoreValidity();
        return domv;
    }
}

